/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.TenantUtils;
import java.util.Collections;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TenantUtilsTest {
    TenantUtilsTest() {
    }

    @Test
    void testExtractTenantPrefix() {
        Assertions.assertEquals((Object)"lkc-8vgl6g2_", (Object)TenantUtils.extractTenantPrefix((String)"lkc-8vgl6g2_console-consumer", (boolean)true));
        Assertions.assertEquals((Object)"lkc-8vgl6g2_", (Object)TenantUtils.extractTenantPrefix((String)"lkc-8vgl6g2_bla", (boolean)true));
        Assertions.assertNull((Object)TenantUtils.extractTenantPrefix((String)"lkc-8vg", (boolean)true));
        Assertions.assertNull((Object)TenantUtils.extractTenantPrefix((String)"not_a_tenant", (boolean)true));
        Assertions.assertEquals((Object)"lkc-8vgl6g2", (Object)TenantUtils.extractTenantPrefix((String)"lkc-8vgl6g2_console-consumer", (boolean)false));
        Assertions.assertEquals((Object)"lkc-8vgl6g2", (Object)TenantUtils.extractTenantPrefix((String)"lkc-8vgl6g2_bla", (boolean)false));
        Assertions.assertNull((Object)TenantUtils.extractTenantPrefix((String)"lkc-8vg", (boolean)false));
        Assertions.assertNull((Object)TenantUtils.extractTenantPrefix((String)"not_a_tenant", (boolean)false));
    }

    @Test
    void testExtractTenantId() {
        Assertions.assertEquals(Optional.of("lkc-8vgl6g2"), (Object)TenantUtils.extractTenantId(Collections.singleton("lkc-8vgl6g2_console-consumer")));
        Assertions.assertEquals(Optional.of("lkc-8vgl6g2"), (Object)TenantUtils.extractTenantId(Collections.singleton("lkc-8vgl6g2_bla")));
        Assertions.assertEquals(Optional.empty(), (Object)TenantUtils.extractTenantId(Collections.singleton("lkc-8vg")));
        Assertions.assertEquals(Optional.empty(), (Object)TenantUtils.extractTenantId(Collections.singleton("not_a_tenant")));
    }
}

