/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.metadata.TopicPlacement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class TopicPlacementTest {
    private TopicPlacement getTopicPlacement(String placementJson) {
        return (TopicPlacement)TopicPlacement.parse((String)placementJson).orElseThrow(() -> {
            throw new RuntimeException("Invalid topic placement json: " + placementJson);
        });
    }

    @Test
    public void testAttributeRackMatches() {
        String json = "{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"abc\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"def\"}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertTrue((boolean)topicPlacement.matchesReplicas(Collections.singletonMap("rack", "abc")));
        Assertions.assertTrue((boolean)topicPlacement.matchesObservers(Collections.singletonMap("rack", "def")));
    }

    @Test
    public void testAttributeRackMatchingEmptyReplicaConstraints() {
        String json = "{ \"version\": 1, \"replicas\": [{\"count\": 1}] }";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertTrue((boolean)topicPlacement.matchesReplicas(Collections.singletonMap("rack", "abc")));
        Assertions.assertTrue((boolean)topicPlacement.matchesReplicas(Collections.emptyMap()));
    }

    @Test
    public void testAttributeRackMatchingEmptyReplicaAndObserverConstraints() {
        String json = "{ \"version\": 1, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}] }";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertTrue((boolean)topicPlacement.matchesReplicas(Collections.singletonMap("rack", "abc")));
        Assertions.assertTrue((boolean)topicPlacement.matchesReplicas(Collections.emptyMap()));
        Assertions.assertTrue((boolean)topicPlacement.matchesObservers(Collections.singletonMap("rack", "def")));
        Assertions.assertTrue((boolean)topicPlacement.matchesObservers(Collections.emptyMap()));
    }

    @Test
    public void testSupportsVersion2() {
        String json = "{ \"version\": 2, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}] }";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertEquals((int)2, (int)topicPlacement.version());
    }

    @Test
    public void testDoesNotSupportsVersionGreaterThan2() {
        String json = "{ \"version\": 3, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}] }";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(json));
    }

    @Test
    public void testVersion1DoesNotSupportObserverPromotionPolicy() {
        String json = "{ \"version\": 1, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}], \"observerPromotionPolicy\":\"under-replicated\"}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(json));
    }

    @Test
    public void testObserverPromotionPolicyDefaultsWithV1() {
        String json = "{ \"version\": 1, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}] }";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertEquals((Object)TopicPlacement.ObserverPromotionPolicy.LEADER_IS_OBSERVER, (Object)topicPlacement.observerPromotionPolicy());
    }

    @Test
    public void testObserverPromotionPolicyOverridesLeaderIsObserverWithV2() {
        String json = "{ \"version\": 2, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}], \"observerPromotionPolicy\":\"leader-is-observer\" }";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertEquals((Object)TopicPlacement.ObserverPromotionPolicy.LEADER_IS_OBSERVER, (Object)topicPlacement.observerPromotionPolicy());
    }

    @Test
    public void testObserverPromotionPolicyOverridesUnderReplicatedWithV2() {
        String json = "{ \"version\": 2, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}], \"observerPromotionPolicy\":\"under-replicated\" }";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertEquals((Object)TopicPlacement.ObserverPromotionPolicy.UNDER_REPLICATED, (Object)topicPlacement.observerPromotionPolicy());
    }

    @Test
    public void testObserverPromotionPolicyOverridesUnderMinIsrWithV2() {
        String json = "{ \"version\": 2, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}], \"observerPromotionPolicy\":\"under-min-isr\" }";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertEquals((Object)TopicPlacement.ObserverPromotionPolicy.UNDER_MIN_ISR, (Object)topicPlacement.observerPromotionPolicy());
    }

    @Test
    public void testInvalidObserverPromotionPolicyThrowsWithV2() {
        String json = "{ \"version\": 2, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}], \"observerPromotionPolicy\":\"invalid-policy\" }";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(json));
    }

    @Test
    public void testObserverPromotionPolicyDefaultsWithV2() {
        String json = "{ \"version\": 2, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}] }";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertEquals((Object)TopicPlacement.ObserverPromotionPolicy.UNDER_MIN_ISR, (Object)topicPlacement.observerPromotionPolicy());
    }

    @Test
    public void testDoesNotSupportsVersionLessThan1() {
        String json = "{ \"version\": 0, \"replicas\": [{\"count\": 1}], \"observers\": [{\"count\": 1}] }";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(json));
    }

    @Test
    public void testFailsWithEmptyConstraints() {
        String json = "{\"version\": 1}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(json));
    }

    @Test
    public void testFailsWithEmptyReplicas() {
        String input = "{\"version\":1,\"replicas\":null}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(input));
    }

    @Test
    public void testFailsWithOnlyObservers() {
        String input = "{\"version\":1,\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"def\"}}]}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(input));
    }

    @Test
    public void testFailsWithEmptyReplicasAndObservers() {
        String input = "{\"version\":1,\"replicas\":null,\"observers\":null}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(input));
    }

    @Test
    public void testAttributeRackDoesNotMatch() {
        String json = "{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"abc\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"def\"}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertFalse((boolean)topicPlacement.matchesReplicas(Collections.singletonMap("rack", "def")));
        Assertions.assertFalse((boolean)topicPlacement.matchesReplicas(Collections.singletonMap("rack", "not_match")));
        Assertions.assertFalse((boolean)topicPlacement.matchesReplicas(Collections.emptyMap()));
        Assertions.assertFalse((boolean)topicPlacement.matchesObservers(Collections.singletonMap("rack", "abc")));
        Assertions.assertFalse((boolean)topicPlacement.matchesObservers(Collections.singletonMap("rack", "not_match")));
        Assertions.assertFalse((boolean)topicPlacement.matchesObservers(Collections.emptyMap()));
    }

    @Test
    public void testBasicParsingFailures() {
        String missingVersion = "{\"replicas\":[{\"constraints\":{\"rack\":\"abc\"}}],\"observers\":[{\"constraints\":{\"rack\":\"def\"}}]}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(missingVersion));
        String unknownFields = "{\"version\": 1, \"unknown\": \"unknown\"}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(unknownFields));
        String unknownVersion = "{\"version\": 2}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(unknownVersion));
    }

    @Test
    public void testValidation() {
        String missingReplicaConstraint = "{\"version\":1,\"observers\":[{\"constraints\":{\"rack\":\"def\"}}]}";
        Assertions.assertThrows(ConfigException.class, () -> TopicPlacement.VALIDATOR.ensureValid("property.name", (Object)missingReplicaConstraint));
    }

    @Test
    public void testPlacementConstraintPredicateSuccess() {
        Map<String, String> replicaBroker = Collections.singletonMap("rack", "east-1");
        Map<String, String> observerBroker = Collections.singletonMap("rack", "west-1");
        String placementJson = "{\"version\": 1, \"replicas\": [{\"count\": 2, \"constraints\": {\"rack\": \"east-1\"}},{\"count\": 1, \"constraints\": {\"rack\": \"east-2\"}}],\"observers\": [{\"count\": 1, \"constraints\": {\"rack\": \"west-1\"}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(placementJson);
        Assertions.assertTrue((boolean)topicPlacement.matchesReplicas(replicaBroker));
        Assertions.assertTrue((boolean)topicPlacement.matchesObservers(observerBroker));
    }

    @Test
    public void testPlacementConstraintPredicateFailure() {
        Map<String, String> broker = Collections.singletonMap("rack", "south-1");
        String placementJson = "{\"version\": 1, \"replicas\": [{\"count\": 2, \"constraints\": {\"rack\": \"east-1\"}},{\"count\": 1, \"constraints\": {\"rack\": \"east-2\"}}],\"observers\": [{\"count\": 1, \"constraints\": {\"rack\": \"west-1\"}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(placementJson);
        Assertions.assertFalse((boolean)topicPlacement.matchesReplicas(broker));
        Assertions.assertFalse((boolean)topicPlacement.matchesObservers(broker));
    }

    @Test
    public void testPlacementConstraintPredicateNoBrokerRack() {
        String placementJson = "{\"version\": 1, \"replicas\": [{\"count\": 2, \"constraints\": {\"rack\": \"east-1\"}},{\"count\": 1, \"constraints\": {\"rack\": \"east-2\"}}],\"observers\": [{\"count\": 1, \"constraints\": {\"rack\": \"west-1\"}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(placementJson);
        Assertions.assertFalse((boolean)topicPlacement.matchesReplicas(Collections.emptyMap()));
        Assertions.assertFalse((boolean)topicPlacement.matchesObservers(Collections.emptyMap()));
    }

    @Test
    public void testJSONSerialization() {
        String placementJson = "{\"version\": 1,%n  \"replicas\": [%n    {%n      \"count\": 2,%n      \"constraints\": {\"rack\": \"rack-1\"}%n    }%n  ],%n  \"observers\":[%n    {%n      \"count\": 1,%n      \"constraints\": {\"rack\": \"rack-2\"}%n    }%n  ]%n}";
        String platformIndependentJson = String.format(placementJson, new Object[0]);
        TopicPlacement tp = this.getTopicPlacement(platformIndependentJson);
        String serializedJson = tp.toJson();
        Assertions.assertTrue((serializedJson.length() < platformIndependentJson.length() ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyStringParsesToEmptyTopicPlacement() {
        Assertions.assertEquals((Object)false, (Object)TopicPlacement.parse((String)"").isPresent());
    }

    @Test
    public void testSuccessfulHandlingOfNullProperties() {
        String input = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":null}],\"observers\":[{\"count\":1,\"constraints\":null}]}";
        TopicPlacement placement = this.getTopicPlacement(input);
        Assertions.assertTrue((boolean)placement.replicas().stream().allMatch(constraint -> constraint.constraints().isEmpty()));
        Assertions.assertTrue((boolean)placement.observers().stream().allMatch(constraint -> constraint.constraints().isEmpty()));
        input = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":null}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":null}}]}";
        placement = this.getTopicPlacement(input);
        Assertions.assertTrue((boolean)placement.replicas().stream().allMatch(constraint -> constraint.constraints().isEmpty()));
        Assertions.assertTrue((boolean)placement.observers().stream().allMatch(constraint -> constraint.constraints().isEmpty()));
    }

    @Test
    public void testMissingReplicaCount() {
        String placementJson = "{\"version\": 1, \"replicas\": [{\"constraints\": {\"rack\": \"east-1\"}},{\"constraints\": {\"rack\": \"east-2\"}}],\"observers\": [{\"constraints\": {\"rack\": \"west-1\"}}]}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(placementJson));
    }

    @Test
    public void testMissingObserverCount() {
        String placementJson = "{\"version\": 1, \"replicas\": [{\"count\": 2, \"constraints\": {\"rack\": \"east-1\"}},{\"count\": 1, \"constraints\": {\"rack\": \"east-2\"}}],\"observers\": [{\"constraints\": {\"rack\": \"west-1\"}}]}";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement(placementJson));
    }

    @Test
    public void testFailsWithStringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement("null"));
    }

    @Test
    public void testFailsWithEmptyJsonObject() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getTopicPlacement("{}"));
    }

    @Test
    public void testObserverPromotionPolicyNotSerializedV1() {
        String json = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{}}],\"observers\":[{\"count\":1,\"constraints\":{}}]}";
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertEquals((Object)json, (Object)topicPlacement.toJson());
    }

    @Test
    public void testIsSubset() {
        Assertions.assertTrue((boolean)TopicPlacement.ConstraintCount.isSubset((Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
            }
        }));
        Assertions.assertTrue((boolean)TopicPlacement.ConstraintCount.isSubset((Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
                this.put("az", "us-east-1a");
            }
        }));
        Assertions.assertTrue((boolean)TopicPlacement.ConstraintCount.isSubset((Map)new HashMap<String, String>(){
            {
                this.put("rack", null);
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("rack", null);
            }
        }));
        Assertions.assertTrue((boolean)TopicPlacement.ConstraintCount.isSubset(new HashMap(), (Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
                this.put("az", "us-east-1a");
            }
        }));
        Assertions.assertTrue((boolean)TopicPlacement.ConstraintCount.isSubset(new HashMap(), (Map)new HashMap<String, String>(){
            {
                this.put("rack", null);
            }
        }));
        Assertions.assertTrue((boolean)TopicPlacement.ConstraintCount.isSubset(new HashMap(), new HashMap()));
        Assertions.assertFalse((boolean)TopicPlacement.ConstraintCount.isSubset((Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-west-2");
            }
        }));
        Assertions.assertFalse((boolean)TopicPlacement.ConstraintCount.isSubset((Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("rack", null);
            }
        }));
        Assertions.assertFalse((boolean)TopicPlacement.ConstraintCount.isSubset((Map)new HashMap<String, String>(){
            {
                this.put("rack", null);
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
            }
        }));
        Assertions.assertFalse((boolean)TopicPlacement.ConstraintCount.isSubset((Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("notRack", "us-east-1");
            }
        }));
        Assertions.assertFalse((boolean)TopicPlacement.ConstraintCount.isSubset((Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("az", "us-east-1a");
            }
        }));
        Assertions.assertFalse((boolean)TopicPlacement.ConstraintCount.isSubset((Map)new HashMap<String, String>(){
            {
                this.put("rack", "us-east-1");
            }
        }, new HashMap()));
    }

    @Test
    public void testValidateAssignment() {
        String json = "{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"0\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"0\"}}]}";
        HashMap<String, String> rack0 = new HashMap<String, String>();
        rack0.put("rack", "0");
        TopicPlacement.Replica syncReplica = TopicPlacement.Replica.of((int)0, Optional.of(rack0));
        TopicPlacement.Replica observer = TopicPlacement.Replica.of((int)1, Optional.of(rack0));
        TopicPlacement topicPlacement = this.getTopicPlacement(json);
        Assertions.assertFalse((boolean)TopicPlacement.validateAssignment((TopicPlacement)topicPlacement, Arrays.asList(syncReplica), Arrays.asList(observer)).isPresent());
        HashMap<String, String> rack1 = new HashMap<String, String>();
        rack1.put("rack", "1");
        syncReplica = TopicPlacement.Replica.of((int)0, Optional.of(rack0));
        observer = TopicPlacement.Replica.of((int)1, Optional.of(rack1));
        Assertions.assertTrue((boolean)TopicPlacement.validateAssignment((TopicPlacement)topicPlacement, Arrays.asList(syncReplica), Arrays.asList(observer)).isPresent());
        syncReplica = TopicPlacement.Replica.of((int)0, Optional.of(rack1));
        observer = TopicPlacement.Replica.of((int)1, Optional.of(rack0));
        Assertions.assertTrue((boolean)TopicPlacement.validateAssignment((TopicPlacement)topicPlacement, Arrays.asList(syncReplica), Arrays.asList(observer)).isPresent());
    }
}

