/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.VersionedBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.VersionedKeyValueStoreBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStoreMaterializer<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueStoreMaterializer.class);
    private final MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materialized;

    public KeyValueStoreMaterializer(MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        this.materialized = materialized;
    }

    public StoreBuilder<?> materialize() {
        KeyValueBytesStoreSupplier supplier = (KeyValueBytesStoreSupplier)this.materialized.storeSupplier();
        if (supplier == null) {
            switch (this.materialized.storeType()) {
                case IN_MEMORY: {
                    supplier = Stores.inMemoryKeyValueStore(this.materialized.storeName());
                    break;
                }
                case ROCKS_DB: {
                    supplier = Stores.persistentTimestampedKeyValueStore(this.materialized.storeName());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown store type: " + (Object)((Object)this.materialized.storeType()));
                }
            }
        }
        StoreBuilder<StateStore> builder = supplier instanceof VersionedBytesStoreSupplier ? Stores.versionedKeyValueStoreBuilder((VersionedBytesStoreSupplier)supplier, this.materialized.keySerde(), this.materialized.valueSerde()) : Stores.timestampedKeyValueStoreBuilder(supplier, this.materialized.keySerde(), this.materialized.valueSerde());
        if (this.materialized.loggingEnabled()) {
            builder.withLoggingEnabled(this.materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (this.materialized.cachingEnabled()) {
            if (!(builder instanceof VersionedKeyValueStoreBuilder)) {
                builder.withCachingEnabled();
            } else {
                LOG.info("Not enabling caching for store '{}' as versioned stores do not support caching.", (Object)supplier.name());
            }
        }
        return builder;
    }
}

