/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.client;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;

@Immutable
public final class BasicCredentials {
    private final String username;
    private final String password;

    public static BasicCredentials of(String username, String password) {
        return new BasicCredentials(username, password);
    }

    private BasicCredentials(String username, String password) {
        this.username = Objects.requireNonNull(username, "username");
        this.password = Objects.requireNonNull(password, "password");
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicCredentials that = (BasicCredentials)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }
}

