/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.client;

import com.fasterxml.jackson.databind.Module;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.parser.json.KsqlTypesDeserializationModule;
import io.confluent.ksql.properties.LocalProperties;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.confluent.ksql.rest.client.BasicCredentials;
import io.confluent.ksql.rest.client.KsqlTarget;
import io.confluent.ksql.rest.client.exception.KsqlRestClientException;
import io.confluent.ksql.util.VertxSslOptionsFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.SocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class KsqlClient
implements AutoCloseable {
    public static final String SSL_KEYSTORE_ALIAS_CONFIG = "ssl.keystore.alias";
    private final Vertx vertx;
    private final HttpClient httpNonTlsClient;
    private final HttpClient httpTlsClient;
    private final Optional<HttpClient> httpNonTlsClientHttp2;
    private final Optional<HttpClient> httpTlsClientHttp2;
    private final LocalProperties localProperties;
    private final Optional<String> basicAuthHeader;
    private final BiFunction<Integer, String, SocketAddress> socketAddressFactory;
    private final boolean ownedVertx;

    public KsqlClient(Map<String, String> clientProps, Optional<BasicCredentials> credentials, LocalProperties localProperties, HttpClientOptions httpClientOptions, Optional<HttpClientOptions> httpClientOptionsHttp2) {
        this.vertx = Vertx.vertx();
        this.basicAuthHeader = KsqlClient.createBasicAuthHeader(Objects.requireNonNull(credentials, "credentials"));
        this.localProperties = Objects.requireNonNull(localProperties, "localProperties");
        this.socketAddressFactory = SocketAddress::inetSocketAddress;
        this.httpNonTlsClient = KsqlClient.createHttpClient(this.vertx, clientProps, httpClientOptions, false);
        this.httpTlsClient = KsqlClient.createHttpClient(this.vertx, clientProps, httpClientOptions, true);
        this.httpNonTlsClientHttp2 = httpClientOptionsHttp2.map(options -> KsqlClient.createHttpClient(this.vertx, clientProps, KsqlClient.validateHttp2(options), false));
        this.httpTlsClientHttp2 = httpClientOptionsHttp2.map(options -> KsqlClient.createHttpClient(this.vertx, clientProps, KsqlClient.validateHttp2(options), true));
        this.ownedVertx = true;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public KsqlClient(Optional<BasicCredentials> credentials, LocalProperties localProperties, Function<Boolean, HttpClientOptions> httpClientOptionsFactory, Function<Boolean, HttpClientOptions> httpClientOptionsFactory2, BiFunction<Integer, String, SocketAddress> socketAddressFactory, Vertx vertx) {
        this.vertx = vertx;
        this.basicAuthHeader = KsqlClient.createBasicAuthHeader(Objects.requireNonNull(credentials, "credentials"));
        this.localProperties = Objects.requireNonNull(localProperties, "localProperties");
        this.socketAddressFactory = Objects.requireNonNull(socketAddressFactory, "socketAddressFactory");
        this.httpNonTlsClient = KsqlClient.createHttpClient(vertx, httpClientOptionsFactory, false);
        this.httpTlsClient = KsqlClient.createHttpClient(vertx, httpClientOptionsFactory, true);
        this.httpNonTlsClientHttp2 = Optional.of(KsqlClient.createHttpClient(vertx, KsqlClient.validateHttp2(httpClientOptionsFactory2), false));
        this.httpTlsClientHttp2 = Optional.of(KsqlClient.createHttpClient(vertx, KsqlClient.validateHttp2(httpClientOptionsFactory2), true));
        this.ownedVertx = false;
    }

    public KsqlTarget target(URI server) {
        return this.target(server, Collections.emptyMap());
    }

    public KsqlTarget target(URI server, Map<String, String> additionalHeaders) {
        boolean isUriTls = server.getScheme().equalsIgnoreCase("https");
        HttpClient client = isUriTls ? this.httpTlsClient : this.httpNonTlsClient;
        return new KsqlTarget(client, this.socketAddressFactory.apply(server.getPort(), server.getHost()), this.localProperties, this.basicAuthHeader, server.getHost(), server.getPath(), additionalHeaders, -1L);
    }

    public KsqlTarget targetHttp2(URI server) {
        boolean isUriTls = server.getScheme().equalsIgnoreCase("https");
        HttpClient client = (isUriTls ? this.httpTlsClientHttp2 : this.httpNonTlsClientHttp2).orElseThrow(() -> new IllegalStateException("Must provide http2 options to use targetHttp2"));
        return new KsqlTarget(client, this.socketAddressFactory.apply(server.getPort(), server.getHost()), this.localProperties, this.basicAuthHeader, server.getHost(), server.getPath(), Collections.emptyMap(), -1L);
    }

    @VisibleForTesting
    public static void initialize() {
        ApiJsonMapper.INSTANCE.get().registerModule((Module)new KsqlTypesDeserializationModule());
    }

    @Override
    public void close() {
        try {
            this.httpTlsClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.httpNonTlsClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.vertx != null && this.ownedVertx) {
            this.vertx.close();
        }
    }

    private static Optional<String> createBasicAuthHeader(Optional<BasicCredentials> credentials) {
        return credentials.map(basicCredentials -> "Basic " + Base64.getEncoder().encodeToString((basicCredentials.username() + ":" + basicCredentials.password()).getBytes(StandardCharsets.UTF_8)));
    }

    private static HttpClient createHttpClient(Vertx vertx, Map<String, String> clientProps, HttpClientOptions httpClientOptions, boolean tls) {
        if (tls) {
            httpClientOptions.setSsl(true);
            KsqlClient.configureHostVerification(clientProps, httpClientOptions);
            Optional trustStoreOptions = VertxSslOptionsFactory.getJksTrustStoreOptions(clientProps);
            if (trustStoreOptions.isPresent()) {
                httpClientOptions.setTrustStoreOptions((JksOptions)trustStoreOptions.get());
                String alias = clientProps.get(SSL_KEYSTORE_ALIAS_CONFIG);
                Optional keyStoreOptions = VertxSslOptionsFactory.buildJksKeyStoreOptions(clientProps, Optional.ofNullable(alias));
                keyStoreOptions.ifPresent(options -> httpClientOptions.setKeyStoreOptions(options));
            }
        }
        try {
            return vertx.createHttpClient(httpClientOptions);
        }
        catch (VertxException e) {
            throw new KsqlRestClientException(e.getMessage(), e);
        }
    }

    private static HttpClient createHttpClient(Vertx vertx, Function<Boolean, HttpClientOptions> httpClientOptionsFactory, boolean tls) {
        try {
            return vertx.createHttpClient(httpClientOptionsFactory.apply(tls));
        }
        catch (VertxException e) {
            throw new KsqlRestClientException(e.getMessage(), e);
        }
    }

    private static void configureHostVerification(Map<String, String> clientProps, HttpClientOptions httpClientOptions) {
        String endpointIdentificationAlg = clientProps.get("ssl.endpoint.identification.algorithm");
        if (!Strings.isNullOrEmpty((String)endpointIdentificationAlg)) {
            if (!endpointIdentificationAlg.toLowerCase().equals("https")) {
                throw new IllegalArgumentException("Config 'ssl.endpoint.identification.algorithm' must be either 'https' or empty. Got: " + endpointIdentificationAlg);
            }
            httpClientOptions.setVerifyHost(true);
            return;
        }
        httpClientOptions.setVerifyHost(false);
    }

    private static HttpClientOptions validateHttp2(HttpClientOptions httpClientOptions) {
        if (httpClientOptions.getProtocolVersion() != HttpVersion.HTTP_2) {
            throw new IllegalArgumentException("Expecting http2 protocol version");
        }
        return httpClientOptions;
    }

    private static Function<Boolean, HttpClientOptions> validateHttp2(Function<Boolean, HttpClientOptions> httpClientOptionsFactory) {
        return tls -> KsqlClient.validateHttp2((HttpClientOptions)httpClientOptionsFactory.apply((Boolean)tls));
    }

    static {
        KsqlClient.initialize();
    }
}

