/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.client.ResponseWithBody;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.client.exception.KsqlRestClientException;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.buffer.Buffer;
import java.util.Optional;
import java.util.function.Function;
import javax.naming.AuthenticationException;

public final class KsqlClientUtil {
    private KsqlClientUtil() {
    }

    public static <T> RestResponse<T> toRestResponse(ResponseWithBody resp, String path, Function<ResponseWithBody, T> mapper) {
        int statusCode = resp.getResponse().statusCode();
        return statusCode == HttpResponseStatus.OK.code() ? RestResponse.successful((int)statusCode, mapper.apply(resp)) : KsqlClientUtil.createErrorResponse(path, resp);
    }

    static <T> T deserialize(Buffer buffer, Class<T> clazz) {
        ObjectMapper objectMapper = ApiJsonMapper.INSTANCE.get();
        try {
            return (T)objectMapper.readValue(buffer.getBytes(), clazz);
        }
        catch (Exception e) {
            throw new KsqlRestClientException("Failed to deserialise object", e);
        }
    }

    static Buffer serialize(Object object) {
        ObjectMapper objectMapper = ApiJsonMapper.INSTANCE.get();
        try {
            byte[] bytes = objectMapper.writeValueAsBytes(object);
            return Buffer.buffer((byte[])bytes);
        }
        catch (Exception e) {
            throw new KsqlRestClientException("Failed to serialise object", e);
        }
    }

    private static <T> RestResponse<T> createErrorResponse(String path, ResponseWithBody resp) {
        int statusCode = resp.getResponse().statusCode();
        Optional<KsqlErrorMessage> errorMessage = KsqlClientUtil.tryReadErrorMessage(resp);
        if (errorMessage.isPresent()) {
            return RestResponse.erroneous((int)statusCode, (KsqlErrorMessage)errorMessage.get());
        }
        if (statusCode == HttpResponseStatus.NOT_FOUND.code()) {
            return RestResponse.erroneous((int)statusCode, (String)("Path not found. Path='" + path + "'. Check your ksql http url to make sure you are connecting to a ksql server."));
        }
        if (statusCode == HttpResponseStatus.UNAUTHORIZED.code()) {
            return RestResponse.erroneous((int)statusCode, (KsqlErrorMessage)KsqlClientUtil.unauthorizedErrorMsg());
        }
        if (statusCode == HttpResponseStatus.FORBIDDEN.code()) {
            return RestResponse.erroneous((int)statusCode, (KsqlErrorMessage)KsqlClientUtil.forbiddenErrorMsg());
        }
        return RestResponse.erroneous((int)statusCode, (String)("The server returned an unexpected error: " + resp.getResponse().statusMessage()));
    }

    private static Optional<KsqlErrorMessage> tryReadErrorMessage(ResponseWithBody resp) {
        try {
            return Optional.ofNullable(KsqlClientUtil.deserialize(resp.getBody(), KsqlErrorMessage.class));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static KsqlErrorMessage unauthorizedErrorMsg() {
        return new KsqlErrorMessage(Errors.ERROR_CODE_UNAUTHORIZED, (Throwable)new AuthenticationException("Could not authenticate successfully with the supplied credentials."));
    }

    private static KsqlErrorMessage forbiddenErrorMsg() {
        return new KsqlErrorMessage(Errors.ERROR_CODE_FORBIDDEN, (Throwable)new AuthenticationException("You are forbidden from using this cluster."));
    }
}

