/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.ReassignPartitionsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.TreeSet;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ReassignPartitionsCommand$
implements Logging {
    public static final ReassignPartitionsCommand$ MODULE$ = new ReassignPartitionsCommand$();
    private static final String AnyLogDir = "any";
    private static final String helpText = "This tool helps to move topic partitions between replicas.";
    private static final int EarliestVersion = 1;
    private static final int EarliestTopicsJsonVersion = 1;
    private static final String brokerLevelLeaderThrottle = DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp();
    private static final String brokerLevelFollowerThrottle = DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp();
    private static final String brokerLevelLogDirThrottle = DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp();
    private static final Seq<String> brokerLevelThrottles = new .colon.colon((Object)MODULE$.brokerLevelLeaderThrottle(), (List)new .colon.colon((Object)MODULE$.brokerLevelFollowerThrottle(), (List)new .colon.colon((Object)MODULE$.brokerLevelLogDirThrottle(), (List)Nil$.MODULE$)));
    private static final String topicLevelLeaderThrottle = "leader.replication.throttled.replicas";
    private static final String topicLevelFollowerThrottle = "follower.replication.throttled.replicas";
    private static final Seq<String> topicLevelThrottles = new .colon.colon((Object)MODULE$.topicLevelLeaderThrottle(), (List)new .colon.colon((Object)MODULE$.topicLevelFollowerThrottle(), (List)Nil$.MODULE$));
    private static final String cannotExecuteBecauseOfExistingMessage = "Cannot execute because there is an existing partition assignment.  Use --additional to override this and create a new partition assignment in addition to the existing one. The --additional flag can also be used to change the throttle by resubmitting the current reassignment.";
    private static final String youMustRunVerifyPeriodicallyMessage = "Warning: You must run --verify periodically, until the reassignment completes, to ensure the throttle is removed.";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String AnyLogDir() {
        return AnyLogDir;
    }

    public String helpText() {
        return helpText;
    }

    public int EarliestVersion() {
        return EarliestVersion;
    }

    public int EarliestTopicsJsonVersion() {
        return EarliestTopicsJsonVersion;
    }

    public String brokerLevelLeaderThrottle() {
        return brokerLevelLeaderThrottle;
    }

    public String brokerLevelFollowerThrottle() {
        return brokerLevelFollowerThrottle;
    }

    public String brokerLevelLogDirThrottle() {
        return brokerLevelLogDirThrottle;
    }

    public Seq<String> brokerLevelThrottles() {
        return brokerLevelThrottles;
    }

    public String topicLevelLeaderThrottle() {
        return topicLevelLeaderThrottle;
    }

    public String topicLevelFollowerThrottle() {
        return topicLevelFollowerThrottle;
    }

    public Seq<String> topicLevelThrottles() {
        return topicLevelThrottles;
    }

    public String cannotExecuteBecauseOfExistingMessage() {
        return cannotExecuteBecauseOfExistingMessage;
    }

    public String youMustRunVerifyPeriodicallyMessage() {
        return youMustRunVerifyPeriodicallyMessage;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        boolean failed = true;
        try (Admin adminClient = null;){
            try {
                Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt())), null) : new Properties();
                props.put("bootstrap.servers", opts.options.valueOf(opts.bootstrapServerOpt()));
                props.putIfAbsent("client.id", "reassign-partitions-tool");
                adminClient = Admin.create((Properties)props);
                this.handleAction(adminClient, opts);
                failed = false;
            }
            catch (ReassignPartitionsCommand.TerseReassignmentFailureException e) {
                Predef$.MODULE$.println((Object)e.getMessage());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("Error: ").append(e.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            }
        }
        if (failed) {
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
    }

    private void handleAction(Admin adminClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options.has((OptionSpec)opts.verifyOpt())) {
            this.verifyAssignment(adminClient, Utils.readFileAsString((String)((String)opts.options.valueOf(opts.reassignmentJsonFileOpt()))), opts.options.has((OptionSpec)opts.preserveThrottlesOpt()));
            return;
        }
        if (opts.options.has((OptionSpec)opts.generateOpt())) {
            this.generateAssignment(adminClient, Utils.readFileAsString((String)((String)opts.options.valueOf(opts.topicsToMoveJsonFileOpt()))), (String)opts.options.valueOf(opts.brokerListOpt()), !opts.options.has((OptionSpec)opts.disableRackAware()));
            return;
        }
        if (opts.options.has((OptionSpec)opts.executeOpt())) {
            this.executeAssignment(adminClient, opts.options.has((OptionSpec)opts.additionalOpt()), Utils.readFileAsString((String)((String)opts.options.valueOf(opts.reassignmentJsonFileOpt()))), BoxesRunTime.unboxToLong((Object)opts.options.valueOf(opts.interBrokerThrottleOpt())), BoxesRunTime.unboxToLong((Object)opts.options.valueOf(opts.replicaAlterLogDirsThrottleOpt())), BoxesRunTime.unboxToLong((Object)opts.options.valueOf(opts.timeoutOpt())), Time.SYSTEM);
            return;
        }
        if (opts.options.has((OptionSpec)opts.cancelOpt())) {
            this.cancelAssignment(adminClient, Utils.readFileAsString((String)((String)opts.options.valueOf(opts.reassignmentJsonFileOpt()))), opts.options.has((OptionSpec)opts.preserveThrottlesOpt()), BoxesRunTime.unboxToLong((Object)opts.options.valueOf(opts.timeoutOpt())), Time.SYSTEM);
            return;
        }
        if (opts.options.has((OptionSpec)opts.listOpt())) {
            this.listReassignments(adminClient);
            return;
        }
        throw new RuntimeException("Unsupported action.");
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        void var10_11;
        void var8_8;
        void var6_6;
        void var5_5;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq targetParts = (Seq)tuple2._1();
        Map targetLogDirs = (Map)tuple2._2();
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple22 = this.verifyPartitionAssignments(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Map partStates = (Map)tuple22._1();
        boolean bl = tuple22._2$mcZ$sp();
        Tuple2<Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>, Object> tuple23 = this.verifyReplicaMoves(adminClient, (Map<TopicPartitionReplica, String>)var6_6);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Map moveStates = (Map)tuple23._1();
        boolean bl2 = tuple23._2$mcZ$sp();
        if (!(bl || bl2 || preserveThrottles)) {
            this.clearAllThrottles(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        }
        return new ReassignPartitionsCommand.VerifyAssignmentResult((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var8_8, bl, (Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>)var10_11, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> verifyPartitionAssignments(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targets) {
        void var4_4;
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple2 = this.findPartitionReassignmentStates(adminClient, targets);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partStates = (Map)tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        Predef$.MODULE$.println((Object)this.partitionReassignmentStatesToString((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var4_4));
        return new Tuple2((Object)var4_4, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public boolean compareTopicPartitions(TopicPartition a, TopicPartition b) {
        return Ordered$.MODULE$.orderingToOrdered((Object)new Tuple2((Object)a.topic(), (Object)BoxesRunTime.boxToInteger((int)a.partition())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$less((Object)new Tuple2((Object)b.topic(), (Object)BoxesRunTime.boxToInteger((int)b.partition())));
    }

    public boolean compareTopicPartitionReplicas(TopicPartitionReplica a, TopicPartitionReplica b) {
        return Ordered$.MODULE$.orderingToOrdered((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)a.brokerId()), (Object)a.topic(), (Object)BoxesRunTime.boxToInteger((int)a.partition())), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$less((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)b.brokerId()), (Object)b.topic(), (Object)BoxesRunTime.boxToInteger((int)b.partition())));
    }

    public String partitionReassignmentStatesToString(Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState> states) {
        ArrayBuffer bld = new ArrayBuffer();
        bld.append((Object)"Status of partition reassignment:");
        ((IterableOnceOps)states.keySet().toBuffer().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).foreach((Function1 & Serializable)topicPartition -> {
            ReassignPartitionsCommand.PartitionReassignmentState state = (ReassignPartitionsCommand.PartitionReassignmentState)states.apply(topicPartition);
            if (state.done()) {
                if (state.currentReplicas().equals(state.targetReplicas())) {
                    return (ArrayBuffer)bld.append((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Reassignment of partition %s is completed."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition.toString()})));
                }
                return (ArrayBuffer)bld.append((Object)new StringBuilder(80).append("There is no active reassignment of partition ").append(topicPartition).append(", ").append("but replica set is ").append(state.currentReplicas().mkString(",")).append(" rather than ").append(state.targetReplicas().mkString(",")).append(".").toString());
            }
            return (ArrayBuffer)bld.append((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
        });
        return bld.mkString(System.lineSeparator());
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> findPartitionReassignmentStates(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetReassignments) {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Map currentReassignments = CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)adminClient.listPartitionReassignments().reassignments().get()).asScala();
        Tuple2 tuple2 = targetReassignments.partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$1(currentReassignments, x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq foundReassignments = (Seq)tuple2._1();
        Seq notFoundReassignments = (Seq)tuple2._2();
        Seq foundResults = (Seq)var5_5.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition part = (TopicPartition)x0$2._1();
                Seq targetReplicas = (Seq)x0$2._2();
                return new Tuple2((Object)part, (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)((Seq)CollectionConverters$.MODULE$.ListHasAsScala(((PartitionReassignment)currentReassignments.apply((Object)part)).replicas()).asScala().map((Function1 & Serializable)i -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$3(i)))), (Seq<Object>)targetReplicas, false));
            }
            throw new MatchError(null);
        });
        HashSet topicNamesToLookUp = new HashSet();
        var6_6.foreach((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                TopicPartition part = (TopicPartition)x0$3._1();
                if (!currentReassignments.contains((Object)part)) {
                    return BoxesRunTime.boxToBoolean((boolean)topicNamesToLookUp.add((Object)part.topic()));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError(null);
        });
        scala.collection.mutable.Map topicDescriptions = CollectionConverters$.MODULE$.MapHasAsScala(adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)topicNamesToLookUp).asJava()).topicNameValues()).asScala();
        Seq notFoundResults = (Seq)var6_6.map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                TopicPartition part = (TopicPartition)x0$4._1();
                Seq targetReplicas = (Seq)x0$4._2();
                Option option = currentReassignments.get((Object)part);
                if (option instanceof Some) {
                    PartitionReassignment reassignment = (PartitionReassignment)((Some)option).value();
                    return new Tuple2((Object)part, (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)((Seq)CollectionConverters$.MODULE$.ListHasAsScala(reassignment.replicas()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$6(x$6)))), (Seq<Object>)targetReplicas, false));
                }
                if (None$.MODULE$.equals(option)) {
                    return new Tuple2((Object)part, (Object)MODULE$.topicDescriptionFutureToState(part.partition(), (KafkaFuture<TopicDescription>)((KafkaFuture)topicDescriptions.apply((Object)part.topic())), (Seq<Object>)targetReplicas));
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError(null);
        });
        Seq allResults = (Seq)foundResults.$plus$plus((IterableOnce)notFoundResults);
        return new Tuple2((Object)allResults.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)BoxesRunTime.boxToBoolean((boolean)currentReassignments.nonEmpty()));
    }

    private ReassignPartitionsCommand.PartitionReassignmentState topicDescriptionFutureToState(int partition, KafkaFuture<TopicDescription> future, Seq<Object> targetReplicas) {
        try {
            TopicDescription topicDescription = (TopicDescription)future.get();
            if (topicDescription.partitions().size() < partition) {
                throw new ExecutionException("Too few partitions found", new UnknownTopicOrPartitionException());
            }
            return new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)((Seq)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(partition)).replicas()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()))), targetReplicas, true);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                return new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)Nil$.MODULE$, targetReplicas, true);
            }
            throw throwable;
        }
    }

    public Tuple2<Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>, Object> verifyReplicaMoves(Admin adminClient, Map<TopicPartitionReplica, String> targetReassignments) {
        Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> moveStates = this.findLogDirMoveStates(adminClient, targetReassignments);
        Predef$.MODULE$.println((Object)this.replicaMoveStatesToString(moveStates));
        return new Tuple2(moveStates, (Object)BoxesRunTime.boxToBoolean((!moveStates.values().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.done())) ? 1 : 0) != 0));
    }

    public Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> findLogDirMoveStates(Admin adminClient, Map<TopicPartitionReplica, String> targetMoves) {
        scala.collection.mutable.Map replicaLogDirInfos = CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)adminClient.describeReplicaLogDirs((Collection)CollectionConverters$.MODULE$.SetHasAsJava(targetMoves.keySet()).asJava()).all().get()).asScala();
        return (Map)targetMoves.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Object object;
                TopicPartitionReplica replica = (TopicPartitionReplica)x0$1._1();
                String targetLogDir = (String)x0$1._2();
                Option option = replicaLogDirInfos.get((Object)replica);
                if (None$.MODULE$.equals(option)) {
                    object = new ReassignPartitionsCommand.MissingReplicaMoveState(targetLogDir);
                } else if (option instanceof Some) {
                    DescribeReplicaLogDirsResult.ReplicaLogDirInfo info = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((Some)option).value();
                    object = info.getCurrentReplicaLogDir() == null ? new ReassignPartitionsCommand.MissingLogDirMoveState(targetLogDir) : (info.getFutureReplicaLogDir() == null ? (info.getCurrentReplicaLogDir().equals(targetLogDir) ? new ReassignPartitionsCommand.CompletedMoveState(targetLogDir) : new ReassignPartitionsCommand.CancelledMoveState(info.getCurrentReplicaLogDir(), targetLogDir)) : new ReassignPartitionsCommand.ActiveMoveState(info.getCurrentReplicaLogDir(), targetLogDir, info.getFutureReplicaLogDir()));
                } else {
                    throw new MatchError((Object)option);
                }
                ReassignPartitionsCommand.MissingReplicaMoveState moveState = object;
                return new Tuple2((Object)replica, (Object)moveState);
            }
            throw new MatchError(null);
        });
    }

    public String replicaMoveStatesToString(Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> states) {
        ArrayBuffer bld = new ArrayBuffer();
        ((IterableOnceOps)states.keySet().toBuffer().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)))).foreach((Function1 & Serializable)replica -> {
            ReassignPartitionsCommand.LogDirMoveState state = (ReassignPartitionsCommand.LogDirMoveState)states.apply(replica);
            if (state instanceof ReassignPartitionsCommand.MissingLogDirMoveState) {
                return (ArrayBuffer)bld.append((Object)new StringBuilder(112).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" is not found ").append("in any live log dir on broker ").append(replica.brokerId()).append(". There is likely an ").append("offline log directory on the broker.").toString());
            }
            if (state instanceof ReassignPartitionsCommand.MissingReplicaMoveState) {
                return (ArrayBuffer)bld.append((Object)new StringBuilder(65).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" cannot be found ").append("in any live log directory on broker ").append(replica.brokerId()).append(".").toString());
            }
            if (state instanceof ReassignPartitionsCommand.ActiveMoveState) {
                String futureLogDir;
                ReassignPartitionsCommand.ActiveMoveState activeMoveState = (ReassignPartitionsCommand.ActiveMoveState)state;
                String targetLogDir = activeMoveState.targetLogDir();
                if (targetLogDir.equals(futureLogDir = activeMoveState.futureLogDir())) {
                    return (ArrayBuffer)bld.append((Object)new StringBuilder(46).append("Reassignment of replica ").append(replica).append(" is still in progress.").toString());
                }
                return (ArrayBuffer)bld.append((Object)new StringBuilder(62).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" on broker ").append(replica.brokerId()).append(" is being moved to log dir ").append(futureLogDir).append(" ").append("instead of ").append(targetLogDir).append(".").toString());
            }
            if (state instanceof ReassignPartitionsCommand.CancelledMoveState) {
                ReassignPartitionsCommand.CancelledMoveState cancelledMoveState = (ReassignPartitionsCommand.CancelledMoveState)state;
                String currentLogDir = cancelledMoveState.currentLogDir();
                String targetLogDir = cancelledMoveState.targetLogDir();
                return (ArrayBuffer)bld.append((Object)new StringBuilder(60).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" on broker ").append(replica.brokerId()).append(" is not being moved from log dir ").append(currentLogDir).append(" to ").append(targetLogDir).append(".").toString());
            }
            if (state instanceof ReassignPartitionsCommand.CompletedMoveState) {
                return (ArrayBuffer)bld.append((Object)new StringBuilder(48).append("Reassignment of replica ").append(replica).append(" completed successfully.").toString());
            }
            throw new MatchError((Object)state);
        });
        return bld.mkString(System.lineSeparator());
    }

    public void clearAllThrottles(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetParts) {
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.describeCluster().nodes().get()).asScala().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()))).toSet().$plus$plus((IterableOnce)((IterableOnceOps)targetParts.flatMap((Function1 & Serializable)x$10 -> (Seq)x$10._2())).toSet());
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Clearing broker-level throttles on broker%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{brokers.size() == 1 ? "" : "s", brokers.mkString(",")})));
        this.clearBrokerLevelThrottles(adminClient, (scala.collection.immutable.Set<Object>)brokers);
        scala.collection.immutable.Set topics = ((IterableOnceOps)targetParts.map((Function1 & Serializable)x$11 -> ((TopicPartition)x$11._1()).topic())).toSet();
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Clearing topic-level throttles on topic%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topics.size() == 1 ? "" : "s", topics.mkString(",")})));
        this.clearTopicLevelThrottles(adminClient, (scala.collection.immutable.Set<String>)topics);
    }

    public void clearBrokerLevelThrottles(Admin adminClient, scala.collection.immutable.Set<Object> brokers) {
        HashMap configOps = new HashMap();
        brokers.foreach((Function1 & Serializable)brokerId -> configOps.put(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(BoxesRunTime.unboxToInt((Object)brokerId))), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().map((Function1 & Serializable)throttle -> new AlterConfigOp(new ConfigEntry(throttle, null), AlterConfigOp.OpType.DELETE))).asJava()));
        adminClient.incrementalAlterConfigs(configOps).all().get();
    }

    public void clearTopicLevelThrottles(Admin adminClient, scala.collection.immutable.Set<String> topics) {
        HashMap configOps = new HashMap();
        topics.foreach((Function1 & Serializable)topicName -> configOps.put(new ConfigResource(ConfigResource.Type.TOPIC, topicName), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)MODULE$.topicLevelThrottles().map((Function1 & Serializable)throttle -> new AlterConfigOp(new ConfigEntry(throttle, null), AlterConfigOp.OpType.DELETE))).asJava()));
        adminClient.incrementalAlterConfigs(configOps).all().get();
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(Admin adminClient, String reassignmentJson, String brokerListString, boolean enableRackAwareness) {
        void var6_6;
        void var7_7;
        Tuple2<Seq<Object>, Seq<String>> tuple2 = this.parseGenerateAssignmentArgs(reassignmentJson, brokerListString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq brokersToReassign = (Seq)tuple2._1();
        Seq topicsToReassign = (Seq)tuple2._2();
        Map<TopicPartition, Seq<Object>> currentAssignments = this.getReplicaAssignmentForTopics(adminClient, (Seq<String>)var7_7);
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadata(adminClient, (Seq<Object>)var6_6, enableRackAwareness);
        Map<TopicPartition, Seq<Object>> proposedAssignments = this.calculateAssignment(currentAssignments, brokerMetadatas);
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Current partition replica assignment\n%s\n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(currentAssignments, (Map<TopicPartitionReplica, String>)((Map)scala.collection.Map$.MODULE$.empty()))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(proposedAssignments, (Map<TopicPartitionReplica, String>)((Map)scala.collection.Map$.MODULE$.empty()))})));
        return new Tuple2(proposedAssignments, currentAssignments);
    }

    public Map<TopicPartition, Seq<Object>> calculateAssignment(Map<TopicPartition, Seq<Object>> currentAssignment, Seq<BrokerMetadata> brokerMetadatas) {
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return ((TopicPartition)x0$1._1()).topic();
            }
            throw new MatchError(null);
        });
        scala.collection.mutable.Map proposedAssignments = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topic, assignment) -> {
            void var5_5;
            Tuple2 tuple2 = (Tuple2)assignment.head();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Seq replicas = (Seq)tuple2._2();
            Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)brokerMetadatas, assignment.size(), var5_5.size(), -1, -1);
            return (scala.collection.mutable.Map)proposedAssignments.$plus$plus$eq((IterableOnce)assignedReplicas.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    int partition = x0$2._1$mcI$sp();
                    Seq replicas = (Seq)x0$2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)replicas);
                }
                throw new MatchError(null);
            }));
        };
        groupedByTopic.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        return proposedAssignments;
    }

    private Map<String, TopicDescription> describeTopics(Admin adminClient, scala.collection.immutable.Set<String> topics) {
        return (Map)CollectionConverters$.MODULE$.MapHasAsScala(adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava(topics).asJava()).topicNameValues()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                KafkaFuture topicDescriptionFuture = (KafkaFuture)x0$1._2();
                try {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), topicDescriptionFuture.get());
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                        throw new ExecutionException(new UnknownTopicOrPartitionException(new StringBuilder(17).append("Topic ").append(topicName).append(" not found.").toString()));
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        });
    }

    public Map<TopicPartition, Seq<Object>> getReplicaAssignmentForTopics(Admin adminClient, Seq<String> topics) {
        return (Map)this.describeTopics(adminClient, (scala.collection.immutable.Set<String>)topics.toSet()).flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                TopicDescription topicDescription = (TopicDescription)x0$1._2();
                return (IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)info -> new Tuple2((Object)new TopicPartition(topicName, info.partition()), CollectionConverters$.MODULE$.ListHasAsScala(info.replicas()).asScala().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.id()))));
            }
            throw new MatchError(null);
        });
    }

    public Map<TopicPartition, Seq<Object>> getReplicaAssignmentForPartitions(Admin adminClient, scala.collection.immutable.Set<TopicPartition> partitions) {
        return (Map)this.describeTopics(adminClient, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)partitions.map((Function1 & Serializable)x$14 -> x$14.topic()))).flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                TopicDescription topicDescription = (TopicDescription)x0$1._2();
                return (IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().flatMap((Function1 & Serializable)info -> {
                    TopicPartition tp = new TopicPartition(topicName, info.partition());
                    if (partitions.contains((Object)tp)) {
                        return new Some((Object)new Tuple2((Object)tp, CollectionConverters$.MODULE$.ListHasAsScala(info.replicas()).asScala().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()))));
                    }
                    return None$.MODULE$;
                });
            }
            throw new MatchError(null);
        });
    }

    public Seq<BrokerMetadata> getBrokerMetadata(Admin adminClient, Seq<Object> brokers, boolean enableRackAwareness) {
        scala.collection.immutable.Set brokerSet = brokers.toSet();
        scala.collection.immutable.Seq results = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.describeCluster().nodes().get()).asScala().filter((Function1 & Serializable)node -> BoxesRunTime.boxToBoolean((boolean)brokerSet.contains((Object)BoxesRunTime.boxToInteger((int)node.id()))))).map((Function1 & Serializable)node -> {
            if (enableRackAwareness && node.rack() != null) {
                return new BrokerMetadata(node.id(), (Option<String>)new Some((Object)node.rack()));
            }
            return new BrokerMetadata(node.id(), (Option<String>)None$.MODULE$);
        })).toSeq();
        int numRackless = results.count((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$getBrokerMetadata$3(x$16)));
        if (enableRackAwareness && numRackless != 0 && numRackless != results.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return results;
    }

    public Tuple2<Seq<Object>, Seq<String>> parseGenerateAssignmentArgs(String reassignmentJson, String brokerList) {
        int[] brokerListToReassign = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(brokerList), ',')), (Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$17))), (ClassTag)ClassTag$.MODULE$.Int());
        Iterable duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Broker list contains duplicate entries: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignments.mkString(",")})));
        }
        Seq<String> topicsToReassign = this.parseTopicsData(reassignmentJson);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("List of topics to reassign contains duplicate entries: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        return new Tuple2((Object)Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToReassign);
    }

    /*
     * WARNING - void declaration
     */
    public void executeAssignment(Admin adminClient, boolean additional, String reassignmentJson, long interBrokerThrottle, long logDirThrottle, long timeoutMs, Time time) {
        Map<TopicPartition, Throwable> errors;
        void var13_10;
        void var12_9;
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseExecuteAssignmentArgs(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map proposedParts = (Map)tuple2._1();
        Map proposedReplicas = (Map)tuple2._2();
        scala.collection.mutable.Map currentReassignments = CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)adminClient.listPartitionReassignments().reassignments().get()).asScala();
        if (!additional && currentReassignments.nonEmpty()) {
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(this.cannotExecuteBecauseOfExistingMessage());
        }
        this.verifyBrokerIds(adminClient, (scala.collection.immutable.Set<Object>)((IterableOnceOps)var12_9.values().flatten(Predef$.MODULE$.$conforms())).toSet());
        Map<TopicPartition, Seq<Object>> currentParts = this.getReplicaAssignmentForPartitions(adminClient, (scala.collection.immutable.Set<TopicPartition>)var12_9.keySet().toSet());
        Predef$.MODULE$.println((Object)this.currentPartitionReplicaAssignmentToString((Map<TopicPartition, Seq<Object>>)var12_9, currentParts));
        if (interBrokerThrottle >= 0L || logDirThrottle >= 0L) {
            Predef$.MODULE$.println((Object)this.youMustRunVerifyPeriodicallyMessage());
            if (interBrokerThrottle >= 0L) {
                scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap = this.calculateProposedMoveMap((Map<TopicPartition, PartitionReassignment>)currentReassignments, (Map<TopicPartition, Seq<Object>>)var12_9, currentParts);
                this.modifyReassignmentThrottle(adminClient, moveMap, interBrokerThrottle);
            }
            if (logDirThrottle >= 0L) {
                scala.collection.immutable.Set<Object> movingBrokers = this.calculateMovingBrokers((scala.collection.immutable.Set<TopicPartitionReplica>)var13_10.keySet().toSet());
                this.modifyLogDirThrottle(adminClient, movingBrokers, logDirThrottle);
            }
        }
        if ((errors = this.alterPartitionReassignments(adminClient, (Map<TopicPartition, Seq<Object>>)var12_9)).nonEmpty()) {
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Error reassigning partition(s):%n%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((IterableOnceOps)((IterableOps)errors.keySet().toBuffer().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable)part -> new StringBuilder(2).append(part).append(": ").append(((Throwable)errors.apply(part)).getMessage()).toString())).mkString(System.lineSeparator())})));
        }
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Successfully started partition reassignment%s for %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{var12_9.size() == 1 ? "" : "s", ((IterableOnceOps)var12_9.keySet().toBuffer().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).mkString(",")})));
        if (var13_10.nonEmpty()) {
            this.executeMoves(adminClient, (Map<TopicPartitionReplica, String>)var13_10, timeoutMs, time);
            return;
        }
    }

    public long executeAssignment$default$4() {
        return -1L;
    }

    public long executeAssignment$default$5() {
        return -1L;
    }

    public long executeAssignment$default$6() {
        return 10000L;
    }

    public Time executeAssignment$default$7() {
        return Time.SYSTEM;
    }

    public void executeMoves(Admin adminClient, Map<TopicPartitionReplica, String> proposedReplicas, long timeoutMs, Time time) {
        long startTimeMs = time.milliseconds();
        scala.collection.mutable.HashMap pendingReplicas = new scala.collection.mutable.HashMap();
        pendingReplicas.$plus$plus$eq(proposedReplicas);
        boolean done = false;
        do {
            scala.collection.immutable.Set<TopicPartitionReplica> completed;
            if ((completed = this.alterReplicaLogDirs(adminClient, (Map<TopicPartitionReplica, String>)pendingReplicas)).nonEmpty()) {
                Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Successfully started log directory move%s for: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{completed.size() == 1 ? "" : "s", ((IterableOnceOps)completed.toBuffer().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)))).mkString(",")})));
            }
            pendingReplicas.$minus$minus$eq(completed);
            if (pendingReplicas.isEmpty()) {
                done = true;
                continue;
            }
            if (time.milliseconds() >= startTimeMs + timeoutMs) {
                throw new ReassignPartitionsCommand.TerseReassignmentFailureException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Timed out before log directory move%s could be started for: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{pendingReplicas.size() == 1 ? "" : "s", ((IterableOnceOps)pendingReplicas.keySet().toBuffer().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)))).mkString(",")})));
            }
            time.sleep(100L);
        } while (!done);
    }

    public void listReassignments(Admin adminClient) {
        Predef$.MODULE$.println((Object)this.curReassignmentsToString(adminClient));
    }

    public String curReassignmentsToString(Admin adminClient) {
        scala.collection.mutable.Map currentReassignments = CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)adminClient.listPartitionReassignments().reassignments().get()).asScala();
        String text = ((IterableOnceOps)((IterableOps)currentReassignments.keySet().toBuffer().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable)part -> {
            PartitionReassignment reassignment = (PartitionReassignment)currentReassignments.apply(part);
            Buffer replicas = CollectionConverters$.MODULE$.ListHasAsScala(reassignment.replicas()).asScala();
            Buffer addingReplicas = CollectionConverters$.MODULE$.ListHasAsScala(reassignment.addingReplicas()).asScala();
            Buffer removingReplicas = CollectionConverters$.MODULE$.ListHasAsScala(reassignment.removingReplicas()).asScala();
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s: replicas: %s.%s%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{part, replicas.mkString(","), addingReplicas.isEmpty() ? "" : StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" adding: %s."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{addingReplicas.mkString(",")})), removingReplicas.isEmpty() ? "" : StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" removing: %s."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{removingReplicas.mkString(",")}))}));
        })).mkString(System.lineSeparator());
        if (text.isEmpty()) {
            return "No partition reassignments found.";
        }
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Current partition reassignments:%n%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{text}));
    }

    public void verifyBrokerIds(Admin adminClient, scala.collection.immutable.Set<Object> brokers) {
        scala.collection.immutable.Set allNodeIds = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.describeCluster().nodes().get()).asScala().map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.id()))).toSet();
        brokers.find((Function1)(JFunction1.mcZI.sp & Serializable)x$20 -> !allNodeIds.contains((Object)BoxesRunTime.boxToInteger((int)x$20))).map((Function1 & Serializable)id -> ReassignPartitionsCommand$.$anonfun$verifyBrokerIds$3(BoxesRunTime.unboxToInt((Object)id)));
    }

    public String currentPartitionReplicaAssignmentToString(Map<TopicPartition, Seq<Object>> proposedParts, Map<TopicPartition, Seq<Object>> currentParts) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Current partition replica assignment%n%n%s%n%nSave this to use as the %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicPartition, Seq<Object>>)((IterableOnceOps)currentParts.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$currentPartitionReplicaAssignmentToString$1(proposedParts, x0$1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Map<TopicPartitionReplica, String>)((Map)scala.collection.Map$.MODULE$.empty())), "--reassignment-json-file option during rollback"}));
    }

    public Map<TopicPartition, Throwable> alterPartitionReassignments(Admin adminClient, Map<TopicPartition, Seq<Object>> reassignments) {
        return (Map)CollectionConverters$.MODULE$.MapHasAsScala(adminClient.alterPartitionReassignments(CollectionConverters$.MODULE$.MapHasAsJava((Map)reassignments.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition part = (TopicPartition)x0$1._1();
                Seq replicas = (Seq)x0$1._2();
                return new Tuple2((Object)part, Optional.of(new NewPartitionReassignment(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava())));
            }
            throw new MatchError(null);
        })).asJava()).values()).asScala().flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition part = (TopicPartition)x0$2._1();
                try {
                    ((KafkaFuture)x0$2._2()).get();
                    return None$.MODULE$;
                }
                catch (ExecutionException t) {
                    return new Some((Object)new Tuple2((Object)part, (Object)t.getCause()));
                }
            }
            throw new MatchError(null);
        });
    }

    public Map<TopicPartition, Throwable> cancelPartitionReassignments(Admin adminClient, scala.collection.immutable.Set<TopicPartition> reassignments) {
        return (Map)CollectionConverters$.MODULE$.MapHasAsScala(adminClient.alterPartitionReassignments(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)reassignments.map((Function1 & Serializable)x$21 -> new Tuple2(x$21, Optional.empty()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava()).values()).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition part = (TopicPartition)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    return None$.MODULE$;
                }
                catch (ExecutionException t) {
                    return new Some((Object)new Tuple2((Object)part, (Object)t.getCause()));
                }
            }
            throw new MatchError(null);
        });
    }

    private scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> calculateCurrentMoveMap(Map<TopicPartition, PartitionReassignment> currentReassignments) {
        scala.collection.mutable.HashMap moveMap = new scala.collection.mutable.HashMap();
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(part, reassignment) -> {
            Buffer allReplicas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(reassignment.replicas()).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$calculateCurrentMoveMap$2(x)));
            Buffer addingReplicas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(reassignment.addingReplicas()).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$calculateCurrentMoveMap$3(x)));
            scala.collection.mutable.Set sources = (scala.collection.mutable.Set)((SetOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)allReplicas.diff((Seq)addingReplicas));
            scala.collection.mutable.Set destinations = (scala.collection.mutable.Set)((SetOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)addingReplicas);
            return ((scala.collection.mutable.Map)moveMap.getOrElseUpdate((Object)part.topic(), (Function0 & Serializable)() -> new scala.collection.mutable.HashMap())).put((Object)BoxesRunTime.boxToInteger((int)part.partition()), (Object)new ReassignPartitionsCommand.PartitionMove((scala.collection.mutable.Set<Object>)sources, (scala.collection.mutable.Set<Object>)destinations));
        };
        currentReassignments.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        return moveMap;
    }

    public scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> calculateProposedMoveMap(Map<TopicPartition, PartitionReassignment> currentReassignments, Map<TopicPartition, Seq<Object>> proposedParts, Map<TopicPartition, Seq<Object>> currentParts) {
        scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap = this.calculateCurrentMoveMap(currentReassignments);
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(part, replicas) -> {
            scala.collection.immutable.Seq seq;
            scala.collection.mutable.Map partMoves = (scala.collection.mutable.Map)moveMap.getOrElseUpdate((Object)part.topic(), (Function0 & Serializable)() -> new scala.collection.mutable.HashMap());
            SetOps setOps = (SetOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            Option option = partMoves.get((Object)BoxesRunTime.boxToInteger((int)part.partition()));
            if (option instanceof Some) {
                seq = ((ReassignPartitionsCommand.PartitionMove)((Some)option).value()).sources().toSeq();
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq)currentParts.getOrElse(part, (Function0 & Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(53).append("Trying to reassign a topic partition ").append(part).append(" with 0 replicas").toString());
                });
            } else {
                throw new MatchError((Object)option);
            }
            scala.collection.mutable.Set sources = (scala.collection.mutable.Set)setOps.$plus$plus((IterableOnce)seq);
            scala.collection.mutable.Set destinations = (scala.collection.mutable.Set)((SetOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)replicas.diff((Seq)sources.toSeq()));
            return partMoves.put((Object)BoxesRunTime.boxToInteger((int)part.partition()), (Object)new ReassignPartitionsCommand.PartitionMove((scala.collection.mutable.Set<Object>)sources, (scala.collection.mutable.Set<Object>)destinations));
        };
        proposedParts.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        return moveMap;
    }

    public Map<String, String> calculateLeaderThrottles(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        return (Map)moveMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                scala.collection.mutable.Map partMoveMap = (scala.collection.mutable.Map)x0$1._2();
                TreeSet components = new TreeSet((Ordering)Ordering.String$.MODULE$);
                Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partId, move) -> {
                    ReassignPartitionsCommand$.$anonfun$calculateLeaderThrottles$2(components, BoxesRunTime.unboxToInt((Object)partId), move);
                    return BoxedUnit.UNIT;
                };
                partMoveMap.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
                Object var4_4 = null;
                return new Tuple2((Object)topicName, (Object)components.mkString(","));
            }
            throw new MatchError(null);
        });
    }

    public Map<String, String> calculateFollowerThrottles(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        return (Map)moveMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                scala.collection.mutable.Map partMoveMap = (scala.collection.mutable.Map)x0$1._2();
                TreeSet components = new TreeSet((Ordering)Ordering.String$.MODULE$);
                Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partId, move) -> {
                    ReassignPartitionsCommand$.$anonfun$calculateFollowerThrottles$2(components, BoxesRunTime.unboxToInt((Object)partId), move);
                    return BoxedUnit.UNIT;
                };
                partMoveMap.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
                Object var4_4 = null;
                return new Tuple2((Object)topicName, (Object)components.mkString(","));
            }
            throw new MatchError(null);
        });
    }

    public scala.collection.immutable.Set<Object> calculateReassigningBrokers(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        TreeSet reassigningBrokers = new TreeSet((Ordering)Ordering.Int$.MODULE$);
        moveMap.values().foreach((Function1 & Serializable)x$22 -> {
            ReassignPartitionsCommand$.$anonfun$calculateReassigningBrokers$1(reassigningBrokers, x$22);
            return BoxedUnit.UNIT;
        });
        return reassigningBrokers.toSet();
    }

    public scala.collection.immutable.Set<Object> calculateMovingBrokers(scala.collection.immutable.Set<TopicPartitionReplica> replicaMoves) {
        return (scala.collection.immutable.Set)replicaMoves.map((Function1 & Serializable)x$23 -> BoxesRunTime.boxToInteger((int)x$23.brokerId()));
    }

    public void modifyTopicThrottles(Admin adminClient, Map<String, String> leaderThrottles, Map<String, String> followerThrottles) {
        HashMap configs = new HashMap();
        ((Set)leaderThrottles.keySet().$plus$plus((IterableOnce)followerThrottles.keySet())).foreach((Function1 & Serializable)topicName -> {
            ArrayList ops = new ArrayList();
            leaderThrottles.get(topicName).foreach((Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ops.add(new AlterConfigOp(new ConfigEntry(ReassignPartitionsCommand$.MODULE$.topicLevelLeaderThrottle(), value), AlterConfigOp.OpType.SET))));
            followerThrottles.get(topicName).foreach((Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ops.add(new AlterConfigOp(new ConfigEntry(ReassignPartitionsCommand$.MODULE$.topicLevelFollowerThrottle(), value), AlterConfigOp.OpType.SET))));
            if (!ops.isEmpty()) {
                return configs.put(new ConfigResource(ConfigResource.Type.TOPIC, topicName), ops);
            }
            return BoxedUnit.UNIT;
        });
        adminClient.incrementalAlterConfigs(configs).all().get();
    }

    private void modifyReassignmentThrottle(Admin admin, scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap, long interBrokerThrottle) {
        Map<String, String> leaderThrottles = this.calculateLeaderThrottles(moveMap);
        Map<String, String> followerThrottles = this.calculateFollowerThrottles(moveMap);
        this.modifyTopicThrottles(admin, leaderThrottles, followerThrottles);
        scala.collection.immutable.Set<Object> reassigningBrokers = this.calculateReassigningBrokers(moveMap);
        this.modifyInterBrokerThrottle(admin, reassigningBrokers, interBrokerThrottle);
    }

    public void modifyInterBrokerThrottle(Admin adminClient, scala.collection.immutable.Set<Object> reassigningBrokers, long interBrokerThrottle) {
        if (interBrokerThrottle >= 0L) {
            HashMap configs = new HashMap();
            reassigningBrokers.foreach((Function1 & Serializable)brokerId -> ReassignPartitionsCommand$.$anonfun$modifyInterBrokerThrottle$1(interBrokerThrottle, configs, BoxesRunTime.unboxToInt((Object)brokerId)));
            adminClient.incrementalAlterConfigs(configs).all().get();
            Predef$.MODULE$.println((Object)new StringBuilder(47).append("The inter-broker throttle limit was set to ").append(interBrokerThrottle).append(" B/s").toString());
            return;
        }
    }

    public void modifyLogDirThrottle(Admin admin, scala.collection.immutable.Set<Object> movingBrokers, long logDirThrottle) {
        if (logDirThrottle >= 0L) {
            HashMap configs = new HashMap();
            movingBrokers.foreach((Function1 & Serializable)brokerId -> ReassignPartitionsCommand$.$anonfun$modifyLogDirThrottle$1(logDirThrottle, configs, BoxesRunTime.unboxToInt((Object)brokerId)));
            admin.incrementalAlterConfigs(configs).all().get();
            Predef$.MODULE$.println((Object)new StringBuilder(52).append("The replica-alter-dir throttle limit was set to ").append(logDirThrottle).append(" B/s").toString());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> parseExecuteAssignmentArgs(String reassignmentJson) {
        void var4_4;
        void var3_3;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq partitionsToBeReassigned = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        if (var3_3.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment list cannot be empty");
        }
        if (var3_3.exists((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseExecuteAssignmentArgs$1(x$25)))) {
            throw new AdminCommandFailedException("Partition replica list cannot be empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates((Iterable)var3_3.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (TopicPartition)x0$1._1();
            }
            throw new MatchError(null);
        }));
        if (duplicateReassignedPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Partition reassignment contains duplicate topic partitions: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((IterableOps)var3_3.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                Seq replicas = (Seq)x0$2._2();
                return new Tuple2((Object)tp, CoreUtils$.MODULE$.duplicates(replicas));
            }
            throw new MatchError(null);
        })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseExecuteAssignmentArgs$4(x0$3)));
        if (duplicateEntries.nonEmpty()) {
            String duplicatesMsg = ((IterableOnceOps)duplicateEntries.map((Function1 & Serializable)x0$4 -> {
                if (x0$4 != null) {
                    TopicPartition tp = (TopicPartition)x0$4._1();
                    Iterable duplicateReplicas = (Iterable)x0$4._2();
                    return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s contains multiple entries for %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tp, duplicateReplicas.mkString(",")}));
                }
                throw new MatchError(null);
            })).mkString(". ");
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{duplicatesMsg})));
        }
        return new Tuple2((Object)var3_3.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<scala.collection.immutable.Set<TopicPartition>, scala.collection.immutable.Set<TopicPartitionReplica>> cancelAssignment(Admin adminClient, String jsonString, boolean preserveThrottles, long timeoutMs, Time time) {
        void var9_8;
        void var8_7;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq targetParts = (Seq)tuple2._1();
        Map targetReplicas = (Map)tuple2._2();
        scala.collection.immutable.Set targetPartsSet = ((IterableOnceOps)var8_7.map((Function1 & Serializable)x$27 -> (TopicPartition)x$27._1())).toSet();
        scala.collection.immutable.Set curReassigningParts = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)adminClient.listPartitionReassignments(CollectionConverters$.MODULE$.SetHasAsJava((Set)targetPartsSet).asJava()).reassignments().get()).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition part = (TopicPartition)x0$1._1();
                PartitionReassignment reassignment = (PartitionReassignment)x0$1._2();
                if (!reassignment.addingReplicas().isEmpty() || !reassignment.removingReplicas().isEmpty()) {
                    return new Some((Object)part);
                }
                return None$.MODULE$;
            }
            throw new MatchError(null);
        })).toSet();
        if (curReassigningParts.nonEmpty()) {
            Map<TopicPartition, Throwable> errors = this.cancelPartitionReassignments(adminClient, (scala.collection.immutable.Set<TopicPartition>)curReassigningParts);
            if (errors.nonEmpty()) {
                throw new ReassignPartitionsCommand.TerseReassignmentFailureException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Error cancelling partition reassignment%s for:%n%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{errors.size() == 1 ? "" : "s", ((IterableOnceOps)((IterableOps)errors.keySet().toBuffer().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable)part -> new StringBuilder(2).append(part).append(": ").append(((Throwable)errors.apply(part)).getMessage()).toString())).mkString(System.lineSeparator())})));
            }
            Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Successfully cancelled partition reassignment%s for: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{curReassigningParts.size() == 1 ? "" : "s", String.valueOf(((IterableOnceOps)curReassigningParts.toBuffer().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).mkString(","))})));
        } else {
            Predef$.MODULE$.println((Object)"None of the specified partition reassignments are active.");
        }
        scala.collection.immutable.Map curMovingParts = this.findLogDirMoveStates(adminClient, (Map<TopicPartitionReplica, String>)var9_8).flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartitionReplica part = (TopicPartitionReplica)x0$2._1();
                ReassignPartitionsCommand.LogDirMoveState moveState = (ReassignPartitionsCommand.LogDirMoveState)x0$2._2();
                if (moveState instanceof ReassignPartitionsCommand.ActiveMoveState) {
                    ReassignPartitionsCommand.ActiveMoveState activeMoveState = (ReassignPartitionsCommand.ActiveMoveState)moveState;
                    return new Some((Object)new Tuple2((Object)part, (Object)activeMoveState.currentLogDir()));
                }
                return None$.MODULE$;
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (curMovingParts.isEmpty()) {
            Predef$.MODULE$.println((Object)"None of the specified partition moves are active.");
        } else {
            this.executeMoves(adminClient, (Map<TopicPartitionReplica, String>)curMovingParts, timeoutMs, time);
        }
        if (!preserveThrottles) {
            this.clearAllThrottles(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var8_7);
        }
        return new Tuple2((Object)curReassigningParts, (Object)curMovingParts.keySet());
    }

    public long cancelAssignment$default$4() {
        return 10000L;
    }

    public Time cancelAssignment$default$5() {
        return Time.SYSTEM;
    }

    public String formatAsReassignmentJson(Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartitionReplica, String> replicaLogDirAssignment) {
        return Json$.MODULE$.encodeAsString(CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)partitionsToBeReassigned.keySet().toBuffer().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable)tp -> {
            Seq replicas = (Seq)partitionsToBeReassigned.apply(tp);
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)tp.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)tp.partition())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicas"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava(replicas).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log_dirs"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)r -> ReassignPartitionsCommand$.$anonfun$formatAsReassignmentJson$3(replicaLogDirAssignment, tp, BoxesRunTime.unboxToInt((Object)r)))).asJava())}))).asJava();
        })).asJava())}))).asJava());
    }

    public Seq<String> parseTopicsData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt((Object)((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
            } else if (None$.MODULE$.equals(option2)) {
                n = this.EarliestTopicsJsonVersion();
            } else {
                throw new MatchError(option2);
            }
            int version = n;
            return this.parseTopicsData(version, js);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("The input string is not a valid JSON");
        }
        throw new MatchError(option);
    }

    public Seq<String> parseTopicsData(int version, JsonValue js) {
        switch (version) {
            case 1: {
                return (Seq)Option$.MODULE$.option2Iterable(js.asJsonObject().get("topics")).toSeq().flatMap((Function1 & Serializable)partitionsSeq -> partitionsSeq.asJsonArray().iterator().map((Function1 & Serializable)p -> p.asJsonObject().apply("topic").to(DecodeJson$DecodeString$.MODULE$)));
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(String jsonData) {
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseFull(jsonData);
        if (either instanceof Right) {
            int n;
            JsonValue js = (JsonValue)((Right)either).value();
            Option<JsonValue> option = js.asJsonObject().get("version");
            if (option instanceof Some) {
                n = BoxesRunTime.unboxToInt((Object)((JsonValue)((Some)option).value()).to(DecodeJson$DecodeInt$.MODULE$));
            } else if (None$.MODULE$.equals(option)) {
                n = this.EarliestVersion();
            } else {
                throw new MatchError(option);
            }
            int version = n;
            return this.parsePartitionReassignmentData(version, js);
        }
        if (either instanceof Left) {
            JsonProcessingException f = (JsonProcessingException)((Left)either).value();
            throw new AdminOperationException((Throwable)f);
        }
        throw new MatchError(either);
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(int version, JsonValue jsonData) {
        switch (version) {
            case 1: {
                ListBuffer partitionAssignment = ListBuffer$.MODULE$.empty();
                scala.collection.mutable.Map replicaAssignment = (scala.collection.mutable.Map)Map$.MODULE$.empty();
                Option$.MODULE$.option2Iterable(jsonData.asJsonObject().get("partitions")).toSeq().foreach((Function1 & Serializable)partitionsSeq -> {
                    ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1(partitionAssignment, replicaAssignment, partitionsSeq);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2((Object)partitionAssignment, (Object)replicaAssignment);
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)this.helpText());
        .colon.colon validActions = new .colon.colon((Object)opts.generateOpt(), (List)new .colon.colon((Object)opts.executeOpt(), (List)new .colon.colon((Object)opts.verifyOpt(), (List)new .colon.colon((Object)opts.cancelOpt(), (List)new .colon.colon((Object)opts.listOpt(), (List)Nil$.MODULE$)))));
        Seq allActions = (Seq)validActions.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)opts.options.has(x$1)));
        if (allActions.size() != 1) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Command must include exactly one action: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((IterableOnceOps)validActions.map((Function1 & Serializable)x$30 -> new StringBuilder(2).append("--").append(x$30.options().get(0)).toString())).mkString(", ")})));
        }
        OptionSpecBuilder action = (OptionSpecBuilder)allActions.head();
        if (!opts.options.has(opts.bootstrapServerOpt())) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)"Please specify --bootstrap-server");
        }
        Map requiredArgs = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opts.verifyOpt()), (Object)new .colon.colon(opts.reassignmentJsonFileOpt(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opts.generateOpt()), (Object)new .colon.colon(opts.topicsToMoveJsonFileOpt(), (List)new .colon.colon(opts.brokerListOpt(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opts.executeOpt()), (Object)new .colon.colon(opts.reassignmentJsonFileOpt(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opts.cancelOpt()), (Object)new .colon.colon(opts.reassignmentJsonFileOpt(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opts.listOpt()), (Object)Seq$.MODULE$.empty())}));
        CommandLineUtils.checkRequiredArgs((OptionParser)opts.parser, (OptionSet)opts.options, (OptionSpec[])((OptionSpec[])((IterableOnceOps)requiredArgs.apply((Object)action)).toArray(ClassTag$.MODULE$.apply(ArgumentAcceptingOptionSpec.class))));
        Map permittedArgs = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opts.verifyOpt()), (Object)new .colon.colon(opts.bootstrapServerOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)new .colon.colon((Object)opts.preserveThrottlesOpt(), (List)Nil$.MODULE$)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opts.generateOpt()), (Object)new .colon.colon(opts.bootstrapServerOpt(), (List)new .colon.colon(opts.brokerListOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)new .colon.colon((Object)opts.disableRackAware(), (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opts.executeOpt()), (Object)new .colon.colon((Object)opts.additionalOpt(), (List)new .colon.colon(opts.bootstrapServerOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)new .colon.colon(opts.interBrokerThrottleOpt(), (List)new .colon.colon(opts.replicaAlterLogDirsThrottleOpt(), (List)new .colon.colon(opts.timeoutOpt(), (List)Nil$.MODULE$))))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opts.cancelOpt()), (Object)new .colon.colon(opts.bootstrapServerOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)new .colon.colon((Object)opts.preserveThrottlesOpt(), (List)new .colon.colon(opts.timeoutOpt(), (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)opts.listOpt()), (Object)new .colon.colon(opts.bootstrapServerOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)Nil$.MODULE$)))}));
        opts.options.specs().forEach(opt -> {
            if (!(opt.equals(action) || ((SeqOps)requiredArgs.apply((Object)action)).contains(opt) || ((SeqOps)permittedArgs.apply((Object)action)).contains(opt))) {
                CommandLineUtils.printUsageAndExit((OptionParser)opts$1.parser, (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Option \"%s\" can't be used with action \"%s\""), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{opt, action})));
                return;
            }
        });
        return opts;
    }

    public scala.collection.immutable.Set<TopicPartitionReplica> alterReplicaLogDirs(Admin adminClient, Map<TopicPartitionReplica, String> assignment) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(adminClient.alterReplicaLogDirs(CollectionConverters$.MODULE$.MapHasAsJava(assignment).asJava()).values()).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartitionReplica replica = (TopicPartitionReplica)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    return new Some((Object)replica);
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (throwable instanceof ReplicaNotAvailableException) {
                        return None$.MODULE$;
                    }
                    if (throwable != null) {
                        throw new AdminCommandFailedException(new StringBuilder(24).append("Failed to alter dir for ").append(replica).toString(), throwable);
                    }
                    throw new MatchError(null);
                }
            }
            throw new MatchError(null);
        })).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$findPartitionReassignmentStates$1(scala.collection.mutable.Map currentReassignments$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition part = (TopicPartition)x0$1._1();
            return currentReassignments$1.contains((Object)part);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$findPartitionReassignmentStates$3(Integer i) {
        return BoxesRunTime.unboxToInt((Object)i);
    }

    public static final /* synthetic */ int $anonfun$findPartitionReassignmentStates$6(Integer x$6) {
        return BoxesRunTime.unboxToInt((Object)x$6);
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadata$3(BrokerMetadata x$16) {
        return x$16.rack().isEmpty();
    }

    public static final /* synthetic */ Nothing$ $anonfun$verifyBrokerIds$3(int id) {
        throw new AdminCommandFailedException(new StringBuilder(18).append("Unknown broker id ").append(id).toString());
    }

    public static final /* synthetic */ boolean $anonfun$currentPartitionReplicaAssignmentToString$1(Map proposedParts$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition k = (TopicPartition)x0$1._1();
            return proposedParts$1.contains((Object)k);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$calculateCurrentMoveMap$2(Object x) {
        return BoxesRunTime.unboxToInt((Object)x);
    }

    public static final /* synthetic */ int $anonfun$calculateCurrentMoveMap$3(Object x) {
        return BoxesRunTime.unboxToInt((Object)x);
    }

    public static final /* synthetic */ void $anonfun$calculateLeaderThrottles$2(TreeSet components$1, int partId, ReassignPartitionsCommand.PartitionMove move) {
        move.sources().foreach((Function1)(JFunction1.mcZI.sp & Serializable)source -> components$1.add((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%d:%d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partId), BoxesRunTime.boxToInteger((int)source)}))));
    }

    public static final /* synthetic */ Object $anonfun$calculateFollowerThrottles$3(ReassignPartitionsCommand.PartitionMove move$1, TreeSet components$2, int partId$2, int destination) {
        if (!move$1.sources().contains((Object)BoxesRunTime.boxToInteger((int)destination))) {
            return BoxesRunTime.boxToBoolean((boolean)components$2.add((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%d:%d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partId$2), BoxesRunTime.boxToInteger((int)destination)}))));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$calculateFollowerThrottles$2(TreeSet components$2, int partId, ReassignPartitionsCommand.PartitionMove move) {
        move.destinations().foreach((Function1 & Serializable)destination -> ReassignPartitionsCommand$.$anonfun$calculateFollowerThrottles$3(move, components$2, partId, BoxesRunTime.unboxToInt((Object)destination)));
    }

    public static final /* synthetic */ void $anonfun$calculateReassigningBrokers$2(TreeSet reassigningBrokers$1, ReassignPartitionsCommand.PartitionMove partMove) {
        partMove.sources().foreach((Function1)(JFunction1.mcZI.sp & Serializable)elem -> reassigningBrokers$1.add((Object)BoxesRunTime.boxToInteger((int)elem)));
        partMove.destinations().foreach((Function1)(JFunction1.mcZI.sp & Serializable)elem -> reassigningBrokers$1.add((Object)BoxesRunTime.boxToInteger((int)elem)));
    }

    public static final /* synthetic */ void $anonfun$calculateReassigningBrokers$1(TreeSet reassigningBrokers$1, scala.collection.mutable.Map x$22) {
        x$22.values().foreach((Function1 & Serializable)partMove -> {
            ReassignPartitionsCommand$.$anonfun$calculateReassigningBrokers$2(reassigningBrokers$1, partMove);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Collection $anonfun$modifyInterBrokerThrottle$1(long interBrokerThrottle$1, HashMap configs$2, int brokerId) {
        ArrayList<AlterConfigOp> ops = new ArrayList<AlterConfigOp>();
        ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelLeaderThrottle(), Long.toString(interBrokerThrottle$1)), AlterConfigOp.OpType.SET));
        ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelFollowerThrottle(), Long.toString(interBrokerThrottle$1)), AlterConfigOp.OpType.SET));
        return configs$2.put(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(brokerId)), ops);
    }

    public static final /* synthetic */ Collection $anonfun$modifyLogDirThrottle$1(long logDirThrottle$1, HashMap configs$3, int brokerId) {
        ArrayList<AlterConfigOp> ops = new ArrayList<AlterConfigOp>();
        ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelLogDirThrottle(), Long.toString(logDirThrottle$1)), AlterConfigOp.OpType.SET));
        return configs$3.put(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(brokerId)), ops);
    }

    public static final /* synthetic */ boolean $anonfun$parseExecuteAssignmentArgs$1(Tuple2 x$25) {
        return ((SeqOps)x$25._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseExecuteAssignmentArgs$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return ((Iterable)x0$3._2()).nonEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$formatAsReassignmentJson$3(Map replicaLogDirAssignment$1, TopicPartition tp$1, int r) {
        return (String)replicaLogDirAssignment$1.getOrElse((Object)new TopicPartitionReplica(tp$1.topic(), tp$1.partition(), r), (Function0 & Serializable)() -> MODULE$.AnyLogDir());
    }

    public static final /* synthetic */ boolean $anonfun$parsePartitionReassignmentData$5(Tuple2 x$29) {
        Object object = x$29._2();
        String string = MODULE$.AnyLogDir();
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$1(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue partitionsSeq) {
        partitionsSeq.asJsonArray().iterator().foreach((Function1 & Serializable)p -> {
            Seq seq;
            void decodeSeq_factory;
            JsonObject partitionFields = p.asJsonObject();
            String topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt((Object)partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            Factory factory = scala.collection.Seq$.MODULE$.iterableFactory();
            DecodeJson$DecodeInt$ decodeSeq_decodeJson = DecodeJson$DecodeInt$.MODULE$;
            Object var9_7 = null;
            factory = null;
            Seq newReplicas = (Seq)partitionFields.apply("replicas").to(new DecodeJson<S>(decodeSeq_decodeJson, (Factory)decodeSeq_factory){
                private final DecodeJson decodeJson$2;
                private final Factory factory$1;

                public Object decode(JsonNode node) {
                    return DecodeJson.decode$(this, node);
                }

                public final Either<String, S> decodeEither(JsonNode node) {
                    return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeSeq$1(node, this.decodeJson$2, this.factory$1);
                }
                {
                    this.decodeJson$2 = decodeJson$2;
                    this.factory$1 = factory$1;
                }
            });
            Option<JsonValue> option = partitionFields.get("log_dirs");
            if (option instanceof Some) {
                void decodeSeq_factory2;
                Factory factory2 = scala.collection.Seq$.MODULE$.iterableFactory();
                DecodeJson$DecodeString$ decodeSeq_decodeJson2 = DecodeJson$DecodeString$.MODULE$;
                Object var11_11 = null;
                factory2 = null;
                seq = (Seq)((JsonValue)((Some)option).value()).to(new /* invalid duplicate definition of identical inner class */);
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq)newReplicas.map((Function1 & Serializable)x$28 -> ReassignPartitionsCommand$.MODULE$.AnyLogDir());
            } else {
                throw new MatchError(option);
            }
            Seq newLogDirs = seq;
            if (newReplicas.size() != newLogDirs.size()) {
                throw new AdminCommandFailedException(new StringBuilder(78).append("Size of replicas list ").append(newReplicas).append(" is different from ").append("size of log dirs list ").append(newLogDirs).append(" for partition ").append(new TopicPartition(topic, partition)).toString());
            }
            partitionAssignment$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)newReplicas));
            return (scala.collection.mutable.Map)replicaAssignment$1.$plus$plus$eq((IterableOnce)((IterableOps)((IterableOps)newReplicas.zip((IterableOnce)newLogDirs)).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int replica = x0$1._1$mcI$sp();
                    String logDir = (String)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, partition, replica)), (Object)logDir);
                }
                throw new MatchError(null);
            })).filter((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$5(x$29))));
        });
    }

    private ReassignPartitionsCommand$() {
    }
}

