/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import io.confluent.ksql.engine.rewrite.ExpressionTreeRewriter;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.VisitParentExpressionVisitor;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.ColumnNames;
import java.util.ArrayList;
import java.util.Optional;

public class AggregateExpressionRewriter
extends VisitParentExpressionVisitor<Optional<Expression>, ExpressionTreeRewriter.Context<Void>> {
    private int aggVariableIndex = 0;
    private final FunctionRegistry functionRegistry;

    public AggregateExpressionRewriter(FunctionRegistry functionRegistry) {
        super(Optional.empty());
        this.functionRegistry = functionRegistry;
    }

    public Optional<Expression> visitFunctionCall(FunctionCall node, ExpressionTreeRewriter.Context<Void> context) {
        FunctionName functionName = node.getName();
        if (this.functionRegistry.isAggregate(functionName)) {
            ColumnName aggVarName = ColumnNames.aggregateColumn((int)this.aggVariableIndex);
            ++this.aggVariableIndex;
            return Optional.of(new UnqualifiedColumnReferenceExp(node.getLocation(), aggVarName));
        }
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        for (Expression argExpression : node.getArguments()) {
            arguments.add(context.process(argExpression));
        }
        return Optional.of(new FunctionCall(node.getLocation(), node.getName(), arguments));
    }
}

