/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.analyzer.ColumnReferenceValidator;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.expression.formatter.ExpressionFormatter;
import io.confluent.ksql.execution.expression.tree.BytesLiteral;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.ComparisonExpression;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.LogicalBinaryExpression;
import io.confluent.ksql.execution.expression.tree.SearchedCaseExpression;
import io.confluent.ksql.execution.expression.tree.TraversalExpressionVisitor;
import io.confluent.ksql.execution.streams.PartitionByParamsFactory;
import io.confluent.ksql.execution.util.ColumnExtractor;
import io.confluent.ksql.execution.windows.KsqlWindowExpression;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.DefaultTraversalVisitor;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinOn;
import io.confluent.ksql.parser.tree.JoinedSource;
import io.confluent.ksql.parser.tree.PartitionBy;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Sink;
import io.confluent.ksql.parser.tree.StructAll;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.planner.plan.JoinNode;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.UnknownColumnException;
import io.confluent.ksql.util.UnknownSourceException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Analyzer {
    private static final String KAFKA_VALUE_FORMAT_LIMITATION_DETAILS = "The KAFKA format is primarily intended for use as a key format. It can be used as a value format, but can not be used in any operation that requires a repartition or changelog topic." + System.lineSeparator() + "Removing this limitation requires enhancements to the core of KSQL. This will come in a future release. Until then, avoid using the KAFKA format for values." + System.lineSeparator() + "If you have an existing topic with KAFKA formatted values you can duplicate the data and serialize using Avro or JSON with a statement such as: " + System.lineSeparator() + System.lineSeparator() + "'CREATE STREAM <new-stream-name> WITH(VALUE_FORMAT='Avro') AS SELECT * FROM <existing-kafka-formated-stream-name>;'" + System.lineSeparator() + "For more info see https://github.com/confluentinc/ksql/issues/3060";
    private final MetaStore metaStore;
    private final String topicPrefix;
    private final boolean pullLimitClauseEnabled;

    Analyzer(MetaStore metaStore, String topicPrefix, boolean pullLimitClauseEnabled) {
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
        this.topicPrefix = Objects.requireNonNull(topicPrefix, "topicPrefix");
        this.pullLimitClauseEnabled = pullLimitClauseEnabled;
    }

    Analysis analyze(Query query, Optional<Sink> sink) {
        Visitor visitor = new Visitor(query, sink.isPresent());
        visitor.process((AstNode)query, null);
        sink.ifPresent(x$0 -> visitor.analyzeNonStdOutSink(x$0));
        visitor.validate();
        return visitor.analysis;
    }

    private final class Visitor
    extends DefaultTraversalVisitor<AstNode, Void> {
        private final Analysis analysis;
        private final boolean persistent;
        private boolean isJoin = false;
        private boolean isGroupBy = false;

        Visitor(Query query, boolean persistent) {
            this.analysis = new Analysis(query.getRefinement(), Analyzer.this.pullLimitClauseEnabled);
            this.persistent = persistent;
        }

        private void analyzeNonStdOutSink(Sink sink) {
            CreateSourceAsProperties props = sink.getProperties();
            this.analysis.setProperties(props);
            if (!sink.shouldCreateSink()) {
                DataSource existing = Analyzer.this.metaStore.getSource(sink.getName());
                if (existing == null) {
                    throw new KsqlException("Unknown source: " + sink.getName().toString(FormatOptions.noEscape()));
                }
                this.analysis.setInto(Analysis.Into.existingSink(sink.getName(), existing.getKsqlTopic()));
                return;
            }
            String topicName = props.getKafkaTopic().orElseGet(() -> Analyzer.this.topicPrefix + sink.getName().text());
            KsqlTopic srcTopic = this.analysis.getFrom().getDataSource().getKsqlTopic();
            String keyFormatName = this.keyFormatName(props.getKeyFormat(), srcTopic.getKeyFormat().getFormatInfo());
            FormatInfo keyFmtInfo = this.buildFormatInfo(keyFormatName, props.getKeyFormatProperties(sink.getName().text(), keyFormatName), srcTopic.getKeyFormat().getFormatInfo());
            String valueFormatName = this.formatName(props.getValueFormat(), srcTopic.getValueFormat().getFormatInfo());
            FormatInfo valueFmtInfo = this.buildFormatInfo(valueFormatName, props.getValueFormatProperties(valueFormatName), srcTopic.getValueFormat().getFormatInfo());
            Optional explicitWindowInfo = this.analysis.getWindowExpression().map(WindowExpression::getKsqlWindowExpression).map(KsqlWindowExpression::getWindowInfo);
            Optional windowInfo = explicitWindowInfo.isPresent() ? explicitWindowInfo : srcTopic.getKeyFormat().getWindowInfo();
            this.analysis.setInto(Analysis.Into.newSink(sink.getName(), topicName, windowInfo, keyFmtInfo, valueFmtInfo));
            this.analysis.setOrReplace(sink.shouldReplace());
        }

        private String keyFormatName(Optional<String> explicitFormat, FormatInfo sourceFormat) {
            boolean partitioningByNull = this.analysis.getPartitionBy().map(pb -> PartitionByParamsFactory.isPartitionByNull((List)pb.getExpressions())).orElse(false);
            if (partitioningByNull) {
                boolean nonNoneExplicitFormat = explicitFormat.map(fmt -> !fmt.equalsIgnoreCase("NONE")).orElse(false);
                if (nonNoneExplicitFormat) {
                    throw new KsqlException("Key format specified for stream without key columns.");
                }
                return "NONE";
            }
            return this.formatName(explicitFormat, sourceFormat);
        }

        private String formatName(Optional<String> explicitFormat, FormatInfo sourceFormat) {
            return explicitFormat.orElse(sourceFormat.getFormat());
        }

        private FormatInfo buildFormatInfo(String formatName, Map<String, String> formatProperties, FormatInfo sourceFormat) {
            Format format = FormatFactory.fromName((String)formatName);
            HashMap<String, String> props = new HashMap<String, String>();
            if (formatName.equals(sourceFormat.getFormat())) {
                sourceFormat.getProperties().forEach((k, v) -> {
                    if (format.getInheritableProperties().contains(k)) {
                        props.put((String)k, (String)v);
                    }
                });
            }
            props.putAll(formatProperties);
            return FormatInfo.of((String)formatName, props);
        }

        protected AstNode visitQuery(Query node, Void context) {
            this.process((AstNode)node.getFrom(), context);
            node.getWhere().ifPresent(this::analyzeWhere);
            node.getGroupBy().ifPresent(this::analyzeGroupBy);
            node.getPartitionBy().ifPresent(this::analyzePartitionBy);
            node.getWindow().ifPresent(this::analyzeWindowExpression);
            node.getHaving().ifPresent(this::analyzeHaving);
            node.getLimit().ifPresent(this.analysis::setLimitClause);
            this.process((AstNode)node.getSelect(), context);
            this.throwOnUnknownColumnReference(!node.isPullQuery() && !node.getGroupBy().isPresent());
            return null;
        }

        private void throwOnUnknownColumnReference(boolean possibleSyntheticColumns) {
            ColumnReferenceValidator columnValidator = new ColumnReferenceValidator(this.analysis.getFromSourceSchemas(true), possibleSyntheticColumns);
            this.analysis.getWhereExpression().ifPresent(expression -> columnValidator.analyzeExpression((Expression)expression, "WHERE"));
            this.analysis.getGroupBy().map(GroupBy::getGroupingExpressions).orElseGet(ImmutableList::of).forEach(expression -> columnValidator.analyzeExpression((Expression)expression, "GROUP BY"));
            try {
                this.analysis.getPartitionBy().map(PartitionBy::getExpressions).orElseGet(ImmutableList::of).forEach(expression -> columnValidator.analyzeExpression((Expression)expression, "PARTITION BY"));
            }
            catch (UnknownColumnException e) {
                throw new UnknownColumnException(e.getPrefix(), e.getColumnExp(), "cannot be resolved. '" + e.getColumnExp() + "' must be a column in the source schema since PARTITION BY is applied on the input.");
            }
            this.analysis.getHavingExpression().ifPresent(expression -> columnValidator.analyzeExpression((Expression)expression, "HAVING"));
            this.analysis.getSelectItems().stream().filter(si -> si instanceof SingleColumn).map(SingleColumn.class::cast).map(SingleColumn::getExpression).forEach(expression -> columnValidator.analyzeExpression((Expression)expression, "SELECT"));
        }

        protected AstNode visitJoin(Join node, Void context) {
            this.isJoin = true;
            this.process((AstNode)node.getLeft(), context);
            node.getRights().forEach(right -> {
                AstNode cfr_ignored_0 = (AstNode)this.process((AstNode)right, context);
            });
            return null;
        }

        protected AstNode visitJoinedSource(JoinedSource node, Void context) {
            this.process((AstNode)node.getRelation(), context);
            Analysis.AliasedDataSource source = this.analysis.getSourceByAlias(((AliasedRelation)node.getRelation()).getAlias()).orElseThrow(() -> new IllegalStateException("Expected to register source in above process call"));
            JoinNode.JoinType joinType = this.getJoinType(node);
            JoinOn joinOn = (JoinOn)node.getCriteria();
            Expression joinExp = joinOn.getExpression();
            if (!(joinExp instanceof ComparisonExpression)) {
                if (joinExp instanceof LogicalBinaryExpression && this.isEqualityJoin(((LogicalBinaryExpression)joinExp).getLeft()) && this.isEqualityJoin(((LogicalBinaryExpression)joinExp).getRight())) {
                    throw new KsqlException(String.format("Invalid join condition: joins on multiple conditions are not yet supported. Got %s.", joinExp));
                }
                throw new KsqlException("Unsupported join expression: " + joinExp);
            }
            ComparisonExpression comparisonExpression = (ComparisonExpression)joinExp;
            if (!this.isEqualityJoin(joinExp)) {
                throw new KsqlException("Only equality join criteria is supported.");
            }
            ColumnReferenceValidator columnValidator = new ColumnReferenceValidator(this.analysis.getFromSourceSchemas(false), false);
            Set<SourceName> srcsUsedInLeft = columnValidator.analyzeExpression(comparisonExpression.getLeft(), "JOIN ON");
            Set<SourceName> srcsUsedInRight = columnValidator.analyzeExpression(comparisonExpression.getRight(), "JOIN ON");
            SourceName leftSourceName = this.getOnlySourceForJoin(comparisonExpression.getLeft(), comparisonExpression, srcsUsedInLeft);
            SourceName rightSourceName = this.getOnlySourceForJoin(comparisonExpression.getRight(), comparisonExpression, srcsUsedInRight);
            Analysis.AliasedDataSource left = this.analysis.getSourceByAlias(leftSourceName).orElseThrow(() -> new KsqlException("Cannot join on unknown source: " + leftSourceName));
            Analysis.AliasedDataSource right = this.analysis.getSourceByAlias(rightSourceName).orElseThrow(() -> new KsqlException("Cannot join on unknown source: " + leftSourceName));
            this.throwOnIncompleteJoinCriteria(left, right, leftSourceName, rightSourceName);
            this.throwOnIncompatibleSourceWindowing(left, right);
            this.throwOnJoinWithoutSource(source, left, right);
            boolean flipped = rightSourceName.equals((Object)this.analysis.getFrom().getAlias());
            Analysis.JoinInfo joinInfo = new Analysis.JoinInfo(left, comparisonExpression.getLeft(), right, comparisonExpression.getRight(), joinType, flipped, node.getWithinExpression());
            this.analysis.addJoin(flipped ? joinInfo.flip() : joinInfo);
            return null;
        }

        private boolean isEqualityJoin(Expression exp) {
            return exp instanceof ComparisonExpression && ((ComparisonExpression)exp).getType() == ComparisonExpression.Type.EQUAL;
        }

        private void throwOnJoinWithoutSource(Analysis.AliasedDataSource source, Analysis.AliasedDataSource left, Analysis.AliasedDataSource right) {
            if (!source.equals(left) && !source.equals(right)) {
                throw new KsqlException("A join criteria is expected to reference the source (" + source.getAlias() + ") in the FROM clause, instead the right source references " + right.getAlias() + " and the left source references " + left.getAlias());
            }
        }

        private void throwOnIncompleteJoinCriteria(Analysis.AliasedDataSource left, Analysis.AliasedDataSource right, SourceName leftExpressionSource, SourceName rightExpressionSource) {
            boolean valid;
            ImmutableSet usedSources = ImmutableSet.of((Object)leftExpressionSource, (Object)rightExpressionSource);
            boolean bl = valid = usedSources.size() == 2 && usedSources.containsAll((Collection)ImmutableList.of((Object)left.getAlias(), (Object)right.getAlias()));
            if (!valid) {
                throw new KsqlException("Each side of the join must reference exactly one source and not the same source. Left side references " + leftExpressionSource + " and right references " + rightExpressionSource);
            }
        }

        private void throwOnIncompatibleSourceWindowing(Analysis.AliasedDataSource left, Analysis.AliasedDataSource right) {
            boolean compatible;
            Optional<WindowType> leftWindowType = left.getDataSource().getKsqlTopic().getKeyFormat().getWindowInfo().map(WindowInfo::getType);
            Optional<WindowType> rightWindowType = right.getDataSource().getKsqlTopic().getKeyFormat().getWindowInfo().map(WindowInfo::getType);
            if (leftWindowType.isPresent() != rightWindowType.isPresent()) {
                throw this.windowedNonWindowedJoinException(left, right, leftWindowType, rightWindowType);
            }
            if (!leftWindowType.isPresent()) {
                return;
            }
            WindowType leftWt = leftWindowType.get();
            WindowType rightWt = rightWindowType.get();
            boolean bl = leftWt == WindowType.SESSION ? rightWt == WindowType.SESSION : (compatible = rightWt == WindowType.HOPPING || rightWt == WindowType.TUMBLING);
            if (!compatible) {
                throw new KsqlException("Incompatible windowed sources." + System.lineSeparator() + "Left source: " + leftWt + System.lineSeparator() + "Right source: " + rightWt + System.lineSeparator() + "Session windowed sources can only be joined to other session windowed sources, and may still not result in expected behaviour as session bounds must be an exact match for the join to work" + System.lineSeparator() + "Hopping and tumbling windowed sources can only be joined to other hopping and tumbling windowed sources");
            }
        }

        private KsqlException windowedNonWindowedJoinException(Analysis.AliasedDataSource left, Analysis.AliasedDataSource right, Optional<WindowType> leftWindowType, Optional<WindowType> rightWindowType) {
            String leftMsg = leftWindowType.map(Object::toString).orElse("not");
            String rightMsg = rightWindowType.map(Object::toString).orElse("not");
            return new KsqlException("Can not join windowed source to non-windowed source." + System.lineSeparator() + left.getAlias() + " is " + leftMsg + " windowed" + System.lineSeparator() + right.getAlias() + " is " + rightMsg + " windowed");
        }

        private SourceName getOnlySourceForJoin(Expression exp, ComparisonExpression join, Set<SourceName> sources) {
            try {
                return (SourceName)Iterables.getOnlyElement(sources);
            }
            catch (Exception e) {
                throw new KsqlException("Invalid comparison expression '" + exp + "' in join '" + join + "'. Each side of the join comparision must contain references from exactly one source.");
            }
        }

        private JoinNode.JoinType getJoinType(JoinedSource source) {
            JoinNode.JoinType joinType;
            switch (source.getType()) {
                case INNER: {
                    joinType = JoinNode.JoinType.INNER;
                    break;
                }
                case LEFT: {
                    joinType = JoinNode.JoinType.LEFT;
                    break;
                }
                case RIGHT: {
                    joinType = JoinNode.JoinType.RIGHT;
                    break;
                }
                case OUTER: {
                    joinType = JoinNode.JoinType.OUTER;
                    break;
                }
                default: {
                    throw new KsqlException("Join type is not supported: " + source.getType().name());
                }
            }
            return joinType;
        }

        protected AstNode visitAliasedRelation(AliasedRelation node, Void context) {
            SourceName sourceName = ((Table)node.getRelation()).getName();
            DataSource source = Analyzer.this.metaStore.getSource(sourceName);
            if (source == null) {
                throw new UnknownSourceException(Optional.empty(), sourceName);
            }
            Optional<Analysis.AliasedDataSource> existing = this.analysis.getSourceByName(source.getName());
            if (existing.isPresent()) {
                String errorMsg = this.analysis.getAllDataSources().size() > 1 ? "N-way joins do not support multiple occurrences of the same source. Source: '" + sourceName.toString(FormatOptions.noEscape()) + "'." : "Can not join '" + sourceName.toString(FormatOptions.noEscape()) + "' to '" + existing.get().getDataSource().getName().toString(FormatOptions.noEscape()) + "': self joins are not yet supported.";
                throw new KsqlException(errorMsg);
            }
            this.analysis.addDataSource(node.getAlias(), source);
            return node;
        }

        protected AstNode visitSelect(Select node, Void context) {
            for (SelectItem selectItem : node.getSelectItems()) {
                this.analysis.addSelectItem(selectItem);
                if (selectItem instanceof SingleColumn) {
                    SingleColumn column = (SingleColumn)selectItem;
                    this.validateSelect(column);
                    this.captureReferencedSourceColumns(column.getExpression());
                    this.visitTableFunctions(column.getExpression());
                    continue;
                }
                if (selectItem instanceof StructAll) {
                    StructAll structAll = (StructAll)selectItem;
                    this.captureReferencedSourceColumns(structAll.getBaseStruct());
                    continue;
                }
                if (selectItem instanceof AllColumns) continue;
                throw new IllegalArgumentException("Unsupported SelectItem type: " + selectItem.getClass().getName());
            }
            return null;
        }

        private void analyzeWhere(Expression node) {
            this.analysis.setWhereExpression(node);
        }

        private void analyzeGroupBy(GroupBy groupBy) {
            this.isGroupBy = true;
            this.analysis.setGroupBy(groupBy);
        }

        private void analyzePartitionBy(PartitionBy partitionBy) {
            this.analysis.setPartitionBy(partitionBy);
        }

        private void analyzeWindowExpression(WindowExpression windowExpression) {
            this.analysis.setWindowExpression(windowExpression);
        }

        private void analyzeHaving(Expression node) {
            this.analysis.setHavingExpression(node);
        }

        private void validateSelect(SingleColumn column) {
            SystemColumns.systemColumnNames().forEach(col -> this.checkForReservedToken(column, (ColumnName)col));
            if (!this.analysis.getGroupBy().isPresent()) {
                this.addDummyGroupbyForUdafs(column.getExpression());
            }
        }

        private void checkForReservedToken(SingleColumn singleColumn, ColumnName reservedToken) {
            ColumnName alias = (ColumnName)singleColumn.getAlias().orElseThrow(IllegalStateException::new);
            Expression expression = singleColumn.getExpression();
            if (alias.text().equalsIgnoreCase(reservedToken.text())) {
                if (!this.expressionMatchesAlias(expression, alias)) {
                    throw new KsqlException("`" + reservedToken.text() + "` is a reserved column name. You cannot use it as an alias for a column.");
                }
                if (this.persistent) {
                    throw new KsqlException("Reserved column name in select: `" + reservedToken.text() + "`. Please remove or alias the column.");
                }
            }
        }

        private boolean expressionMatchesAlias(Expression expression, ColumnName alias) {
            String text = expression.toString();
            String unqualifiedExpression = text.substring(text.indexOf(".") + 1);
            return unqualifiedExpression.equalsIgnoreCase(alias.text());
        }

        private void addDummyGroupbyForUdafs(Expression expression) {
            new TraversalExpressionVisitor<Void>(){

                public Void visitFunctionCall(FunctionCall functionCall, Void context) {
                    FunctionName functionName = functionCall.getName();
                    if (Analyzer.this.metaStore.isAggregate(functionName)) {
                        Visitor.this.analysis.addAggregateFunction(functionCall);
                        Visitor.this.analysis.setGroupBy(new GroupBy(Optional.empty(), (List)ImmutableList.of((Object)new BytesLiteral(ByteBuffer.wrap(new byte[]{1})))));
                    }
                    super.visitFunctionCall(functionCall, (Object)context);
                    return null;
                }
            }.process(expression, null);
        }

        public void validate() {
            String kafkaSources = this.analysis.getAllDataSources().stream().filter(s -> s.getDataSource().getKsqlTopic().getValueFormat().getFormat().equals("KAFKA")).map(Analysis.AliasedDataSource::getAlias).map(Name::text).collect(Collectors.joining(", "));
            if (kafkaSources.isEmpty()) {
                return;
            }
            if (this.isJoin) {
                throw new KsqlException("Source(s) " + kafkaSources + " are using the 'KAFKA' value format. This format does not yet support JOIN." + System.lineSeparator() + KAFKA_VALUE_FORMAT_LIMITATION_DETAILS);
            }
            if (this.isGroupBy) {
                throw new KsqlException("Source(s) " + kafkaSources + " are using the 'KAFKA' value format. This format does not yet support GROUP BY." + System.lineSeparator() + KAFKA_VALUE_FORMAT_LIMITATION_DETAILS);
            }
        }

        private void captureReferencedSourceColumns(Expression exp) {
            List<ColumnName> columnNames = ColumnExtractor.extractColumns((Expression)exp).stream().map(ColumnReferenceExp::getColumnName).collect(Collectors.toList());
            this.analysis.addSelectColumnRefs(columnNames);
        }

        private void visitTableFunctions(Expression expression) {
            TableFunctionVisitor visitor = new TableFunctionVisitor();
            visitor.process(expression, null);
        }

        private final class TableFunctionVisitor
        extends TraversalExpressionVisitor<Void> {
            private Optional<FunctionName> tableFunctionName = Optional.empty();
            private Optional<SearchedCaseExpression> searchedCaseExpression = Optional.empty();

            private TableFunctionVisitor() {
            }

            public Void visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
                this.searchedCaseExpression = Optional.of(node);
                super.visitSearchedCaseExpression(node, (Object)context);
                return null;
            }

            public Void visitFunctionCall(FunctionCall functionCall, Void context) {
                FunctionName functionName = functionCall.getName();
                boolean isTableFunction = Analyzer.this.metaStore.isTableFunction(functionName);
                if (isTableFunction) {
                    if (this.tableFunctionName.isPresent()) {
                        throw new KsqlException("Table functions cannot be nested: " + this.tableFunctionName.get() + "(" + functionName + "())");
                    }
                    this.tableFunctionName = Optional.of(functionName);
                    if (Visitor.this.analysis.getGroupBy().isPresent()) {
                        throw new KsqlException("Table functions cannot be used with aggregations.");
                    }
                    if (this.searchedCaseExpression.isPresent()) {
                        throw new KsqlException("Table functions cannot be used in CASE: " + ExpressionFormatter.formatExpression((Expression)((Expression)this.searchedCaseExpression.get())));
                    }
                    Visitor.this.analysis.addTableFunction(functionCall);
                }
                super.visitFunctionCall(functionCall, (Object)context);
                if (isTableFunction) {
                    this.tableFunctionName = Optional.empty();
                }
                return null;
            }
        }
    }
}

