/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.analyzer;

import com.google.common.collect.Iterables;
import io.confluent.ksql.analyzer.SourceSchemas;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.TraversalExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.util.UnknownColumnException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

class ColumnReferenceValidator {
    private final SourceSchemas sourceSchemas;
    private final boolean possibleSyntheticColumns;

    ColumnReferenceValidator(SourceSchemas sourceSchemas, boolean possibleSyntheticColumns) {
        this.sourceSchemas = Objects.requireNonNull(sourceSchemas, "sourceSchemas");
        this.possibleSyntheticColumns = possibleSyntheticColumns;
    }

    Set<SourceName> analyzeExpression(Expression expression, String clauseType) {
        Validator extractor = new Validator(clauseType);
        extractor.process(expression, null);
        return extractor.referencedSources;
    }

    private final class Validator
    extends TraversalExpressionVisitor<Object> {
        private final String clauseType;
        private final Set<SourceName> referencedSources = new HashSet<SourceName>();

        Validator(String clauseType) {
            this.clauseType = Objects.requireNonNull(clauseType, "clauseType");
        }

        public Void visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, Object context) {
            this.validateColumn((ColumnReferenceExp)node);
            return null;
        }

        public Void visitQualifiedColumnReference(QualifiedColumnReferenceExp node, Object context) {
            this.validateColumn((ColumnReferenceExp)node);
            return null;
        }

        private void validateColumn(ColumnReferenceExp colRef) {
            Set<SourceName> sourcesWithField = ColumnReferenceValidator.this.sourceSchemas.sourcesWithField(colRef.maybeQualifier(), colRef.getColumnName());
            if (sourcesWithField.isEmpty()) {
                if (this.couldBeSyntheticJoinColumn(colRef)) {
                    return;
                }
                throw new UnknownColumnException(this.clauseType, colRef);
            }
            SourceName source = colRef.maybeQualifier().orElseGet(() -> {
                if (SystemColumns.isWindowBound((ColumnName)colRef.getColumnName()) && sourcesWithField.size() > 1) {
                    throw new UnknownColumnException(this.clauseType, colRef);
                }
                return (SourceName)Iterables.getOnlyElement((Iterable)sourcesWithField);
            });
            this.referencedSources.add(source);
        }

        private boolean couldBeSyntheticJoinColumn(ColumnReferenceExp colRef) {
            if (!ColumnReferenceValidator.this.possibleSyntheticColumns) {
                return false;
            }
            if (!ColumnReferenceValidator.this.sourceSchemas.isJoin()) {
                return false;
            }
            if (colRef instanceof QualifiedColumnReferenceExp) {
                return false;
            }
            if (!this.clauseType.equals("SELECT")) {
                return false;
            }
            return ColumnNames.maybeSyntheticJoinKey((ColumnName)colRef.getColumnName());
        }
    }
}

