/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.google.common.collect.Iterables;
import io.confluent.ksql.engine.EngineContext;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.planner.plan.KsqlStructuredDataOutputNode;
import io.confluent.ksql.planner.plan.OutputNode;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.query.id.QueryIdGenerator;
import io.confluent.ksql.util.KsqlException;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class QueryIdUtil {
    private static final Pattern VALID_QUERY_ID = Pattern.compile("[A-Za-z0-9_]+");
    private static final ReservedQueryIdsPrefixes[] PREFIXES = ReservedQueryIdsPrefixes.values();

    private QueryIdUtil() {
    }

    private static void validateWithQueryId(String queryId) {
        Arrays.stream(PREFIXES).forEach(prefixId -> {
            if (queryId.startsWith(prefixId.toString())) {
                throw new KsqlException(String.format("Query IDs must not start with a reserved query ID prefix (%s). Got '%s'.", Arrays.stream(PREFIXES).map(ReservedQueryIdsPrefixes::toString).collect(Collectors.joining(", ")), queryId));
            }
        });
        if (!VALID_QUERY_ID.matcher(queryId).matches()) {
            throw new IllegalArgumentException(String.format("Query IDs may contain only alphanumeric characters and '_'. Got: '%s'", queryId));
        }
    }

    static QueryId buildId(Statement statement, EngineContext engineContext, QueryIdGenerator idGenerator, OutputNode outputNode, boolean createOrReplaceEnabled, Optional<String> withQueryId) {
        if (withQueryId.isPresent()) {
            String queryId = withQueryId.get().toUpperCase();
            QueryIdUtil.validateWithQueryId(queryId);
            return new QueryId(queryId);
        }
        if (statement instanceof CreateTable && ((CreateTable)statement).isSource()) {
            String suffix = ((CreateTable)statement).getName().text().toUpperCase() + "_" + idGenerator.getNext().toUpperCase();
            return new QueryId((Object)((Object)ReservedQueryIdsPrefixes.CST) + suffix);
        }
        if (!outputNode.getSinkName().isPresent()) {
            String prefix = "transient_" + outputNode.getSource().getLeftmostSourceNode().getAlias().text() + "_";
            return new QueryId(prefix + Math.abs(ThreadLocalRandom.current().nextLong()));
        }
        KsqlStructuredDataOutputNode structured = (KsqlStructuredDataOutputNode)outputNode;
        if (!structured.createInto()) {
            return new QueryId((Object)((Object)ReservedQueryIdsPrefixes.INSERT) + idGenerator.getNext());
        }
        SourceName sink = outputNode.getSinkName().get();
        Set<QueryId> queriesForSink = engineContext.getQueryRegistry().getQueriesWithSink(sink);
        if (queriesForSink.size() > 1) {
            throw new KsqlException("REPLACE for sink " + sink + " is not supported because there are multiple queries writing into it: " + queriesForSink);
        }
        if (!queriesForSink.isEmpty()) {
            if (!createOrReplaceEnabled) {
                String type = outputNode.getNodeOutputType().getKsqlType().toLowerCase();
                throw new UnsupportedOperationException(String.format("Cannot add %s '%s': A %s with the same name already exists", type, sink.text(), type));
            }
            return (QueryId)Iterables.getOnlyElement(queriesForSink);
        }
        String suffix = outputNode.getId().toString().toUpperCase() + "_" + idGenerator.getNext().toUpperCase();
        return new QueryId(outputNode.getNodeOutputType() == DataSource.DataSourceType.KTABLE ? (Object)((Object)ReservedQueryIdsPrefixes.CTAS) + suffix : (Object)((Object)ReservedQueryIdsPrefixes.CSAS) + suffix);
    }

    public static enum ReservedQueryIdsPrefixes {
        INSERT("INSERTQUERY_"),
        CTAS("CTAS_"),
        CSAS("CSAS_"),
        CST("CST_");

        private final String prefix;

        private ReservedQueryIdsPrefixes(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }
}

