/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.QueryId;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class QueryPlan {
    private final ImmutableSet<SourceName> sources;
    private final Optional<SourceName> sink;
    private final ExecutionStep<?> physicalPlan;
    private final QueryId queryId;
    private final Optional<String> runtimeId;

    public QueryPlan(@JsonProperty(value="sources", required=true) Set<SourceName> sources, @JsonProperty(value="sink") Optional<SourceName> sink, @JsonProperty(value="physicalPlan", required=true) ExecutionStep<?> physicalPlan, @JsonProperty(value="queryId", required=true) QueryId queryId, @JsonProperty(value="runtimeId") Optional<String> runtimeId) {
        this.sources = ImmutableSortedSet.copyOf(Comparator.comparing(Name::text), (Collection)Objects.requireNonNull(sources, "sources"));
        this.sink = Objects.requireNonNull(sink, "sink");
        this.physicalPlan = Objects.requireNonNull(physicalPlan, "physicalPlan");
        this.queryId = Objects.requireNonNull(queryId, "queryId");
        this.runtimeId = Objects.requireNonNull(runtimeId, "consumerGroupId");
    }

    public Optional<SourceName> getSink() {
        return this.sink;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="sources is ImmutableSet")
    public Set<SourceName> getSources() {
        return this.sources;
    }

    public ExecutionStep<?> getPhysicalPlan() {
        return this.physicalPlan;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Optional<String> getRuntimeId() {
        return this.runtimeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryPlan queryPlan = (QueryPlan)o;
        return Objects.equals(this.sources, queryPlan.sources) && Objects.equals(this.sink, queryPlan.sink) && Objects.equals(this.physicalPlan, queryPlan.physicalPlan) && Objects.equals(this.runtimeId, queryPlan.runtimeId) && Objects.equals(this.queryId, queryPlan.queryId);
    }

    public int hashCode() {
        return Objects.hash(this.sources, this.sink, this.physicalPlan, this.queryId, this.runtimeId);
    }
}

