/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine;

import com.google.common.collect.Iterables;
import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.engine.EngineContext;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import java.util.Set;

public final class ScalablePushQueryExecutionUtil {
    private ScalablePushQueryExecutionUtil() {
    }

    static PersistentQueryMetadata findQuery(EngineContext engineContext, ImmutableAnalysis analysis) {
        DataSource source = analysis.getFrom().getDataSource();
        SourceName sourceName = source.getName();
        Set<QueryId> queries = engineContext.getQueryRegistry().getQueriesWithSink(sourceName);
        if (queries.isEmpty()) {
            throw new IllegalStateException("Scalable push queries require a query that has a sink. Source Name: " + sourceName);
        }
        if (queries.size() > 1) {
            throw new IllegalStateException("Scalable push queries only work on sources that have a single writer query. Source Name: " + sourceName + " Queries: " + queries);
        }
        QueryId queryId = (QueryId)Iterables.getOnlyElement(queries);
        return engineContext.getQueryRegistry().getPersistentQuery(queryId).orElseThrow(() -> new KsqlException("Persistent query has been stopped: " + queryId));
    }
}

