/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine.rewrite;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.confluent.ksql.analyzer.Analysis;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.DefaultTraversalVisitor;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.util.KsqlException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DataSourceExtractor {
    private final MetaStore metaStore;
    private final Set<Analysis.AliasedDataSource> allSources = new HashSet<Analysis.AliasedDataSource>();
    private final Set<ColumnName> allColumns = new HashSet<ColumnName>();
    private final Set<ColumnName> clashingColumns = new HashSet<ColumnName>();
    private boolean isJoin = false;

    public DataSourceExtractor(MetaStore metaStore) {
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
    }

    public Set<Analysis.AliasedDataSource> extractDataSources(AstNode node) {
        new Visitor().process(node, null);
        return this.getAllSources();
    }

    public Set<Analysis.AliasedDataSource> getAllSources() {
        return ImmutableSet.copyOf(this.allSources);
    }

    public boolean isClashingColumnName(ColumnName name) {
        if (!this.isJoin) {
            return false;
        }
        if (SystemColumns.isPseudoColumn((ColumnName)name)) {
            return true;
        }
        return this.clashingColumns.contains(name);
    }

    public List<SourceName> getSourcesFor(ColumnName columnName) {
        return this.allSources.stream().filter(aliased -> DataSourceExtractor.hasColumn(columnName, aliased)).map(Analysis.AliasedDataSource::getAlias).collect(Collectors.toList());
    }

    private static boolean hasColumn(ColumnName columnName, Analysis.AliasedDataSource aliased) {
        if (SystemColumns.isPseudoColumn((ColumnName)columnName)) {
            return true;
        }
        if (aliased.getDataSource().getKsqlTopic().getKeyFormat().isWindowed() && SystemColumns.isWindowBound((ColumnName)columnName)) {
            return true;
        }
        return aliased.getDataSource().getSchema().findColumn(columnName).isPresent();
    }

    private final class Visitor
    extends DefaultTraversalVisitor<Void, Void> {
        private Visitor() {
        }

        public Void visitRelation(Relation relation, Void ctx) {
            throw new IllegalStateException("Unexpected source relation");
        }

        public Void visitAliasedRelation(AliasedRelation relation, Void ctx) {
            SourceName fromName = ((Table)relation.getRelation()).getName();
            DataSource source = DataSourceExtractor.this.metaStore.getSource(fromName);
            if (source == null) {
                String hint = DataSourceExtractor.this.metaStore.checkAlternatives(fromName, Optional.empty());
                throw new KsqlException(fromName.text() + " does not exist." + hint);
            }
            DataSourceExtractor.this.allSources.add(new Analysis.AliasedDataSource(relation.getAlias(), source));
            Set columns = source.getSchema().columns().stream().map(Column::name).collect(Collectors.toSet());
            DataSourceExtractor.this.clashingColumns.addAll(Sets.intersection((Set)DataSourceExtractor.this.allColumns, columns));
            DataSourceExtractor.this.allColumns.addAll(columns);
            return null;
        }

        public Void visitJoin(Join join, Void ctx) {
            DataSourceExtractor.this.isJoin = true;
            return (Void)super.visitJoin(join, (Object)ctx);
        }
    }
}

