/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.engine.rewrite;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.Type;
import io.confluent.ksql.parser.tree.AliasedRelation;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.DropTable;
import io.confluent.ksql.parser.tree.Explain;
import io.confluent.ksql.parser.tree.GroupBy;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.Join;
import io.confluent.ksql.parser.tree.JoinCriteria;
import io.confluent.ksql.parser.tree.JoinOn;
import io.confluent.ksql.parser.tree.JoinedSource;
import io.confluent.ksql.parser.tree.PartitionBy;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.RegisterType;
import io.confluent.ksql.parser.tree.Relation;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.Statements;
import io.confluent.ksql.parser.tree.StructAll;
import io.confluent.ksql.parser.tree.Table;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.parser.tree.TableElements;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.parser.tree.WithinExpression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public final class StatementRewriter<C> {
    private final Rewriter<C> rewriter;

    StatementRewriter(BiFunction<Expression, C, Expression> expressionRewriter, BiFunction<AstNode, Context<C>, Optional<AstNode>> plugin) {
        this.rewriter = new Rewriter((BiFunction)expressionRewriter, (BiFunction)plugin);
    }

    StatementRewriter(BiFunction<Expression, C, Expression> expressionRewriter, BiFunction<AstNode, Context<C>, Optional<AstNode>> plugin, BiFunction<AstNode, C, AstNode> rewriter) {
        this.rewriter = new Rewriter(expressionRewriter, plugin, rewriter);
    }

    public AstNode rewrite(AstNode node, C context) {
        return (AstNode)this.rewriter.process(node, context);
    }

    private static final class Rewriter<C>
    extends AstVisitor<AstNode, C> {
        private final BiFunction<Expression, C, Expression> expressionRewriter;
        private final BiFunction<AstNode, Context<C>, Optional<AstNode>> plugin;
        private final BiFunction<AstNode, C, AstNode> rewriter;

        private Rewriter(BiFunction<Expression, C, Expression> expressionRewriter, BiFunction<AstNode, Context<C>, Optional<AstNode>> plugin) {
            this.expressionRewriter = Objects.requireNonNull(expressionRewriter, "expressionRewriter");
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            this.rewriter = (arg_0, arg_1) -> ((Rewriter)this).process(arg_0, arg_1);
        }

        private Rewriter(BiFunction<Expression, C, Expression> expressionRewriter, BiFunction<AstNode, Context<C>, Optional<AstNode>> plugin, BiFunction<AstNode, C, AstNode> rewriter) {
            this.expressionRewriter = Objects.requireNonNull(expressionRewriter, "expressionRewriter");
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            this.rewriter = Objects.requireNonNull(rewriter, "rewriter");
        }

        private Expression processExpression(Expression node, C context) {
            return this.expressionRewriter.apply(node, context);
        }

        protected AstNode visitNode(AstNode node, C context) {
            return node;
        }

        protected AstNode visitStatements(Statements node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            List rewrittenStatements = node.getStatements().stream().map(s -> (Statement)this.rewriter.apply((AstNode)s, context)).collect(Collectors.toList());
            return new Statements(node.getLocation(), rewrittenStatements);
        }

        protected AstNode visitQuery(Query node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Select select = (Select)this.rewriter.apply((AstNode)node.getSelect(), context);
            Relation from = (Relation)this.rewriter.apply((AstNode)node.getFrom(), context);
            Optional<WindowExpression> windowExpression = node.getWindow().map(exp -> (WindowExpression)this.rewriter.apply((AstNode)exp, context));
            Optional<Expression> where = node.getWhere().map(exp -> this.processExpression((Expression)exp, context));
            Optional<GroupBy> groupBy = node.getGroupBy().map(exp -> (GroupBy)this.rewriter.apply((AstNode)exp, context));
            Optional<PartitionBy> partitionBy = node.getPartitionBy().map(exp -> (PartitionBy)this.rewriter.apply((AstNode)exp, context));
            Optional<Expression> having = node.getHaving().map(exp -> this.processExpression((Expression)exp, context));
            return new Query(node.getLocation(), select, from, windowExpression, where, groupBy, partitionBy, having, node.getRefinement(), node.isPullQuery(), node.getLimit());
        }

        protected AstNode visitExplain(Explain node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            if (!node.getStatement().isPresent()) {
                return node;
            }
            Statement original = (Statement)node.getStatement().get();
            Statement rewritten = (Statement)this.rewriter.apply((AstNode)original, context);
            return new Explain(node.getLocation(), node.getQueryId(), Optional.of(rewritten));
        }

        protected AstNode visitSelect(Select node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            List rewrittenItems = node.getSelectItems().stream().map(selectItem -> (SelectItem)this.rewriter.apply((AstNode)selectItem, context)).collect(Collectors.toList());
            return new Select(node.getLocation(), rewrittenItems);
        }

        protected AstNode visitSingleColumn(SingleColumn node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            return node.copyWithExpression(this.processExpression(node.getExpression(), context));
        }

        protected AstNode visitAllColumns(AllColumns node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            return node;
        }

        protected AstNode visitStructAll(StructAll node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            return node;
        }

        protected AstNode visitTable(Table node, C context) {
            return node;
        }

        protected AstNode visitAliasedRelation(AliasedRelation node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Relation rewrittenRelation = (Relation)this.rewriter.apply((AstNode)node.getRelation(), context);
            return new AliasedRelation(node.getLocation(), rewrittenRelation, node.getAlias());
        }

        protected AstNode visitJoin(Join node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            Relation rewrittenLeft = (Relation)this.rewriter.apply((AstNode)node.getLeft(), context);
            return new Join(node.getLocation(), rewrittenLeft, (List)node.getRights().stream().map(right -> (AstNode)this.process((AstNode)right, context)).map(JoinedSource.class::cast).collect(ImmutableList.toImmutableList()));
        }

        protected AstNode visitJoinedSource(JoinedSource rightSource, C context) {
            Relation rewrittenRight = (Relation)this.rewriter.apply((AstNode)rightSource.getRelation(), context);
            Optional<WithinExpression> rewrittenWithin = rightSource.getWithinExpression().map(within -> (WithinExpression)this.rewriter.apply((AstNode)within, context));
            JoinCriteria rewrittenCriteria = rightSource.getCriteria();
            if (rightSource.getCriteria() instanceof JoinOn) {
                rewrittenCriteria = new JoinOn(this.processExpression(((JoinOn)rightSource.getCriteria()).getExpression(), context));
            }
            return new JoinedSource(rightSource.getLocation(), rewrittenRight, rightSource.getType(), rewrittenCriteria, rewrittenWithin);
        }

        protected AstNode visitWithinExpression(WithinExpression node, C context) {
            return node;
        }

        protected AstNode visitWindowExpression(WindowExpression node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            return new WindowExpression(node.getLocation(), node.getWindowName(), node.getKsqlWindowExpression());
        }

        protected AstNode visitTableElement(TableElement node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            return new TableElement(node.getLocation(), node.getName(), (Type)this.processExpression((Expression)node.getType(), context), node.getConstraints());
        }

        protected AstNode visitCreateStream(CreateStream node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            List rewrittenElements = node.getElements().stream().map(tableElement -> (TableElement)this.rewriter.apply((AstNode)tableElement, context)).collect(Collectors.toList());
            return node.copyWith(TableElements.of(rewrittenElements), node.getProperties());
        }

        protected AstNode visitCreateStreamAsSelect(CreateStreamAsSelect node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            return new CreateStreamAsSelect(node.getLocation(), node.getName(), (Query)this.rewriter.apply((AstNode)node.getQuery(), context), node.isNotExists(), node.isOrReplace(), node.getProperties());
        }

        protected AstNode visitCreateTable(CreateTable node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            List rewrittenElements = node.getElements().stream().map(tableElement -> (TableElement)this.rewriter.apply((AstNode)tableElement, context)).collect(Collectors.toList());
            return node.copyWith(TableElements.of(rewrittenElements), node.getProperties());
        }

        protected AstNode visitCreateTableAsSelect(CreateTableAsSelect node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            return new CreateTableAsSelect(node.getLocation(), node.getName(), (Query)this.rewriter.apply((AstNode)node.getQuery(), context), node.isNotExists(), node.isOrReplace(), node.getProperties());
        }

        protected AstNode visitInsertInto(InsertInto node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            return new InsertInto(node.getLocation(), node.getTarget(), (Query)this.rewriter.apply((AstNode)node.getQuery(), context), node.getProperties());
        }

        protected AstNode visitDropTable(DropTable node, C context) {
            return node;
        }

        protected AstNode visitPartitionBy(PartitionBy node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            List rewrittenPartitionBys = node.getExpressions().stream().map(exp -> this.processExpression((Expression)exp, context)).collect(Collectors.toList());
            return new PartitionBy(node.getLocation(), rewrittenPartitionBys);
        }

        protected AstNode visitGroupBy(GroupBy node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            List rewrittenGroupings = node.getGroupingExpressions().stream().map(exp -> this.processExpression((Expression)exp, context)).collect(Collectors.toList());
            return new GroupBy(node.getLocation(), rewrittenGroupings);
        }

        public AstNode visitRegisterType(RegisterType node, C context) {
            Optional<AstNode> result = this.plugin.apply((AstNode)node, new Context(context, this));
            if (result.isPresent()) {
                return result.get();
            }
            return new RegisterType(node.getLocation(), node.getName(), (Type)this.processExpression((Expression)node.getType(), context), node.getIfNotExists());
        }
    }

    public static final class Context<C> {
        private final C context;
        private final Rewriter<C> rewriter;

        private Context(C context, Rewriter<C> rewriter) {
            this.context = context;
            this.rewriter = Objects.requireNonNull(rewriter, "rewriter");
        }

        public C getContext() {
            return this.context;
        }

        public AstNode process(AstNode node) {
            return (AstNode)this.rewriter.process(node, this.context);
        }

        public Expression process(Expression expression) {
            return ((Rewriter)this.rewriter).processExpression(expression, this.context);
        }
    }
}

