/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution;

import io.confluent.ksql.execution.ExecutionPlan;
import io.confluent.ksql.execution.PhysicalToExecutionPlanTranslator;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.StreamSink;
import io.confluent.ksql.execution.streams.ExecutionStepFactory;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.tree.Sink;
import io.confluent.ksql.physicalplanner.PhysicalPlan;
import io.confluent.ksql.physicalplanner.nodes.Node;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import java.util.Optional;

public final class ExecutionPlanner {
    private ExecutionPlanner() {
    }

    public static ExecutionPlan buildPlan(MetaStore metaStore, PhysicalPlan physicalPlan, Sink sink) {
        SerdeFeatures valueFeatures;
        FormatInfo valueFormatInfo;
        SerdeFeatures keyFeatures;
        FormatInfo keyFormatInfo;
        PhysicalToExecutionPlanTranslator translator = new PhysicalToExecutionPlanTranslator(metaStore);
        Node<?> planRoot = physicalPlan.getRoot();
        ExecutionStep<?> root = translator.process(planRoot);
        CreateSourceAsProperties properties = sink.getProperties();
        Optional keyFormatName = properties.getKeyFormat();
        if (keyFormatName.isPresent()) {
            keyFormatInfo = FormatInfo.of((String)((String)keyFormatName.get()));
            keyFeatures = SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]);
        } else {
            Formats formats = planRoot.getFormats();
            keyFormatInfo = formats.getKeyFormat();
            keyFeatures = formats.getKeyFeatures();
        }
        Optional valueFormatName = properties.getValueFormat();
        if (valueFormatName.isPresent()) {
            valueFormatInfo = FormatInfo.of((String)((String)valueFormatName.get()));
            valueFeatures = SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]);
        } else {
            Formats formats = planRoot.getFormats();
            valueFormatInfo = formats.getValueFormat();
            valueFeatures = formats.getValueFeatures();
        }
        Formats outputFormat = Formats.of((FormatInfo)keyFormatInfo, (FormatInfo)valueFormatInfo, (SerdeFeatures)keyFeatures, (SerdeFeatures)valueFeatures);
        StreamSink streamSink = ExecutionStepFactory.streamSink((QueryContext.Stacker)new QueryContext.Stacker().push(new String[]{"OUTPUT"}), (Formats)outputFormat, root, (String)sink.getName().text(), Optional.empty());
        return new ExecutionPlan(new QueryId("query-id"), (ExecutionStep<?>)streamSink);
    }
}

