/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.common;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.Window;
import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.PushOffsetRange;
import java.util.Objects;
import java.util.Optional;

public class OffsetsRow
implements QueryRow {
    private static final LogicalSchema EMPTY_SCHEMA = LogicalSchema.builder().build();
    private final long rowTime;
    private final PushOffsetRange pushOffsetRange;

    public static OffsetsRow of(long rowTime, PushOffsetRange pushOffsetRange) {
        return new OffsetsRow(rowTime, pushOffsetRange);
    }

    OffsetsRow(long rowTime, PushOffsetRange pushOffsetRange) {
        this.rowTime = rowTime;
        this.pushOffsetRange = pushOffsetRange;
    }

    @Override
    public LogicalSchema schema() {
        return EMPTY_SCHEMA;
    }

    @Override
    public long rowTime() {
        return this.rowTime;
    }

    @Override
    public GenericKey key() {
        return GenericKey.genericKey((Object[])new Object[0]);
    }

    @Override
    public Optional<Window> window() {
        return Optional.empty();
    }

    @Override
    public GenericRow value() {
        return GenericRow.genericRow((Object[])new Object[0]);
    }

    @Override
    public Optional<PushOffsetRange> getOffsetRange() {
        return Optional.of(this.pushOffsetRange);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetsRow that = (OffsetsRow)o;
        return Objects.equals(this.pushOffsetRange, that.pushOffsetRange) && Objects.equals(this.rowTime, that.rowTime);
    }

    public int hashCode() {
        return Objects.hash(this.pushOffsetRange, this.rowTime);
    }

    public String toString() {
        return "OffsetsRow{pushOffsetRange=" + this.pushOffsetRange + ", rowTime=" + this.rowTime + '}';
    }
}

