/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.pull;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.ksql.execution.pull.PullPhysicalPlan;
import io.confluent.ksql.execution.pull.StandbyFallbackException;
import io.confluent.ksql.execution.streams.RoutingFilter;
import io.confluent.ksql.execution.streams.RoutingOptions;
import io.confluent.ksql.execution.streams.materialization.Locator;
import io.confluent.ksql.execution.streams.materialization.MaterializationException;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.query.PullQueryWriteStream;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.vertx.core.streams.WriteStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HARouting
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HARouting.class);
    private final ExecutorService coordinatorExecutorService;
    private final ExecutorService routerExecutorService;
    private final RoutingFilter.RoutingFilterFactory routingFilterFactory;
    private final Optional<PullQueryExecutorMetrics> pullQueryMetrics;
    private final KsqlConfig ksqlConfig;
    private final int coordinatorPoolSize;
    private final int routerPoolSize;

    public HARouting(RoutingFilter.RoutingFilterFactory routingFilterFactory, Optional<PullQueryExecutorMetrics> pullQueryMetrics, KsqlConfig ksqlConfig) {
        this.routingFilterFactory = Objects.requireNonNull(routingFilterFactory, "routingFilterFactory");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.coordinatorPoolSize = ksqlConfig.getInt("ksql.query.pull.thread.pool.size");
        this.routerPoolSize = ksqlConfig.getInt("ksql.query.pull.router.thread.pool.size");
        this.coordinatorExecutorService = Executors.newFixedThreadPool(this.coordinatorPoolSize, new ThreadFactoryBuilder().setNameFormat("pull-query-coordinator-%d").build());
        this.routerExecutorService = Executors.newFixedThreadPool(this.routerPoolSize, new ThreadFactoryBuilder().setNameFormat("pull-query-router-%d").build());
        this.pullQueryMetrics = Objects.requireNonNull(pullQueryMetrics, "pullQueryMetrics");
        this.pullQueryMetrics.ifPresent(pm -> pm.registerCoordinatorThreadPoolSupplier(() -> this.coordinatorPoolSize - ((ThreadPoolExecutor)this.coordinatorExecutorService).getActiveCount()));
        this.pullQueryMetrics.ifPresent(pm -> pm.registerRouterThreadPoolSupplier(() -> this.routerPoolSize - ((ThreadPoolExecutor)this.routerExecutorService).getActiveCount()));
    }

    @Override
    public void close() {
        this.coordinatorExecutorService.shutdown();
        this.routerExecutorService.shutdown();
    }

    public CompletableFuture<Void> handlePullQuery(ServiceContext serviceContext, PullPhysicalPlan pullPhysicalPlan, ConfiguredStatement<Query> statement, RoutingOptions routingOptions, PullQueryWriteStream pullQueryQueue, CompletableFuture<Void> shouldCancelRequests) {
        List allLocations = pullPhysicalPlan.getMaterialization().locator().locate(pullPhysicalPlan.getKeys(), routingOptions, this.routingFilterFactory, pullPhysicalPlan.getPlanType() == PullPhysicalPlan.PullPhysicalPlanType.RANGE_SCAN);
        Map<Integer, List> emptyPartitions = allLocations.stream().filter(loc -> loc.getNodes().stream().noneMatch(node -> node.getHost().isSelected())).collect(Collectors.toMap(Locator.KsqlPartitionLocation::getPartition, loc -> loc.getNodes().stream().map(Locator.KsqlNode::getHost).collect(Collectors.toList())));
        if (!emptyPartitions.isEmpty()) {
            MaterializationException materializationException = new MaterializationException("Unable to execute pull query. " + emptyPartitions.entrySet().stream().map(kv -> String.format("Partition %s failed to find valid host. Hosts scanned: %s", kv.getKey(), kv.getValue())).collect(Collectors.joining(", ", "[", "]")));
            LOG.debug(materializationException.getMessage());
            throw materializationException;
        }
        List locations = allLocations.stream().map(Locator.KsqlPartitionLocation::removeFilteredHosts).collect(Collectors.toList());
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.coordinatorExecutorService.submit(() -> {
            try {
                this.executeRounds(serviceContext, pullPhysicalPlan, statement, routingOptions, locations, pullQueryQueue, shouldCancelRequests);
                completableFuture.complete(null);
            }
            catch (Throwable t) {
                completableFuture.completeExceptionally(t);
            }
        });
        return completableFuture;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeRounds(ServiceContext serviceContext, PullPhysicalPlan pullPhysicalPlan, ConfiguredStatement<Query> statement, RoutingOptions routingOptions, List<Locator.KsqlPartitionLocation> locations, PullQueryWriteStream pullQueryQueue, CompletableFuture<Void> shouldCancelRequests) {
        ImmutableList remainingLocations = ImmutableList.copyOf(locations);
        HashMap<Locator.KsqlNode, List> exceptionsPerNode = new HashMap<Locator.KsqlNode, List>();
        try {
            int round = 0;
            while (true) {
                Map<Locator.KsqlNode, List<Locator.KsqlPartitionLocation>> groupedByHost = HARouting.groupByHost(statement, (List<Locator.KsqlPartitionLocation>)remainingLocations, round);
                LinkedHashMap<Locator.KsqlNode, Future<NodeFetchResult>> futures = new LinkedHashMap<Locator.KsqlNode, Future<NodeFetchResult>>();
                for (Map.Entry<Locator.KsqlNode, List<Locator.KsqlPartitionLocation>> entry : groupedByHost.entrySet()) {
                    Locator.KsqlNode node = entry.getKey();
                    futures.put(node, this.routerExecutorService.submit(() -> HARouting.executeOrRouteQuery(node, (List)entry.getValue(), statement, serviceContext, routingOptions, this.pullQueryMetrics, pullPhysicalPlan, pullQueryQueue, shouldCancelRequests)));
                }
                ImmutableList.Builder nextRoundRemaining = ImmutableList.builder();
                for (Map.Entry entry : futures.entrySet()) {
                    Future future = (Future)entry.getValue();
                    Locator.KsqlNode node = (Locator.KsqlNode)entry.getKey();
                    NodeFetchResult routingResult = (NodeFetchResult)future.get();
                    if (routingResult.isError()) {
                        nextRoundRemaining.addAll((Iterable)groupedByHost.get(node));
                        exceptionsPerNode.computeIfAbsent(routingResult.node, v -> new ArrayList()).add(routingResult.exception.get());
                        continue;
                    }
                    Preconditions.checkState((routingResult.getResult() == RoutingResult.SUCCESS ? 1 : 0) != 0);
                }
                remainingLocations = nextRoundRemaining.build();
                if (remainingLocations.size() == 0) {
                    pullQueryQueue.close();
                    return;
                }
                ++round;
                continue;
                break;
            }
        }
        catch (Exception e) {
            MaterializationException exception = new MaterializationException("Unable to execute pull query: " + e.getMessage());
            Iterator iterator = exceptionsPerNode.entrySet().iterator();
            block9: while (true) {
                if (!iterator.hasNext()) throw exception;
                Map.Entry entry = iterator.next();
                Iterator iterator2 = ((List)entry.getValue()).iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block9;
                    Exception excp = (Exception)((Object)iterator2.next());
                    exception.addSuppressed((Throwable)excp);
                }
                break;
            }
        }
        finally {
            pullQueryQueue.close();
        }
    }

    private static Map<Locator.KsqlNode, List<Locator.KsqlPartitionLocation>> groupByHost(ConfiguredStatement<Query> statement, List<Locator.KsqlPartitionLocation> locations, int round) {
        LinkedHashMap<Locator.KsqlNode, List<Locator.KsqlPartitionLocation>> groupedByHost = new LinkedHashMap<Locator.KsqlNode, List<Locator.KsqlPartitionLocation>>();
        for (Locator.KsqlPartitionLocation location : locations) {
            if (round >= location.getNodes().size()) {
                throw new MaterializationException("Exhausted standby hosts to try.");
            }
            Locator.KsqlNode nextHost = (Locator.KsqlNode)location.getNodes().get(round);
            groupedByHost.computeIfAbsent(nextHost, h -> new ArrayList()).add(location);
        }
        return groupedByHost;
    }

    @VisibleForTesting
    static NodeFetchResult executeOrRouteQuery(Locator.KsqlNode node, List<Locator.KsqlPartitionLocation> locations, ConfiguredStatement<Query> statement, ServiceContext serviceContext, RoutingOptions routingOptions, Optional<PullQueryExecutorMetrics> pullQueryMetrics, PullPhysicalPlan pullPhysicalPlan, PullQueryWriteStream pullQueryQueue, CompletableFuture<Void> shouldCancelRequests) {
        Function<StreamedRow, StreamedRow> addHostInfo = sr -> sr.withSourceHost(routingOptions.getIsDebugRequest() ? HARouting.toKsqlHostInfo(node) : null);
        if (node.isLocal()) {
            try {
                LOG.debug("Query {} partitions {} executed locally at host {} at timestamp {}.", new Object[]{pullPhysicalPlan.getQueryId(), locations, node.location(), System.currentTimeMillis()});
                pullQueryMetrics.ifPresent(queryExecutorMetrics -> queryExecutorMetrics.recordLocalRequests(1.0));
                pullPhysicalPlan.execute(locations, pullQueryQueue, addHostInfo);
                return new NodeFetchResult(RoutingResult.SUCCESS, node, Optional.empty());
            }
            catch (StandbyFallbackException e) {
                LOG.warn("Error executing query locally at node {}. Falling back to standby state which may return stale results. Cause {}", (Object)node, (Object)e.getMessage());
                return new NodeFetchResult(RoutingResult.STANDBY_FALLBACK, node, Optional.of(e));
            }
            catch (Exception e) {
                throw new KsqlException(String.format("Error executing query locally at node %s: %s", node.location(), e.getMessage()), (Throwable)e);
            }
        }
        try {
            if (routingOptions.getIsSkipForwardRequest()) {
                throw new MaterializationException("Unable to execute pull query: the request has already been forwarded and failed. Cannot forward again.");
            }
            LOG.debug("Query {} partitions {} routed to host {} at timestamp {}.", new Object[]{pullPhysicalPlan.getQueryId(), locations, node.location(), System.currentTimeMillis()});
            pullQueryMetrics.ifPresent(queryExecutorMetrics -> queryExecutorMetrics.recordRemoteRequests(1.0));
            HARouting.forwardTo(node, locations, statement, serviceContext, pullQueryQueue, shouldCancelRequests, addHostInfo);
            return new NodeFetchResult(RoutingResult.SUCCESS, node, Optional.empty());
        }
        catch (StandbyFallbackException e) {
            LOG.warn("Error forwarding query to node {}. Falling back to standby state which may return stale results", (Object)node.location(), (Object)e.getCause());
            return new NodeFetchResult(RoutingResult.STANDBY_FALLBACK, node, Optional.of(e));
        }
        catch (Exception e) {
            throw new KsqlException(String.format("Error forwarding query to node %s: %s", node.location(), e.getMessage()), (Throwable)e);
        }
    }

    private static KsqlHostInfoEntity toKsqlHostInfo(Locator.KsqlNode node) {
        return new KsqlHostInfoEntity(node.location().getHost(), node.location().getPort());
    }

    private static void forwardTo(Locator.KsqlNode owner, List<Locator.KsqlPartitionLocation> locations, ConfiguredStatement<Query> statement, ServiceContext serviceContext, PullQueryWriteStream pullQueryQueue, CompletableFuture<Void> shouldCancelRequests, Function<StreamedRow, StreamedRow> addHostInfo) {
        RestResponse response;
        String partitions = locations.stream().map(location -> Integer.toString(location.getPartition())).collect(Collectors.joining(","));
        ImmutableMap.Builder builder = new ImmutableMap.Builder().put((Object)"request.ksql.query.pull.skip.forwarding", (Object)true).put((Object)"request.ksql.internal.request", (Object)true).put((Object)"request.ksql.query.pull.partition", (Object)partitions);
        ImmutableMap requestProperties = builder.build();
        try {
            response = serviceContext.getKsqlClient().makeQueryRequest(owner.location(), statement.getUnMaskedStatementText(), statement.getSessionConfig().getOverrides(), (Map)requestProperties, (WriteStream)pullQueryQueue, shouldCancelRequests, addHostInfo);
        }
        catch (Exception e) {
            if (shouldCancelRequests.isDone()) {
                LOG.warn("Connection canceled, so returning");
                return;
            }
            KsqlException ksqlException = HARouting.causedByKsqlException(e);
            String exceptionMessage = ksqlException == null ? e.getMessage() : ksqlException.getMessage();
            throw new StandbyFallbackException(String.format("Forwarding pull query request failed with error %s ", exceptionMessage), e);
        }
        if (response.isErroneous()) {
            throw new KsqlException(String.format("Forwarding pull query request [%s, %s] failed with error %s ", statement.getSessionConfig().getOverrides(), requestProperties, response.getErrorMessage()));
        }
        int numRows = (Integer)response.getResponse();
        if (numRows == 0) {
            throw new KsqlException(String.format("Forwarding pull query request [%s, %s] failed due to invalid empty response from forwarding call, expected a header row.", statement.getSessionConfig().getOverrides(), requestProperties));
        }
    }

    private static KsqlException causedByKsqlException(Exception e) {
        for (Throwable throwable = e; throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof KsqlException)) continue;
            return (KsqlException)throwable;
        }
        return null;
    }

    private static class NodeFetchResult {
        private final RoutingResult routingResult;
        private final Locator.KsqlNode node;
        private final Optional<Exception> exception;

        NodeFetchResult(RoutingResult routingResult, Locator.KsqlNode node, Optional<Exception> exception) {
            this.routingResult = routingResult;
            this.node = node;
            this.exception = exception;
        }

        public boolean isError() {
            return this.routingResult == RoutingResult.STANDBY_FALLBACK;
        }

        public RoutingResult getResult() {
            return this.routingResult;
        }

        public Locator.KsqlNode getNode() {
            return this.node;
        }

        public Optional<Exception> getException() {
            return this.exception;
        }
    }

    private static enum RoutingResult {
        SUCCESS,
        STANDBY_FALLBACK;

    }
}

