/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.pull;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.pull.PullQueryRow;
import io.confluent.ksql.rest.entity.ConsistencyToken;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class StreamedRowTranslator
implements Function<List<StreamedRow>, List<PullQueryRow>> {
    private final LogicalSchema expectedSchema;
    private final Optional<ConsistencyOffsetVector> offsetVector;

    public StreamedRowTranslator(LogicalSchema expectedSchema, Optional<ConsistencyOffsetVector> offsetVector) {
        this.expectedSchema = expectedSchema;
        this.offsetVector = offsetVector;
    }

    @Override
    public List<PullQueryRow> apply(List<StreamedRow> rows) {
        if (rows == null || rows.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<PullQueryRow> result = new ArrayList<PullQueryRow>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            StreamedRow row = rows.get(i);
            if (row.getHeader().isPresent()) {
                this.handleHeader(row);
                continue;
            }
            if (row.getErrorMessage().isPresent()) {
                throw new KsqlException(((KsqlErrorMessage)row.getErrorMessage().get()).getMessage());
            }
            if (!row.getRow().isPresent()) {
                StreamedRowTranslator.handleNonDataRows(row, i, this.offsetVector);
                continue;
            }
            List columns = ((StreamedRow.DataRow)row.getRow().get()).getColumns();
            result.add(new PullQueryRow(columns, this.expectedSchema, row.getSourceHost(), Optional.empty()));
        }
        return result;
    }

    private void handleHeader(StreamedRow row) {
        Optional header = row.getHeader();
        header.ifPresent(value -> this.validateSchema(this.expectedSchema, value.getSchema(), row.getSourceHost()));
    }

    private static void handleNonDataRows(StreamedRow row, int i, Optional<ConsistencyOffsetVector> offsetVector) {
        if (row.getConsistencyToken().isPresent()) {
            if (offsetVector.isPresent()) {
                String token = ((ConsistencyToken)row.getConsistencyToken().get()).getConsistencyToken();
                ConsistencyOffsetVector received = ConsistencyOffsetVector.deserialize((String)token);
                offsetVector.get().merge(received);
            }
        } else if (!row.getFinalMessage().isPresent()) {
            throw new KsqlException("Missing row data on row " + i + " of chunk");
        }
    }

    private void validateSchema(LogicalSchema expected, LogicalSchema actual, Optional<KsqlHostInfoEntity> sourceHost) {
        if (!actual.equals((Object)expected)) {
            throw new KsqlException(String.format("Schemas %s from host %s differs from schema %s", actual, sourceHost.map(KsqlHostInfoEntity::getHost).orElse("unknown"), expected));
        }
    }
}

