/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush;

import com.google.common.base.Preconditions;
import io.confluent.ksql.execution.common.QueryRow;
import io.confluent.ksql.execution.scalablepush.PushPhysicalPlan;
import io.confluent.ksql.execution.scalablepush.PushPhysicalPlanCreator;
import io.confluent.ksql.execution.scalablepush.ScalablePushRegistry;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.reactive.BufferedPublisher;
import io.confluent.ksql.util.PushOffsetRange;
import io.vertx.core.Context;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class PushPhysicalPlanManager {
    private final PushPhysicalPlanCreator pushPhysicalPlanCreator;
    private final AtomicReference<PushPhysicalPlan> pushPhysicalPlan = new AtomicReference();

    public PushPhysicalPlanManager(PushPhysicalPlanCreator pushPhysicalPlanCreator, Optional<String> catchupConsumerGroup, Optional<PushOffsetRange> initialOffsetRange) {
        this.pushPhysicalPlanCreator = pushPhysicalPlanCreator;
        this.pushPhysicalPlan.set(pushPhysicalPlanCreator.create(initialOffsetRange, catchupConsumerGroup));
    }

    public QueryId getQueryId() {
        return this.pushPhysicalPlan.get().getQueryId();
    }

    public PushPhysicalPlan getPhysicalPlan() {
        return this.pushPhysicalPlan.get();
    }

    public void reset(Optional<PushOffsetRange> newOffsetRange) {
        Preconditions.checkState((boolean)this.isClosed(), (Object)"Must be closed in order to reset");
        PushPhysicalPlan newPlan = this.pushPhysicalPlanCreator.create(newOffsetRange, Optional.of(this.pushPhysicalPlan.get().getCatchupConsumerGroupId()));
        this.pushPhysicalPlan.set(newPlan);
    }

    public boolean isClosed() {
        return this.pushPhysicalPlan.get().isClosed();
    }

    public ScalablePushRegistry getScalablePushRegistry() {
        return this.pushPhysicalPlan.get().getScalablePushRegistry();
    }

    public String getCatchupConsumerGroupId() {
        return this.pushPhysicalPlan.get().getCatchupConsumerGroupId();
    }

    public BufferedPublisher<QueryRow> execute() {
        return this.pushPhysicalPlan.get().execute();
    }

    public Runnable closeable() {
        PushPhysicalPlan plan = this.pushPhysicalPlan.get();
        return plan::close;
    }

    public Context getContext() {
        return this.pushPhysicalPlan.get().getContext();
    }
}

