/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.scalablepush.consumer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.scalablepush.ProcessingQueue;
import io.confluent.ksql.execution.scalablepush.consumer.CatchupCoordinator;
import io.confluent.ksql.execution.scalablepush.consumer.LatestConsumer;
import io.confluent.ksql.execution.scalablepush.consumer.ScalablePushConsumer;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.PushOffsetRange;
import java.time.Clock;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchupConsumer
extends ScalablePushConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CatchupConsumer.class);
    @VisibleForTesting
    static final long WAIT_FOR_ASSIGNMENT_MS = 15000L;
    @VisibleForTesting
    protected final Supplier<LatestConsumer> latestConsumerSupplier;
    private final CatchupCoordinator catchupCoordinator;
    private final PushOffsetRange offsetRange;
    private final Consumer<Long> sleepMs;
    private final BiConsumer<Object, Long> waitMs;
    private final long catchupWindow;
    private final AtomicBoolean signalledLatest = new AtomicBoolean(false);
    @VisibleForTesting
    protected final Consumer<ProcessingQueue> caughtUpCallback;

    public CatchupConsumer(String topicName, boolean windowed, LogicalSchema logicalSchema, KafkaConsumer<Object, GenericRow> consumer, Supplier<LatestConsumer> latestConsumerSupplier, CatchupCoordinator catchupCoordinator, PushOffsetRange offsetRange, Clock clock, Consumer<Long> sleepMs, BiConsumer<Object, Long> waitMs, long catchupWindow, Consumer<ProcessingQueue> caughtUpCallback) {
        super(topicName, windowed, logicalSchema, consumer, clock);
        this.latestConsumerSupplier = latestConsumerSupplier;
        this.catchupCoordinator = catchupCoordinator;
        this.offsetRange = offsetRange;
        this.sleepMs = sleepMs;
        this.waitMs = waitMs;
        this.catchupWindow = catchupWindow;
        this.caughtUpCallback = caughtUpCallback;
    }

    public CatchupConsumer(String topicName, boolean windowed, LogicalSchema logicalSchema, KafkaConsumer<Object, GenericRow> consumer, Supplier<LatestConsumer> latestConsumerSupplier, CatchupCoordinator catchupCoordinator, PushOffsetRange offsetRange, Clock clock, long catchupWindow, Consumer<ProcessingQueue> caughtUpCallback) {
        this(topicName, windowed, logicalSchema, consumer, latestConsumerSupplier, catchupCoordinator, offsetRange, clock, CatchupConsumer::sleep, CatchupConsumer::wait, catchupWindow, caughtUpCallback);
    }

    @Override
    protected void onEmptyRecords() {
        this.checkCaughtUp();
    }

    @Override
    protected void afterBatchProcessed() {
        this.checkCaughtUp();
    }

    protected void onNewAssignment(Optional<Map<Integer, Long>> startingOffsets) {
        Set<TopicPartition> tps = this.waitForNewAssignmentFromLatestConsumer();
        this.consumer.assign(tps);
        this.updateCurrentPositions(startingOffsets);
        this.newAssignment = false;
    }

    @Override
    protected void onNewAssignment() {
        this.onNewAssignment(Optional.empty());
    }

    protected synchronized Set<TopicPartition> waitForNewAssignmentFromLatestConsumer() {
        long startMs = this.clock.millis();
        Set tps = (Set)this.topicPartitions.get();
        while (tps == null) {
            long timeMs = this.clock.millis();
            long elapsedMs = timeMs - startMs;
            if (elapsedMs >= 15000L) {
                throw new KsqlException("Timed out waiting for assignment from Latest");
            }
            this.waitMs.accept(this, 15000L - elapsedMs);
            tps = (Set)this.topicPartitions.get();
        }
        return tps;
    }

    @Override
    protected void subscribeOrAssign() {
        LatestConsumer latestConsumer = this.latestConsumerSupplier.get();
        Preconditions.checkNotNull((Object)latestConsumer, (Object)"Latest should always be started before catchup is run");
        this.newAssignment(latestConsumer.getAssignment());
        Map startingOffsets = this.offsetRange.getEndOffsets().getSparseRepresentation();
        this.onNewAssignment(Optional.of(startingOffsets));
        for (TopicPartition tp : this.consumer.assignment()) {
            if (!startingOffsets.containsKey(tp.partition()) || (Long)startingOffsets.get(tp.partition()) < 0L) continue;
            this.consumer.seek(tp, ((Long)startingOffsets.get(tp.partition())).longValue());
        }
    }

    @Override
    protected void afterOfferedRow(ProcessingQueue processingQueue) {
        while (processingQueue.isAtLimit()) {
            LOG.info("Sleeping for a bit since queue is full queryid {}", (Object)processingQueue.getQueryId());
            this.sleepMs.accept(50L);
        }
    }

    @VisibleForTesting
    protected void checkCaughtUp() {
        LOG.info("Checking to see if we're caught up");
        Function<Boolean, Boolean> isCaughtUp = softCaughtUp -> {
            LatestConsumer lc = this.latestConsumerSupplier.get();
            if (lc == null) {
                return false;
            }
            Map<TopicPartition, Long> latestOffsets = lc.getCurrentOffsets();
            if (latestOffsets.isEmpty()) {
                return false;
            }
            return CatchupConsumer.caughtUp(latestOffsets, (Map)this.currentPositions.get(), softCaughtUp, this.catchupWindow);
        };
        Runnable switchOver = () -> {
            LatestConsumer lc = this.latestConsumerSupplier.get();
            if (lc == null) {
                LOG.warn("Couldn't switch over to latest yet because it's not running");
                return;
            }
            for (ProcessingQueue processingQueue : this.processingQueues.values()) {
                LOG.info("Switching over from catchup queryid {} to latest", (Object)processingQueue.getQueryId());
                lc.register(processingQueue);
                this.caughtUpCallback.accept(processingQueue);
            }
            this.processingQueues.clear();
            this.close();
        };
        this.catchupCoordinator.checkShouldCatchUp(this.signalledLatest, isCaughtUp, switchOver);
    }

    @Override
    public void close() {
        super.close();
        this.catchupCoordinator.catchupIsClosing(this.signalledLatest);
    }

    private static boolean caughtUp(Map<TopicPartition, Long> latestOffsets, Map<TopicPartition, Long> offsets, boolean softCatchUp, long catchupWindow) {
        if (!latestOffsets.keySet().equals(offsets.keySet())) {
            return false;
        }
        for (Map.Entry<TopicPartition, Long> entry : latestOffsets.entrySet()) {
            TopicPartition tp = entry.getKey();
            Long latestOffset = entry.getValue();
            Long offset = offsets.get(tp);
            if (latestOffset == null || offset == null) {
                return false;
            }
            if (!(softCatchUp ? offset < latestOffset && latestOffset - offset > catchupWindow : offset < latestOffset)) continue;
            return false;
        }
        return true;
    }

    private static void sleep(long waitMs) {
        try {
            Thread.sleep(waitMs);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while sleeping", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static void wait(Object object, long waitMs) {
        try {
            object.wait(waitMs);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while sleeping", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new KsqlException("Interrupted while waiting for assignment");
        }
    }

    public static interface CatchupConsumerFactory {
        public CatchupConsumer create(String var1, boolean var2, LogicalSchema var3, KafkaConsumer<Object, GenericRow> var4, Supplier<LatestConsumer> var5, CatchupCoordinator var6, PushOffsetRange var7, Clock var8, long var9, Consumer<ProcessingQueue> var11);
    }
}

