/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.function.ParameterInfo;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.udaf.VariadicArgs;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.security.ExtensionSecurityManager;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import io.confluent.ksql.util.Quadruple;
import io.confluent.ksql.util.Quintuple;
import io.confluent.ksql.util.Triple;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;

public abstract class BaseAggregateFunction<I, A, O>
implements KsqlAggregateFunction<I, A, O> {
    private final ImmutableList<Integer> argIndicesInValue;
    private final Supplier<A> initialValueSupplier;
    private final SqlType aggregateSchema;
    private final SqlType outputSchema;
    private final ImmutableList<ParameterInfo> params;
    private final ImmutableList<ParamType> paramTypes;
    private final Function<List<Object>, Object> inputConverter;
    protected final String functionName;
    private final String description;
    private final int numColArgs;
    private final boolean isVariadic;

    public BaseAggregateFunction(String functionName, List<Integer> argIndicesInValue, Supplier<A> initialValueSupplier, SqlType aggregateType, SqlType outputType, List<ParameterInfo> parameters, String description, int numColArgs) {
        this.argIndicesInValue = ImmutableList.copyOf((Collection)Objects.requireNonNull(argIndicesInValue, "argIndicesInValue"));
        this.initialValueSupplier = () -> {
            ExtensionSecurityManager.INSTANCE.pushInUdf();
            try {
                Object val = initialValueSupplier.get();
                if (val instanceof Struct && !((Struct)val).schema().isOptional()) {
                    throw new KsqlException("Initialize function for " + functionName + " must return struct with optional schema");
                }
                Object t = val;
                return t;
            }
            finally {
                ExtensionSecurityManager.INSTANCE.popOutUdf();
            }
        };
        this.aggregateSchema = Objects.requireNonNull(aggregateType, "aggregateType");
        this.outputSchema = Objects.requireNonNull(outputType, "outputType");
        this.params = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters"));
        this.paramTypes = ImmutableList.copyOf((Collection)parameters.stream().map(ParameterInfo::type).collect(Collectors.toList()));
        this.numColArgs = numColArgs;
        this.isVariadic = parameters.stream().anyMatch(ParameterInfo::isVariadic);
        this.inputConverter = this.determineInputConverter();
        this.functionName = Objects.requireNonNull(functionName, "functionName");
        this.description = Objects.requireNonNull(description, "description");
    }

    public FunctionName name() {
        return FunctionName.of((String)this.functionName);
    }

    public Supplier<A> getInitialValueSupplier() {
        return this.initialValueSupplier;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="argIndicesInValue is ImmutableList")
    public List<Integer> getArgIndicesInValue() {
        return this.argIndicesInValue;
    }

    public SqlType getAggregateType() {
        return this.aggregateSchema;
    }

    public SqlType returnType() {
        return this.outputSchema;
    }

    public ParamType declaredReturnType() {
        return SchemaConverters.sqlToFunctionConverter().toFunctionType(this.outputSchema);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="paramTypes is ImmutableList")
    public List<ParamType> parameters() {
        return this.paramTypes;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="params is ImmutableList")
    public List<ParameterInfo> parameterInfo() {
        return this.params;
    }

    public boolean isVariadic() {
        return this.isVariadic;
    }

    public Object convertToInput(List<Object> arguments) {
        return this.inputConverter.apply(arguments);
    }

    public String getDescription() {
        return this.description;
    }

    private Function<List<Object>, Object> determineInputConverter() {
        int lastColArgIndex = this.numColArgs - 1;
        boolean isColArgVariadic = ((ParameterInfo)this.params.get(lastColArgIndex)).isVariadic();
        Function<List<Object>, Object> getLastObject = isColArgVariadic ? items -> new VariadicArgs(items.subList(lastColArgIndex, items.size())) : items -> items.get(lastColArgIndex);
        switch (this.numColArgs) {
            case 1: {
                return getLastObject;
            }
            case 2: {
                return objects -> Pair.of(objects.get(0), getLastObject.apply((List<Object>)objects));
            }
            case 3: {
                return objects -> Triple.of(objects.get(0), objects.get(1), getLastObject.apply((List<Object>)objects));
            }
            case 4: {
                return objects -> Quadruple.of(objects.get(0), objects.get(1), objects.get(2), getLastObject.apply((List<Object>)objects));
            }
            case 5: {
                return objects -> Quintuple.of(objects.get(0), objects.get(1), objects.get(2), objects.get(3), getLastObject.apply((List<Object>)objects));
            }
        }
        throw new KsqlException("Unsupported number of aggregation function parameters: " + this.numColArgs);
    }
}

