/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.array;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.ArrayList;
import java.util.List;

@UdfDescription(name="GENERATE_SERIES", category="ARRAY", description="Construct an array of a range of values", author="Confluent")
public class GenerateSeries {
    @Udf
    public List<Integer> generateSeriesInt(@UdfParameter(description="The beginning of the series") int start, @UdfParameter(description="Marks the end of the series (inclusive)") int end) {
        return this.generateSeriesInt(start, end, end - start > 0 ? 1 : -1);
    }

    @Udf
    public List<Integer> generateSeriesInt(@UdfParameter(description="The beginning of the series") int start, @UdfParameter(description="Marks the end of the series (inclusive)") int end, @UdfParameter(description="Difference between each value in the series") int step) {
        this.checkStep(step);
        int diff = end - start;
        if (diff > 0 && step < 0 || diff < 0 && step > 0) {
            throw new KsqlFunctionException("GENERATE_SERIES step has wrong sign");
        }
        int size = 1 + diff / step;
        ArrayList<Integer> result = new ArrayList<Integer>(size);
        int pos = 0;
        int val = start;
        while (pos++ < size) {
            result.add(val);
            val += step;
        }
        return result;
    }

    @Udf
    public List<Long> generateSeriesLong(@UdfParameter(description="The beginning of the series") long start, @UdfParameter(description="Marks the end of the series (inclusive)") long end) {
        return this.generateSeriesLong(start, end, end - start > 0L ? 1 : -1);
    }

    @Udf
    public List<Long> generateSeriesLong(@UdfParameter(description="The beginning of the series") long start, @UdfParameter(description="Marks the end of the series (inclusive)") long end, @UdfParameter(description="Difference between each value in the series") int step) {
        this.checkStep(step);
        long diff = end - start;
        if (diff > 0L && step < 0 || diff < 0L && step > 0) {
            throw new KsqlFunctionException("GENERATE_SERIES step has wrong sign");
        }
        int size = 1 + (int)(diff / (long)step);
        ArrayList<Long> result = new ArrayList<Long>(size);
        int pos = 0;
        long val = start;
        while (pos++ < size) {
            result.add(val);
            val += (long)step;
        }
        return result;
    }

    private void checkStep(int step) {
        if (step == 0) {
            throw new KsqlFunctionException("GENERATE_SERIES step cannot be zero");
        }
    }
}

