/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.TimeZone;

@UdfDescription(name="convert_tz", category="DATE / TIME", author="Confluent", description="Converts a TIMESTAMP value from one timezone to another.")
public class ConvertTz {
    @Udf(description="Converts a TIMESTAMP value from one timezone to another")
    public Timestamp convertTz(@UdfParameter(description="The TIMESTAMP value.") Timestamp timestamp, @UdfParameter(description="The fromTimeZone in java.util.TimeZone ID format. For example: \"UTC\", \"America/Los_Angeles\", \"PST\", \"Europe/London\"") String fromTimeZone, @UdfParameter(description="The toTimeZone in java.util.TimeZone ID format. For example: \"UTC\", \"America/Los_Angeles\", \"PST\", \"Europe/London\"") String toTimeZone) {
        if (timestamp == null || fromTimeZone == null || toTimeZone == null) {
            return null;
        }
        try {
            long offset = TimeZone.getTimeZone(ZoneId.of(toTimeZone)).getOffset(timestamp.getTime()) - TimeZone.getTimeZone(ZoneId.of(fromTimeZone)).getOffset(timestamp.getTime());
            return new Timestamp(timestamp.getTime() + offset);
        }
        catch (DateTimeException e) {
            throw new KsqlFunctionException("Invalid time zone: " + e.getMessage());
        }
    }
}

