/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.datetime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@UdfDescription(name="format_date", category="DATE / TIME", author="Confluent", description="Converts a DATE value to a string using the given format pattern. The format pattern should be in the format expected by java.time.format.DateTimeFormatter.")
public class FormatDate {
    private final LoadingCache<String, DateTimeFormatter> formatters = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(DateTimeFormatter::ofPattern));

    @Udf(description="Converts the number of days since 1970-01-01 00:00:00 UTC/GMT to a date string using the given format pattern. The format pattern should be in the format expected by java.time.format.DateTimeFormatter")
    public String formatDate(@UdfParameter(description="The date to convert") Date date, @UdfParameter(description="The format pattern should be in the format expected by java.time.format.DateTimeFormatter.") String formatPattern) {
        if (date == null || formatPattern == null) {
            return null;
        }
        try {
            DateTimeFormatter formatter = (DateTimeFormatter)this.formatters.get((Object)formatPattern);
            return LocalDate.ofEpochDay(TimeUnit.MILLISECONDS.toDays(date.getTime())).format(formatter);
        }
        catch (RuntimeException | ExecutionException e) {
            throw new KsqlFunctionException("Failed to format date " + date + " with formatter '" + formatPattern + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

