/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.json.UdfJsonMapper;

@UdfDescription(name="IS_JSON_STRING", category="JSON", description="Given a string, returns true if it can be parsed as a valid JSON value, false otherwise.", author="Confluent")
public class IsJsonString {
    @Udf
    public boolean check(@UdfParameter(description="The input JSON string") String input) {
        if (input == null) {
            return false;
        }
        try {
            return !UdfJsonMapper.parseJson(input).isMissingNode();
        }
        catch (KsqlFunctionException e) {
            return false;
        }
    }
}

