/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.json;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.json.UdfJsonMapper;
import java.util.ArrayList;
import java.util.List;

@UdfDescription(name="JSON_KEYS", category="JSON", description="Given a string, parses it as a JSON object and returns a ksqlDB array of strings representing the top-level keys. Returns NULL if the string can't be interpreted as a JSON object, for example, when the string is NULL or it does not contain valid JSON, or the JSON value is not an object.", author="Confluent")
public class JsonKeys {
    @Udf
    public List<String> keys(@UdfParameter String jsonObj) {
        if (jsonObj == null) {
            return null;
        }
        JsonNode node = UdfJsonMapper.parseJson(jsonObj);
        if (node.isMissingNode() || !node.isObject()) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        node.fieldNames().forEachRemaining(ret::add);
        return ret;
    }
}

