/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;

@UdfDescription(name="radians", category="MATHEMATICAL", author="Confluent", description="Converts a value in degrees to a value in radians.")
public class Radians {
    @Udf(description="Converts an INT value in degrees to a value in radians")
    public Double radians(@UdfParameter(value="value", description="The value in degrees to convert to radians.") Integer value) {
        return this.radians(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Converts a BIGINT value in degrees to a value in radians")
    public Double radians(@UdfParameter(value="value", description="The value in degrees to convert to radians.") Long value) {
        return this.radians(value == null ? null : Double.valueOf(value.doubleValue()));
    }

    @Udf(description="Converts a DOUBLE value in degrees to a value in radians")
    public Double radians(@UdfParameter(value="value", description="The value in degrees to convert to radians.") Double value) {
        return value == null ? null : Double.valueOf(Math.toRadians(value));
    }
}

