/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.math;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.function.udf.UdfSchemaProvider;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

@UdfDescription(name="trunc", category="MATHEMATICAL", description="Truncates a value to the number of decimal places as specified by scale to the right of the decimal point. If scale is negative then value is truncated to the right of the decimal point.", author="Confluent")
public class Trunc {
    static final String DESCRIPTION = "Truncates a value to the number of decimal places as specified by scale to the right of the decimal point. If scale is negative then value is truncated to the right of the decimal point.";

    @Udf
    public Long trunc(@UdfParameter Long val) {
        return val;
    }

    @Udf
    public Long trunc(@UdfParameter Integer val) {
        return val == null ? null : Long.valueOf(val.longValue());
    }

    @Udf
    public Long trunc(@UdfParameter Double val) {
        return val == null ? null : Long.valueOf(val.longValue());
    }

    @Udf
    public Double trunc(@UdfParameter Double val, @UdfParameter Integer decimalPlaces) {
        return val == null || decimalPlaces == null ? null : Double.valueOf(Trunc.roundBigDecimal(BigDecimal.valueOf(val), decimalPlaces).doubleValue());
    }

    @Udf(schemaProvider="provideDecimalSchema")
    public BigDecimal trunc(@UdfParameter BigDecimal val) {
        if (val == null) {
            return null;
        }
        return Trunc.roundBigDecimal(val, 0);
    }

    @Udf(schemaProvider="provideDecimalSchemaWithDecimalPlaces")
    public BigDecimal trunc(@UdfParameter BigDecimal val, @UdfParameter Integer decimalPlaces) {
        return val == null || decimalPlaces == null ? null : Trunc.roundBigDecimal(val, decimalPlaces).setScale(val.scale(), RoundingMode.UNNECESSARY);
    }

    @UdfSchemaProvider
    public static SqlType provideDecimalSchemaWithDecimalPlaces(List<SqlArgument> params) {
        SqlType s0 = params.get(0).getSqlTypeOrThrow();
        if (s0.baseType() != SqlBaseType.DECIMAL) {
            throw new KsqlException("The schema provider method for round expects a BigDecimal parametertype as first parameter.");
        }
        SqlType s1 = params.get(1).getSqlTypeOrThrow();
        if (s1.baseType() != SqlBaseType.INTEGER) {
            throw new KsqlException("The schema provider method for round expects an Integer parametertype as second parameter.");
        }
        return s0;
    }

    @UdfSchemaProvider
    public static SqlType provideDecimalSchema(List<SqlArgument> params) {
        SqlType s0 = params.get(0).getSqlTypeOrThrow();
        if (s0.baseType() != SqlBaseType.DECIMAL) {
            throw new KsqlException("The schema provider method for round expects a BigDecimal parametertype as a parameter.");
        }
        SqlDecimal param = (SqlDecimal)s0;
        return SqlDecimal.of((int)(param.getPrecision() - param.getScale()), (int)0);
    }

    private static BigDecimal roundBigDecimal(BigDecimal val, int decimalPlaces) {
        return val.setScale(decimalPlaces, RoundingMode.DOWN);
    }
}

