/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.nulls;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.name.FunctionName;
import java.util.Arrays;
import java.util.Objects;

@UdfDescription(name="COALESCE", category="CONDITIONAL", description="Returns first non-null element", author="Confluent")
public class Coalesce {
    public static final String NAME_TEXT = "COALESCE";
    public static final FunctionName NAME = FunctionName.of((String)"COALESCE");

    @SafeVarargs
    @Udf
    public final <T> T coalesce(T first, T ... others) {
        if (first != null) {
            return first;
        }
        if (others == null) {
            return null;
        }
        return Arrays.stream(others).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

