/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import com.google.common.base.Splitter;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@UdfDescription(name="regexp_split_to_array", author="Confluent", category="REGULAR EXPRESSION", description="Splits a string into an array of substrings based on a regexp. If the regexp is found at the beginning of the string, end of the string, or there are contiguous matches in the string, then empty strings are added to the array. If the regexp is not found, then the original string is returned as the only element in the array. If the regexp is empty, then all characters in the string are split.")
public class RegexpSplitToArray {
    @Udf(description="Splits a string into an array of substrings based on a regexp.")
    public List<String> regexpSplit(@UdfParameter(description="The string to be split. If NULL, then function returns NULL.") String string, @UdfParameter(description="The regular expression to split the string by. If NULL, then function returns NULL.") String regexp) {
        if (string == null || regexp == null) {
            return null;
        }
        Pattern p = this.getPattern(regexp);
        if (regexp.isEmpty() || p.matcher("").matches()) {
            return Arrays.asList(p.split(string));
        }
        return Splitter.on((Pattern)p).splitToList((CharSequence)string);
    }

    private Pattern getPattern(String regexp) {
        try {
            return Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            throw new KsqlFunctionException("Invalid regular expression pattern: " + regexp, (Throwable)e);
        }
    }
}

