/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udf.string;

import io.confluent.ksql.function.udf.Udf;
import io.confluent.ksql.function.udf.UdfDescription;
import io.confluent.ksql.function.udf.UdfParameter;
import io.confluent.ksql.util.BytesUtils;
import java.nio.ByteBuffer;

@UdfDescription(name="substring", category="STRING", author="Confluent", description="Returns the portion of the string or bytes passed in value.")
public class Substring {
    @Udf(description="Returns the portion of str from pos to the end of str")
    public String substring(@UdfParameter(description="The source string.") String str, @UdfParameter(description="The base-one position to start from.") Integer pos) {
        if (str == null || pos == null) {
            return null;
        }
        int start = Substring.getStartIndex(str.length(), pos);
        return str.substring(start);
    }

    @Udf(description="Returns the portion of str that starts at pos and is of length len")
    public String substring(@UdfParameter(description="The source string.") String str, @UdfParameter(description="The base-one position to start from.") Integer pos, @UdfParameter(description="The length to extract.") Integer length) {
        if (str == null || pos == null || length == null) {
            return null;
        }
        int start = Substring.getStartIndex(str.length(), pos);
        int end = Substring.getEndIndex(str.length(), start, length);
        return str.substring(start, end);
    }

    @Udf(description="Returns the portion of the bytes value from pos to the end of the bytes value")
    public ByteBuffer substring(@UdfParameter(description="The source bytes.") ByteBuffer bytes, @UdfParameter(description="The base-one position to start from.") Integer pos) {
        if (bytes == null || pos == null) {
            return null;
        }
        int start = Substring.getStartIndex(bytes.capacity(), pos);
        int end = bytes.capacity();
        return ByteBuffer.wrap(BytesUtils.getByteArray((ByteBuffer)bytes, (int)start, (int)end));
    }

    @Udf(description="Returns the portion of the bytes value that starts at pos and is of length len")
    public ByteBuffer substring(@UdfParameter(description="The source bytes.") ByteBuffer bytes, @UdfParameter(description="The base-one position to start from.") Integer pos, @UdfParameter(description="The length to extract.") Integer length) {
        if (bytes == null || pos == null || length == null) {
            return null;
        }
        int start = Substring.getStartIndex(bytes.capacity(), pos);
        int end = Substring.getEndIndex(bytes.capacity(), start, length);
        return ByteBuffer.wrap(BytesUtils.getByteArray((ByteBuffer)bytes, (int)start, (int)end));
    }

    private static int getStartIndex(int valueLength, Integer pos) {
        return pos < 0 ? Math.max(valueLength + pos, 0) : Math.max(Math.min(pos - 1, valueLength), 0);
    }

    private static int getEndIndex(int valueLength, int start, int length) {
        return Math.max(Math.min(start + length, valueLength), start);
    }
}

