/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import io.confluent.ksql.internal.MetricsReporter;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;

public class JmxDataPointsReporter
implements MetricsReporter {
    private final Metrics metrics;
    private final String group;
    private final Map<MetricName, DataPointBasedGauge> gauges = new ConcurrentHashMap<MetricName, DataPointBasedGauge>();
    private final Duration staleThreshold;

    public JmxDataPointsReporter(Metrics metrics, String group, Duration staleThreshold) {
        this.metrics = Objects.requireNonNull(metrics, "metrics");
        this.group = Objects.requireNonNull(group, "group");
        this.staleThreshold = Objects.requireNonNull(staleThreshold, "staleThreshold");
    }

    @Override
    public void report(List<MetricsReporter.DataPoint> dataPoints) {
        dataPoints.forEach(this::report);
    }

    private void report(MetricsReporter.DataPoint dataPoint) {
        MetricName metricName = this.metrics.metricName(dataPoint.getName(), this.group, dataPoint.getTags());
        if (this.gauges.containsKey(metricName)) {
            this.gauges.get(metricName).dataPointRef.set(dataPoint);
        } else {
            this.gauges.put(metricName, new DataPointBasedGauge(dataPoint, this.staleThreshold));
            this.metrics.addMetric(metricName, (MetricValueProvider)this.gauges.get(metricName));
        }
    }

    @Override
    public void cleanup(String name, Map<String, String> tags) {
        MetricName metricName = this.metrics.metricName(name, this.group, tags);
        this.metrics.removeMetric(metricName);
        this.gauges.remove(metricName);
    }

    @Override
    public void close() {
    }

    public void configure(Map<String, ?> map) {
    }

    private static final class DataPointBasedGauge
    implements Gauge<Object> {
        private final AtomicReference<MetricsReporter.DataPoint> dataPointRef;
        private final Duration staleThreshold;

        private DataPointBasedGauge(MetricsReporter.DataPoint initial, Duration staleThreshold) {
            this.dataPointRef = new AtomicReference<MetricsReporter.DataPoint>(initial);
            this.staleThreshold = staleThreshold;
        }

        public Object value(MetricConfig metricConfig, long now) {
            MetricsReporter.DataPoint dataPoint = this.dataPointRef.get();
            if (dataPoint.getTime().isAfter(Instant.ofEpochMilli(now).minus(this.staleThreshold))) {
                return dataPoint.getValue();
            }
            return null;
        }
    }
}

