/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.internal.MetricsTagUtils;
import io.confluent.ksql.util.KsqlException;
import java.io.File;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUtilizationMetricsReporter
implements MetricsReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageUtilizationMetricsReporter.class);
    private static final String METRIC_GROUP = "ksqldb_utilization";
    private static final String TASK_STORAGE_USED_BYTES = "task_storage_used_bytes";
    private Map<String, Map<String, TaskStorageMetric>> metricsSeen;
    private Metrics metricRegistry;
    private static Map<String, String> customTags = new HashMap<String, String>();
    private static final AtomicInteger numberStatefulTasks = new AtomicInteger(0);

    public void init(List<KafkaMetric> list) {
    }

    public synchronized void configure(Map<String, ?> map) {
        this.metricRegistry = (Metrics)Objects.requireNonNull(map.get("ksql.internal.metrics"));
        this.metricsSeen = new HashMap<String, Map<String, TaskStorageMetric>>();
    }

    public static void configureShared(File baseDir, Metrics metricRegistry, Map<String, String> configTags) {
        customTags = ImmutableMap.copyOf(configTags);
        LOGGER.info("Adding node level storage usage gauges");
        MetricName nodeAvailable = metricRegistry.metricName("node_storage_free_bytes", METRIC_GROUP, customTags);
        MetricName nodeTotal = metricRegistry.metricName("node_storage_total_bytes", METRIC_GROUP, customTags);
        MetricName nodeUsed = metricRegistry.metricName("node_storage_used_bytes", METRIC_GROUP, customTags);
        MetricName nodePct = metricRegistry.metricName("storage_utilization", METRIC_GROUP, customTags);
        MetricName maxTaskPerNode = metricRegistry.metricName("max_used_task_storage_bytes", METRIC_GROUP, customTags);
        MetricName numStatefulTasks = metricRegistry.metricName("num_stateful_tasks", METRIC_GROUP, customTags);
        metricRegistry.addMetric(nodeAvailable, (MetricValueProvider)((Gauge)(config, now) -> baseDir.getFreeSpace()));
        metricRegistry.addMetric(nodeTotal, (MetricValueProvider)((Gauge)(config, now) -> baseDir.getTotalSpace()));
        metricRegistry.addMetric(nodeUsed, (MetricValueProvider)((Gauge)(config, now) -> baseDir.getTotalSpace() - baseDir.getFreeSpace()));
        metricRegistry.addMetric(nodePct, (MetricValueProvider)((Gauge)(config, now) -> ((double)baseDir.getTotalSpace() - (double)baseDir.getFreeSpace()) / (double)baseDir.getTotalSpace()));
        metricRegistry.addMetric(maxTaskPerNode, (MetricValueProvider)((Gauge)(config, now) -> StorageUtilizationMetricsReporter.getMaxTaskUsage(metricRegistry)));
        metricRegistry.addMetric(numStatefulTasks, (MetricValueProvider)((Gauge)(config, now) -> numberStatefulTasks.get()));
    }

    public void metricChange(KafkaMetric metric) {
        if (!metric.metricName().name().equals("total-sst-files-size")) {
            return;
        }
        this.handleNewSstFilesSizeMetric(metric, metric.metricName().tags().getOrDefault("task-id", ""), this.getQueryId(metric));
    }

    public void metricRemoval(KafkaMetric metric) {
        MetricName metricName = metric.metricName();
        if (!metricName.name().equals("total-sst-files-size")) {
            return;
        }
        String queryId = this.getQueryId(metric);
        String taskId = metric.metricName().tags().getOrDefault("task-id", "");
        TaskStorageMetric taskMetric = this.metricsSeen.get(queryId).get(taskId);
        this.handleRemovedSstFileSizeMetric(taskMetric, metric, queryId, taskId);
    }

    public void close() {
    }

    public Set<String> reconfigurableConfigs() {
        return null;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
    }

    public void contextChange(MetricsContext metricsContext) {
    }

    private synchronized void handleNewSstFilesSizeMetric(KafkaMetric metric, String taskId, String queryId) {
        TaskStorageMetric newMetric;
        Map<String, String> queryMetricTags = this.getQueryMetricTags(queryId);
        Map<String, String> taskMetricTags = this.getTaskMetricTags(queryMetricTags, taskId);
        LOGGER.debug("Updating disk usage metrics");
        if (!this.metricsSeen.containsKey(queryId)) {
            this.metricRegistry.addMetric(this.metricRegistry.metricName("query_storage_used_bytes", METRIC_GROUP, queryMetricTags), (MetricValueProvider)((Gauge)(config, now) -> this.computeQueryMetric(queryId)));
            this.metricsSeen.put(queryId, new HashMap());
        }
        if (!this.metricsSeen.get(queryId).containsKey(taskId)) {
            numberStatefulTasks.getAndIncrement();
            newMetric = new TaskStorageMetric(this.metricRegistry.metricName(TASK_STORAGE_USED_BYTES, METRIC_GROUP, taskMetricTags));
            this.metricsSeen.get(queryId).put(taskId, newMetric);
            this.metricRegistry.addMetric(newMetric.metricName, (MetricValueProvider)((Gauge)(config, now) -> newMetric.getValue()));
        } else {
            newMetric = this.metricsSeen.get(queryId).get(taskId);
        }
        newMetric.add(metric);
    }

    private synchronized void handleRemovedSstFileSizeMetric(TaskStorageMetric taskMetric, KafkaMetric metric, String queryId, String taskId) {
        taskMetric.remove(metric);
        numberStatefulTasks.getAndDecrement();
        if (taskMetric.metrics.size() == 0) {
            this.metricRegistry.removeMetric(taskMetric.metricName);
            this.metricsSeen.get(queryId).remove(taskId);
            if (this.metricsSeen.get(queryId).size() == 0) {
                this.metricRegistry.removeMetric(this.metricRegistry.metricName("query_storage_used_bytes", METRIC_GROUP, this.getQueryMetricTags(queryId)));
            }
        }
    }

    private BigInteger computeQueryMetric(String queryId) {
        BigInteger queryMetricSum = BigInteger.ZERO;
        for (Supplier<BigInteger> gauge : this.getGaugesForQuery(queryId)) {
            queryMetricSum = queryMetricSum.add(gauge.get());
        }
        return queryMetricSum;
    }

    public static synchronized BigInteger getMaxTaskUsage(Metrics metricRegistry) {
        Collection<KafkaMetric> taskMetrics = metricRegistry.metrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).name().contains(TASK_STORAGE_USED_BYTES)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).values();
        Optional<BigInteger> maxOfTaskMetrics = taskMetrics.stream().map(e -> (BigInteger)e.metricValue()).reduce(BigInteger::max);
        return maxOfTaskMetrics.orElse(BigInteger.ZERO);
    }

    private synchronized Collection<Supplier<BigInteger>> getGaugesForQuery(String queryId) {
        return this.metricsSeen.get(queryId).values().stream().map(v -> v::getValue).collect(Collectors.toList());
    }

    private String getQueryId(KafkaMetric metric) {
        String taskName = metric.metricName().tags().getOrDefault("task-id", "");
        Matcher namedTopologyMatcher = MetricsTagUtils.SHARED_RUNTIME_THREAD_PATTERN.matcher(taskName);
        if (namedTopologyMatcher.find()) {
            return namedTopologyMatcher.group(1);
        }
        String queryIdTag = metric.metricName().tags().getOrDefault("thread-id", "");
        Matcher matcher = MetricsTagUtils.UNSHARED_RUNTIME_THREAD_PATTERN.matcher(queryIdTag);
        if (matcher.find()) {
            return matcher.group(1);
        }
        LOGGER.error("Can't parse query id from metric {}", (Object)metric);
        throw new KsqlException("Missing query ID when reporting utilization metrics");
    }

    private Map<String, String> getQueryMetricTags(String queryId) {
        HashMap<String, String> queryMetricTags = new HashMap<String, String>(customTags);
        queryMetricTags.put("query-id", queryId);
        return ImmutableMap.copyOf(queryMetricTags);
    }

    private Map<String, String> getTaskMetricTags(Map<String, String> queryTags, String taskId) {
        HashMap<String, String> taskMetricTags = new HashMap<String, String>(queryTags);
        taskMetricTags.put("task-id", taskId);
        return ImmutableMap.copyOf(taskMetricTags);
    }

    @VisibleForTesting
    static void setTags(Map<String, String> tags) {
        customTags = tags;
    }

    private static class TaskStorageMetric {
        final MetricName metricName;
        private final Map<MetricName, KafkaMetric> metrics = new ConcurrentHashMap<MetricName, KafkaMetric>();

        TaskStorageMetric(MetricName metricName) {
            this.metricName = metricName;
        }

        private void add(KafkaMetric metric) {
            this.metrics.put(metric.metricName(), metric);
        }

        private void remove(KafkaMetric metric) {
            this.metrics.remove(metric.metricName());
        }

        public BigInteger getValue() {
            BigInteger newValue = BigInteger.ZERO;
            for (KafkaMetric metric : this.metrics.values()) {
                BigInteger value = (BigInteger)metric.metricValue();
                newValue = newValue.add(value);
            }
            return newValue;
        }
    }
}

