/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logicalplanner.nodes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.logicalplanner.nodes.Node;
import io.confluent.ksql.logicalplanner.nodes.NodeVisitor;
import io.confluent.ksql.logicalplanner.nodes.SingleInputNode;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.Select;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.schema.ksql.LogicalColumn;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.UnknownColumnException;
import java.util.Iterator;
import java.util.Objects;

public final class SelectNode
extends SingleInputNode<SelectNode> {
    final ImmutableList<LogicalColumn> outputSchema;

    public SelectNode(Node<?> input, Select selectClause) {
        super(input);
        Objects.requireNonNull(selectClause, "selectClause");
        ImmutableList<LogicalColumn> inputSchema = input.getOutputSchema();
        ImmutableList.Builder outputSchemaBuilder = ImmutableList.builder();
        selectClause.getSelectItems().forEach(s -> {
            if (s instanceof AllColumns) {
                outputSchemaBuilder.addAll((Iterable)inputSchema);
            } else {
                Expression e = ((SingleColumn)s).getExpression();
                if (e instanceof ColumnReferenceExp) {
                    ColumnName columnName = ((ColumnReferenceExp)e).getColumnName();
                    ImmutableList matchingInputColumns = (ImmutableList)inputSchema.stream().filter(logicalColumn -> logicalColumn.name().equals((Object)columnName)).collect(ImmutableList.toImmutableList());
                    if (matchingInputColumns.isEmpty()) {
                        throw new UnknownColumnException("SELECT", (ColumnReferenceExp)e);
                    }
                    if (matchingInputColumns.size() > 1) {
                        throw new KsqlException("Ambiguous column " + columnName + " in SELECT clause");
                    }
                    outputSchemaBuilder.add(Iterators.getOnlyElement((Iterator)matchingInputColumns.iterator()));
                } else {
                    throw new UnsupportedOperationException("New query planner only support column references, no expressions or aliases.");
                }
            }
        });
        this.outputSchema = outputSchemaBuilder.build();
    }

    @Override
    public ImmutableList<LogicalColumn> getOutputSchema() {
        return this.outputSchema;
    }

    @Override
    public Node<?> getInputNode() {
        return this.input;
    }

    @Override
    public <ReturnsT> ReturnsT accept(NodeVisitor<SelectNode, ReturnsT> visitor) {
        return visitor.process(this);
    }
}

