/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.engine.rewrite.ExpressionTreeRewriter;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.QualifiedColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.streams.ForeignKeyJoinParamsFactory;
import io.confluent.ksql.execution.streams.JoinParamsFactory;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.tree.WithinExpression;
import io.confluent.ksql.planner.Projection;
import io.confluent.ksql.planner.RequiredColumns;
import io.confluent.ksql.planner.plan.DataSourceNode;
import io.confluent.ksql.planner.plan.JoiningNode;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.structured.SchemaKStream;
import io.confluent.ksql.structured.SchemaKTable;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JoinNode
extends PlanNode
implements JoiningNode {
    private final JoinType joinType;
    private final JoinKey joinKey;
    private final boolean finalJoin;
    private final PlanNode left;
    private final PlanNode right;
    private final JoiningNode leftJoining;
    private final JoiningNode rightJoining;
    private final Optional<WithinExpression> withinExpression;
    private final LogicalSchema schema;
    private final String defaultKeyFormat;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public JoinNode(PlanNodeId id, JoinType joinType, JoinKey joinKey, boolean finalJoin, PlanNode left, PlanNode right, Optional<WithinExpression> withinExpression, String defaultKeyFormat) {
        super(id, JoinNode.calculateSinkType(left, right), Optional.empty());
        this.joinType = Objects.requireNonNull(joinType, "joinType");
        this.joinKey = Objects.requireNonNull(joinKey, "joinKey");
        this.schema = joinKey.isForeignKey() ? ForeignKeyJoinParamsFactory.createSchema((LogicalSchema)left.getSchema(), (LogicalSchema)right.getSchema()) : JoinNode.buildJoinSchema(joinKey, left, right);
        this.finalJoin = finalJoin;
        this.left = Objects.requireNonNull(left, "left");
        this.leftJoining = (JoiningNode)((Object)left);
        this.right = Objects.requireNonNull(right, "right");
        this.rightJoining = (JoiningNode)((Object)right);
        this.withinExpression = Objects.requireNonNull(withinExpression, "withinExpression");
        this.defaultKeyFormat = Objects.requireNonNull(defaultKeyFormat, "defaultKeyFormat");
    }

    public void resolveKeyFormats() {
        KeyFormat joinKeyFormat = this.getPreferredKeyFormat().orElseGet(this::getDefaultSourceKeyFormat);
        this.setKeyFormat(joinKeyFormat);
    }

    @Override
    public Optional<KeyFormat> getPreferredKeyFormat() {
        Optional<KeyFormat> leftPreferred = this.leftJoining.getPreferredKeyFormat();
        return leftPreferred.isPresent() ? leftPreferred : this.rightJoining.getPreferredKeyFormat();
    }

    @Override
    public void setKeyFormat(KeyFormat format) {
        this.leftJoining.setKeyFormat(format);
        this.rightJoining.setKeyFormat(format);
    }

    @Override
    public LogicalSchema getSchema() {
        return this.schema;
    }

    @Override
    public List<PlanNode> getSources() {
        return Arrays.asList(this.left, this.right);
    }

    public PlanNode getLeft() {
        return this.left;
    }

    public PlanNode getRight() {
        return this.right;
    }

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext buildContext) {
        if (!this.joinKey.isForeignKey()) {
            this.ensureMatchingPartitionCounts(buildContext.getServiceContext().getTopicClient());
        }
        JoinerFactory joinerFactory = new JoinerFactory(buildContext, this, buildContext.buildNodeContext(this.getId().toString()));
        return joinerFactory.getJoiner(this.left.getNodeOutputType(), this.right.getNodeOutputType()).join();
    }

    @Override
    protected int getPartitions(KafkaTopicClient kafkaTopicClient) {
        return this.right.getPartitions(kafkaTopicClient);
    }

    @Override
    public Stream<ColumnName> resolveSelectStar(Optional<SourceName> sourceName) {
        Stream<ColumnName> names = Stream.of(this.left, this.right).flatMap(JoinNode::getPreJoinProjectDataSources).filter(s -> !sourceName.isPresent() || sourceName.equals(s.getSourceName())).flatMap(s -> s.resolveSelectStar(sourceName));
        if (sourceName.isPresent() || !this.joinKey.isSynthetic() || !this.finalJoin) {
            return names;
        }
        Column syntheticKey = (Column)Iterables.getOnlyElement((Iterable)this.getSchema().key());
        return Streams.concat((Stream[])new Stream[]{Stream.of(syntheticKey.name()), names});
    }

    @Override
    void validateKeyPresent(SourceName sinkName, Projection projection) {
        if (this.joinKey.isForeignKey()) {
            DataSourceNode leftInputTable = this.getLeftmostSourceNode();
            SourceName leftInputTableName = leftInputTable.getAlias();
            List leftInputTableKeys = leftInputTable.getDataSource().getSchema().key();
            List<Column> missingKeys = leftInputTableKeys.stream().filter(k -> !projection.containsExpression((Expression)new QualifiedColumnReferenceExp(leftInputTableName, k.name())) && !projection.containsExpression((Expression)new UnqualifiedColumnReferenceExp(ColumnNames.generatedJoinColumnAlias((SourceName)leftInputTableName, (ColumnName)k.name())))).collect(Collectors.toList());
            if (!missingKeys.isEmpty()) {
                JoinNode.throwMissingKeyColumnForFkJoinException(missingKeys, leftInputTableName);
            }
        } else {
            boolean atLeastOneKey = this.joinKey.getAllViableKeys(this.schema).stream().anyMatch(projection::containsExpression);
            if (!atLeastOneKey) {
                boolean synthetic = this.joinKey.isSynthetic();
                List<? extends Expression> viable = this.joinKey.getOriginalViableKeys(this.schema);
                JoinNode.throwKeysNotIncludedError(sinkName, "join expression", viable, false, synthetic);
            }
        }
    }

    private static void throwMissingKeyColumnForFkJoinException(List<Column> missingKeys, SourceName leftInputTableName) {
        String columnString = missingKeys.size() == 1 ? "column" : "columns";
        String plainInputTableName = leftInputTableName.text();
        int tablePrefixLength = plainInputTableName.length() + 1;
        throw new KsqlException(String.format("Primary key %s missing in projection. For foreign-key table-table joins, the projection must include all primary key columns from the left input table (%s). Missing %s: %s.", columnString, leftInputTableName, columnString, missingKeys.stream().map(c -> c.name().text()).map(name -> name.startsWith(plainInputTableName) ? name.substring(tablePrefixLength) : name).map(name -> String.format("`%s`", name)).collect(Collectors.joining(", "))));
    }

    @Override
    protected Set<ColumnReferenceExp> validateColumns(RequiredColumns requiredColumns) {
        boolean noSyntheticKey = !this.finalJoin || !this.joinKey.isSynthetic();
        RequiredColumns updated = noSyntheticKey ? requiredColumns : requiredColumns.asBuilder().remove((ColumnReferenceExp)new UnqualifiedColumnReferenceExp(((Column)Iterables.getOnlyElement((Iterable)this.schema.key())).name())).build();
        Set<ColumnReferenceExp> leftUnknown = this.left.validateColumns(updated);
        Set<ColumnReferenceExp> rightUnknown = this.right.validateColumns(updated);
        return Sets.intersection(leftUnknown, rightUnknown);
    }

    private ColumnName getKeyColumnName() {
        if (this.getSchema().key().size() > 1) {
            throw new KsqlException("JOINs are not supported with multiple key columns: " + this.getSchema().key());
        }
        return ((Column)Iterables.getOnlyElement((Iterable)this.getSchema().key())).name();
    }

    private void ensureMatchingPartitionCounts(KafkaTopicClient kafkaTopicClient) {
        int rightPartitions;
        int leftPartitions = this.left.getPartitions(kafkaTopicClient);
        if (leftPartitions == (rightPartitions = this.right.getPartitions(kafkaTopicClient))) {
            return;
        }
        SourceName leftSource = JoinNode.getSourceName(this.left);
        SourceName rightSource = JoinNode.getSourceName(this.right);
        throw new KsqlException("Can't join " + leftSource + " with " + rightSource + " since the number of partitions don't match. " + leftSource + " partitions = " + leftPartitions + "; " + rightSource + " partitions = " + rightPartitions + ". Please repartition either one so that the number of partitions match.");
    }

    private KeyFormat getDefaultSourceKeyFormat() {
        return Stream.of(this.left, this.right).flatMap(PlanNode::getSourceNodes).map(DataSourceNode::getDataSource).map(DataSource::getKsqlTopic).map(KsqlTopic::getKeyFormat).filter(format -> !format.getFormatInfo().getFormat().equals("NONE")).findFirst().orElse(KeyFormat.nonWindowed((FormatInfo)FormatInfo.of((String)this.defaultKeyFormat), (SerdeFeatures)SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0])));
    }

    private static SourceName getSourceName(PlanNode node) {
        return node.getLeftmostSourceNode().getAlias();
    }

    private static DataSource.DataSourceType calculateSinkType(PlanNode left, PlanNode right) {
        DataSource.DataSourceType leftType = left.getNodeOutputType();
        DataSource.DataSourceType rightType = right.getNodeOutputType();
        return leftType == DataSource.DataSourceType.KTABLE && rightType == DataSource.DataSourceType.KTABLE ? DataSource.DataSourceType.KTABLE : DataSource.DataSourceType.KSTREAM;
    }

    private static LogicalSchema buildJoinSchema(JoinKey joinKey, PlanNode left, PlanNode right) {
        ColumnName keyName = joinKey.resolveKeyName(left, right);
        return JoinParamsFactory.createSchema((ColumnName)keyName, (LogicalSchema)left.getSchema(), (LogicalSchema)right.getSchema());
    }

    private static Optional<JoinNode> findUpstreamJoin(PlanNode node) {
        PlanNode current = node;
        while (!(current instanceof JoinNode) && current instanceof JoiningNode) {
            if (current.getSources().size() != 1) {
                throw new IllegalStateException("Only JoinNode can have multiple sources.");
            }
            current = current.getSources().get(0);
        }
        if (current instanceof JoinNode) {
            return Optional.of((JoinNode)current);
        }
        return Optional.empty();
    }

    private static Stream<PlanNode> getPreJoinProjectDataSources(PlanNode node) {
        Optional<JoinNode> upstreamJoin = JoinNode.findUpstreamJoin(node);
        return upstreamJoin.map(n -> n.getSources().stream().flatMap(JoinNode::getPreJoinProjectDataSources)).orElse(Stream.of(node));
    }

    private static final class ForeignJoinKey
    implements JoinKey {
        private final Optional<ColumnName> foreignKeyColumn;
        private final Optional<Expression> foreignKeyExpression;
        private final ImmutableList<? extends ColumnReferenceExp> leftSourceKeyColumns;

        static JoinKey of(Expression foreignKeyExpression, Collection<QualifiedColumnReferenceExp> leftSourceKeyColumns) {
            return new ForeignJoinKey(Optional.empty(), Optional.of(foreignKeyExpression), leftSourceKeyColumns);
        }

        private ForeignJoinKey(Optional<ColumnName> foreignKeyColumn, Optional<Expression> foreignKeyExpression, Collection<? extends ColumnReferenceExp> viableKeyColumns) {
            this.foreignKeyColumn = Objects.requireNonNull(foreignKeyColumn, "foreignKeyColumn");
            this.foreignKeyExpression = Objects.requireNonNull(foreignKeyExpression, "foreignKeyExpression");
            this.leftSourceKeyColumns = ImmutableList.copyOf(Objects.requireNonNull(viableKeyColumns, "viableKeyColumns"));
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }

        @Override
        public boolean isForeignKey() {
            return true;
        }

        @Override
        public List<? extends Expression> getOriginalViableKeys(LogicalSchema schema) {
            throw new UnsupportedOperationException("Should not be called with foreign key joins.");
        }

        @Override
        public List<? extends Expression> getAllViableKeys(LogicalSchema schema) {
            throw new UnsupportedOperationException("Should not be called with foreign key joins.");
        }

        @Override
        public ColumnName resolveKeyName(PlanNode left, PlanNode right) {
            throw new UnsupportedOperationException("Should not be called with foreign key joins.");
        }

        @Override
        public JoinKey rewriteWith(BiFunction<Expression, ExpressionTreeRewriter.Context<Void>, Optional<Expression>> plugin) {
            List rewrittenViable = this.leftSourceKeyColumns.stream().map(e -> ExpressionTreeRewriter.rewriteWith(plugin, e)).collect(Collectors.toList());
            return new ForeignJoinKey(Optional.empty(), this.foreignKeyExpression, rewrittenViable);
        }

        public Optional<ColumnName> getForeignKeyColumn() {
            return this.foreignKeyColumn;
        }

        public Optional<Expression> getForeignKeyExpression() {
            return this.foreignKeyExpression;
        }
    }

    private static final class SyntheticJoinKey
    implements JoinKey {
        static JoinKey of() {
            return new SyntheticJoinKey();
        }

        private SyntheticJoinKey() {
        }

        @Override
        public boolean isSynthetic() {
            return true;
        }

        @Override
        public boolean isForeignKey() {
            return false;
        }

        @Override
        public List<? extends Expression> getAllViableKeys(LogicalSchema schema) {
            return this.getOriginalViableKeys(schema);
        }

        @Override
        public List<? extends Expression> getOriginalViableKeys(LogicalSchema schema) {
            return ImmutableList.of((Object)new UnqualifiedColumnReferenceExp(((Column)Iterables.getOnlyElement((Iterable)schema.key())).name()));
        }

        @Override
        public ColumnName resolveKeyName(PlanNode left, PlanNode right) {
            Stream<LogicalSchema> schemas = Streams.concat((Stream[])new Stream[]{left.getSourceNodes(), right.getSourceNodes()}).map(DataSourceNode::getDataSource).map(DataSource::getSchema);
            return ColumnNames.generateSyntheticJoinKey(schemas);
        }

        @Override
        public JoinKey rewriteWith(BiFunction<Expression, ExpressionTreeRewriter.Context<Void>, Optional<Expression>> plugin) {
            return this;
        }
    }

    private static final class SourceJoinKey
    implements JoinKey {
        private final ColumnName keyColumn;
        private final ImmutableList<QualifiedColumnReferenceExp> originalViableKeyColumns;
        private final ImmutableList<? extends ColumnReferenceExp> viableKeyColumns;

        static JoinKey of(ColumnName keyColumn, Collection<QualifiedColumnReferenceExp> viableKeyColumns) {
            return new SourceJoinKey(keyColumn, viableKeyColumns, viableKeyColumns);
        }

        private SourceJoinKey(ColumnName keyColumn, Collection<QualifiedColumnReferenceExp> originalViableKeyColumns, Collection<? extends ColumnReferenceExp> viableKeyColumns) {
            this.keyColumn = Objects.requireNonNull(keyColumn, "keyColumn");
            this.originalViableKeyColumns = ImmutableList.copyOf(Objects.requireNonNull(originalViableKeyColumns, "originalViableKeyColumns"));
            this.viableKeyColumns = ImmutableList.copyOf(Objects.requireNonNull(viableKeyColumns, "viableKeyColumns"));
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }

        @Override
        public boolean isForeignKey() {
            return false;
        }

        @Override
        public List<? extends Expression> getAllViableKeys(LogicalSchema schema) {
            return ImmutableList.builder().addAll(this.viableKeyColumns).addAll(this.originalViableKeyColumns).build();
        }

        @Override
        public List<? extends Expression> getOriginalViableKeys(LogicalSchema schema) {
            return this.originalViableKeyColumns;
        }

        @Override
        public ColumnName resolveKeyName(PlanNode left, PlanNode right) {
            return this.keyColumn;
        }

        @Override
        public JoinKey rewriteWith(BiFunction<Expression, ExpressionTreeRewriter.Context<Void>, Optional<Expression>> plugin) {
            List rewrittenViable = this.viableKeyColumns.stream().map(e -> ExpressionTreeRewriter.rewriteWith(plugin, e)).collect(Collectors.toList());
            return new SourceJoinKey(this.keyColumn, (Collection<QualifiedColumnReferenceExp>)this.originalViableKeyColumns, rewrittenViable);
        }
    }

    @Immutable
    public static interface JoinKey {
        public static JoinKey sourceColumn(ColumnName keyColumn, Collection<QualifiedColumnReferenceExp> viableKeyColumns) {
            return SourceJoinKey.of(keyColumn, viableKeyColumns);
        }

        public static JoinKey syntheticColumn() {
            return SyntheticJoinKey.of();
        }

        public static JoinKey foreignKey(Expression foreignKeyExpression, Collection<QualifiedColumnReferenceExp> viableKeyColumns) {
            return ForeignJoinKey.of(foreignKeyExpression, viableKeyColumns);
        }

        public boolean isSynthetic();

        public boolean isForeignKey();

        public List<? extends Expression> getAllViableKeys(LogicalSchema var1);

        public List<? extends Expression> getOriginalViableKeys(LogicalSchema var1);

        public ColumnName resolveKeyName(PlanNode var1, PlanNode var2);

        public JoinKey rewriteWith(BiFunction<Expression, ExpressionTreeRewriter.Context<Void>, Optional<Expression>> var1);
    }

    private static final class TableToTableJoiner<K>
    extends Joiner<K> {
        TableToTableJoiner(PlanBuildContext buildContext, JoinNode joinNode, QueryContext.Stacker contextStacker) {
            super(buildContext, joinNode, contextStacker);
        }

        @Override
        public SchemaKTable<K> join() {
            if (this.joinNode.withinExpression.isPresent()) {
                throw new KsqlException("A window definition was provided for a Table-Table join. These joins are not windowed. Please drop the window definition (i.e. the WITHIN clause) and try to execute your Table-Table join again.");
            }
            SchemaKTable leftTable = this.buildTable(this.joinNode.getLeft());
            SchemaKTable rightTable = this.buildTable(this.joinNode.getRight());
            JoinKey joinKey = this.joinNode.joinKey;
            FormatInfo valueFormatInfo = JoiningNode.getValueFormatForSource(this.joinNode.getLeft()).getFormatInfo();
            switch (this.joinNode.joinType) {
                case LEFT: {
                    if (joinKey.isForeignKey()) {
                        return leftTable.foreignKeyLeftJoin(rightTable, ((ForeignJoinKey)joinKey).getForeignKeyColumn(), ((ForeignJoinKey)joinKey).getForeignKeyExpression(), this.contextStacker, valueFormatInfo);
                    }
                    return leftTable.leftJoin(rightTable, this.joinNode.getKeyColumnName(), this.contextStacker);
                }
                case RIGHT: {
                    if (joinKey.isForeignKey()) {
                        throw new KsqlException("RIGHT OUTER JOIN on a foreign key is not supported");
                    }
                    return leftTable.rightJoin(rightTable, this.joinNode.getKeyColumnName(), this.contextStacker);
                }
                case INNER: {
                    if (joinKey.isForeignKey()) {
                        return leftTable.foreignKeyInnerJoin(rightTable, ((ForeignJoinKey)joinKey).getForeignKeyColumn(), ((ForeignJoinKey)joinKey).getForeignKeyExpression(), this.contextStacker, valueFormatInfo);
                    }
                    return leftTable.innerJoin(rightTable, this.joinNode.getKeyColumnName(), this.contextStacker);
                }
                case OUTER: {
                    if (joinKey.isForeignKey()) {
                        throw new IllegalStateException("Outer-join not supported by FK-joins.");
                    }
                    return leftTable.outerJoin(rightTable, this.joinNode.getKeyColumnName(), this.contextStacker);
                }
            }
            throw new KsqlException("Invalid join type encountered: " + (Object)((Object)this.joinNode.joinType));
        }
    }

    private static final class StreamToTableJoiner<K>
    extends Joiner<K> {
        private StreamToTableJoiner(PlanBuildContext buildContext, JoinNode joinNode, QueryContext.Stacker contextStacker) {
            super(buildContext, joinNode, contextStacker);
        }

        @Override
        public SchemaKStream<K> join() {
            if (this.joinNode.withinExpression.isPresent()) {
                throw new KsqlException("A window definition was provided for a Stream-Table join. These joins are not windowed. Please drop the window definition (ie. the WITHIN clause) and try to execute your join again.");
            }
            SchemaKTable rightTable = this.buildTable(this.joinNode.getRight());
            SchemaKStream leftStream = this.buildStream(this.joinNode.getLeft());
            switch (this.joinNode.joinType) {
                case LEFT: {
                    return leftStream.leftJoin(rightTable, this.joinNode.getKeyColumnName(), JoiningNode.getValueFormatForSource(this.joinNode.left).getFormatInfo(), this.contextStacker);
                }
                case INNER: {
                    return leftStream.innerJoin(rightTable, this.joinNode.getKeyColumnName(), JoiningNode.getValueFormatForSource(this.joinNode.left).getFormatInfo(), this.contextStacker);
                }
            }
            throw new KsqlException("Invalid join type encountered: " + (Object)((Object)this.joinNode.joinType));
        }
    }

    private static final class StreamToStreamJoiner<K>
    extends Joiner<K> {
        private StreamToStreamJoiner(PlanBuildContext buildContext, JoinNode joinNode, QueryContext.Stacker contextStacker) {
            super(buildContext, joinNode, contextStacker);
        }

        @Override
        public SchemaKStream<K> join() {
            if (!this.joinNode.withinExpression.isPresent()) {
                throw new KsqlException("Stream-Stream joins must have a WITHIN clause specified. None was provided. To learn about how to specify a WITHIN clause with a stream-stream join, please visit: https://docs.confluent.io/current/ksql/docs/syntax-reference.html#create-stream-as-select");
            }
            SchemaKStream leftStream = this.buildStream(this.joinNode.getLeft());
            SchemaKStream rightStream = this.buildStream(this.joinNode.getRight());
            switch (this.joinNode.joinType) {
                case LEFT: {
                    return leftStream.leftJoin(rightStream, this.joinNode.getKeyColumnName(), (WithinExpression)this.joinNode.withinExpression.get(), JoiningNode.getValueFormatForSource(this.joinNode.left).getFormatInfo(), JoiningNode.getValueFormatForSource(this.joinNode.right).getFormatInfo(), this.contextStacker);
                }
                case RIGHT: {
                    return leftStream.rightJoin(rightStream, this.joinNode.getKeyColumnName(), (WithinExpression)this.joinNode.withinExpression.get(), JoiningNode.getValueFormatForSource(this.joinNode.left).getFormatInfo(), JoiningNode.getValueFormatForSource(this.joinNode.right).getFormatInfo(), this.contextStacker);
                }
                case OUTER: {
                    return leftStream.outerJoin(rightStream, this.joinNode.getKeyColumnName(), (WithinExpression)this.joinNode.withinExpression.get(), JoiningNode.getValueFormatForSource(this.joinNode.left).getFormatInfo(), JoiningNode.getValueFormatForSource(this.joinNode.right).getFormatInfo(), this.contextStacker);
                }
                case INNER: {
                    return leftStream.innerJoin(rightStream, this.joinNode.getKeyColumnName(), (WithinExpression)this.joinNode.withinExpression.get(), JoiningNode.getValueFormatForSource(this.joinNode.left).getFormatInfo(), JoiningNode.getValueFormatForSource(this.joinNode.right).getFormatInfo(), this.contextStacker);
                }
            }
            throw new KsqlException("Invalid join type encountered: " + (Object)((Object)this.joinNode.joinType));
        }
    }

    private static abstract class Joiner<K> {
        final PlanBuildContext buildContext;
        final JoinNode joinNode;
        final QueryContext.Stacker contextStacker;

        Joiner(PlanBuildContext buildContext, JoinNode joinNode, QueryContext.Stacker contextStacker) {
            this.buildContext = Objects.requireNonNull(buildContext, "buildContext");
            this.joinNode = Objects.requireNonNull(joinNode, "joinNode");
            this.contextStacker = Objects.requireNonNull(contextStacker, "contextStacker");
        }

        public abstract SchemaKStream<K> join();

        SchemaKStream<K> buildStream(PlanNode node) {
            return node.buildStream(this.buildContext);
        }

        SchemaKTable<K> buildTable(PlanNode node) {
            SchemaKStream<?> schemaKStream = node.buildStream(this.buildContext.withKsqlConfig(this.buildContext.getKsqlConfig().cloneWithPropertyOverwrite(Collections.singletonMap("auto.offset.reset", "earliest"))));
            if (!(schemaKStream instanceof SchemaKTable)) {
                throw new RuntimeException("Expected to find a Table, found a stream instead.");
            }
            return (SchemaKTable)schemaKStream;
        }
    }

    private static class JoinerFactory {
        private final Map<Pair<DataSource.DataSourceType, DataSource.DataSourceType>, Supplier<Joiner<?>>> joinerMap = ImmutableMap.of((Object)new Pair((Object)DataSource.DataSourceType.KSTREAM, (Object)DataSource.DataSourceType.KSTREAM), () -> new StreamToStreamJoiner(buildContext, joinNode, contextStacker), (Object)new Pair((Object)DataSource.DataSourceType.KSTREAM, (Object)DataSource.DataSourceType.KTABLE), () -> new StreamToTableJoiner(buildContext, joinNode, contextStacker), (Object)new Pair((Object)DataSource.DataSourceType.KTABLE, (Object)DataSource.DataSourceType.KTABLE), () -> new TableToTableJoiner(buildContext, joinNode, contextStacker));

        JoinerFactory(PlanBuildContext buildContext, JoinNode joinNode, QueryContext.Stacker contextStacker) {
        }

        Joiner<?> getJoiner(DataSource.DataSourceType leftType, DataSource.DataSourceType rightType) {
            Supplier<Joiner<?>> joinerSupplier = this.joinerMap.get(new Pair((Object)leftType, (Object)rightType));
            if (joinerSupplier == null) {
                throw new IllegalStateException("Invalid joiner supplier requested: left type: " + leftType + ", right type: " + rightType);
            }
            return joinerSupplier.get();
        }
    }

    public static enum JoinType {
        INNER,
        LEFT,
        RIGHT,
        OUTER;


        public String toString() {
            switch (this) {
                case INNER: {
                    return "[INNER] JOIN";
                }
                case LEFT: {
                    return "LEFT [OUTER] JOIN";
                }
                case RIGHT: {
                    return "RIGHT [OUTER] JOIN";
                }
                case OUTER: {
                    return "[FULL] OUTER JOIN";
                }
            }
            throw new IllegalStateException();
        }
    }
}

