/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.Streams;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.DereferenceExpression;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.tree.AllColumns;
import io.confluent.ksql.parser.tree.SelectItem;
import io.confluent.ksql.parser.tree.SingleColumn;
import io.confluent.ksql.parser.tree.StructAll;
import io.confluent.ksql.planner.plan.ImplicitlyCastResolver;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class SelectionUtil {
    private SelectionUtil() {
    }

    public static LogicalSchema buildProjectionSchema(LogicalSchema parentSchema, List<SelectExpression> projection, FunctionRegistry functionRegistry) {
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(parentSchema, functionRegistry);
        ArrayList keyExpressions = new ArrayList(parentSchema.key().size());
        for (int i = 0; i < parentSchema.key().size(); ++i) {
            keyExpressions.add(new ArrayList());
        }
        HashSet keyExpressionMembership = new HashSet();
        for (SelectExpression select : projection) {
            Expression expression = select.getExpression();
            if (!(expression instanceof ColumnReferenceExp)) continue;
            ColumnName name = ((ColumnReferenceExp)expression).getColumnName();
            parentSchema.findColumn(name).filter(c -> c.namespace() == Column.Namespace.KEY).ifPresent(c -> {
                ((List)keyExpressions.get(c.index())).add(select);
                keyExpressionMembership.add(select);
            });
        }
        LogicalSchema.Builder builder = LogicalSchema.builder();
        int currKeyIdx = 0;
        for (SelectExpression select : projection) {
            SqlType type;
            if (keyExpressionMembership.contains(select)) {
                while (((List)keyExpressions.get(currKeyIdx)).isEmpty()) {
                    ++currKeyIdx;
                }
                SelectExpression keyExp = (SelectExpression)((List)keyExpressions.get(currKeyIdx)).remove(0);
                type = expressionTypeManager.getExpressionSqlType(keyExp.getExpression());
                builder.keyColumn(keyExp.getAlias(), type);
                continue;
            }
            Expression expression = select.getExpression();
            type = expressionTypeManager.getExpressionSqlType(expression);
            if (type == null) {
                throw new IllegalArgumentException("Can't infer a type of null. Please explicitly cast it to a required type, e.g. CAST(null AS VARCHAR).");
            }
            builder.valueColumn(select.getAlias(), type);
        }
        return builder.build();
    }

    public static List<SelectExpression> buildSelectExpressions(PlanNode parentNode, List<? extends SelectItem> selectItems, Optional<LogicalSchema> targetSchema) {
        return IntStream.range(0, selectItems.size()).boxed().flatMap(idx -> SelectionUtil.resolveSelectItem(idx, selectItems, parentNode, targetSchema)).collect(Collectors.toList());
    }

    private static Stream<SelectExpression> resolveSelectItem(int idx, List<? extends SelectItem> selectItems, PlanNode parentNode, Optional<LogicalSchema> targetSchema) {
        SelectItem selectItem = selectItems.get(idx);
        if (selectItem instanceof SingleColumn) {
            return SelectionUtil.resolveSingleColumn(idx, parentNode, (SingleColumn)selectItem, targetSchema);
        }
        if (selectItem instanceof AllColumns) {
            return SelectionUtil.resolveAllColumns(parentNode, (AllColumns)selectItem);
        }
        if (selectItem instanceof StructAll) {
            return SelectionUtil.resolveStructAll(idx, parentNode, (StructAll)selectItem, targetSchema);
        }
        throw new IllegalArgumentException("Unsupported SelectItem type: " + selectItem.getClass().getName());
    }

    private static Stream<SelectExpression> resolveSingleColumn(int idx, PlanNode parentNode, SingleColumn column, Optional<LogicalSchema> targetSchema) {
        Optional<Column> targetColumn = targetSchema.filter(schema -> schema.columns().size() > idx).map(schema -> (Column)schema.columns().get(idx));
        Expression expression = parentNode.resolveSelect(idx, column.getExpression());
        ColumnName alias = (ColumnName)column.getAlias().orElseThrow(() -> new IllegalStateException("Alias should be present by this point"));
        return Stream.of(SelectExpression.of((ColumnName)alias, (Expression)targetColumn.map(col -> ImplicitlyCastResolver.resolve(expression, col.type())).orElse(expression)));
    }

    private static Stream<SelectExpression> resolveAllColumns(PlanNode parentNode, AllColumns allColumns) {
        Stream<ColumnName> columns = parentNode.resolveSelectStar(allColumns.getSource());
        return columns.map(name -> SelectExpression.of((ColumnName)name, (Expression)new UnqualifiedColumnReferenceExp(allColumns.getLocation(), name)));
    }

    private static Stream<SelectExpression> resolveStructAll(int idx, PlanNode parentNode, StructAll structAll, Optional<LogicalSchema> targetSchema) {
        LogicalSchema parentSchema = parentNode.getSchema();
        Stream<SelectExpression> selectExpression = SelectionUtil.resolveSingleColumn(idx, parentNode, new SingleColumn(structAll.getBaseStruct(), Optional.of(ColumnName.of((String)"UNUSED"))), targetSchema);
        Expression expression = ((SelectExpression)Streams.findLast(selectExpression).get()).getExpression();
        SqlStruct mostNestedStructFields = SelectionUtil.resolveStructFields(parentSchema, expression);
        return mostNestedStructFields.fields().stream().map(f -> SelectExpression.of((ColumnName)ColumnName.of((String)f.name()), (Expression)new DereferenceExpression(Optional.empty(), expression, f.name())));
    }

    private static SqlStruct resolveStructFields(LogicalSchema parentSchema, Expression expression) {
        if (expression instanceof ColumnReferenceExp) {
            ColumnName columnName = ((ColumnReferenceExp)expression).getColumnName();
            Optional<SqlType> parentColumnType = parentSchema.findColumn(columnName).map(Column::type);
            if (parentColumnType.isPresent() && parentColumnType.get() instanceof SqlStruct) {
                return (SqlStruct)parentColumnType.get();
            }
            throw new IllegalArgumentException("Column " + columnName + " is not a STRUCT type.");
        }
        if (expression instanceof DereferenceExpression) {
            String fieldName = ((DereferenceExpression)expression).getFieldName();
            SqlStruct parentStruct = SelectionUtil.resolveStructFields(parentSchema, ((DereferenceExpression)expression).getBase());
            Optional parentStructField = parentStruct.field(fieldName);
            if (parentStructField.isPresent()) {
                if (((SqlStruct.Field)parentStructField.get()).type() instanceof SqlStruct) {
                    return (SqlStruct)((SqlStruct.Field)parentStructField.get()).type();
                }
                throw new IllegalArgumentException("Field " + fieldName + " is not a STRUCT type.");
            }
            throw new IllegalArgumentException("Field " + fieldName + " was not found on STRUCT.");
        }
        throw new IllegalArgumentException("Unsupported struct column expression: " + expression.getClass().getName());
    }
}

