/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.services.KafkaTopicClient;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class SingleSourcePlanNode
extends PlanNode {
    private final PlanNode source;

    public SingleSourcePlanNode(PlanNodeId id, DataSource.DataSourceType nodeOutputType, Optional<SourceName> sourceName, PlanNode source) {
        super(id, nodeOutputType, sourceName);
        this.source = Objects.requireNonNull(source, "source");
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    public PlanNode getSource() {
        return this.source;
    }

    @Override
    protected int getPartitions(KafkaTopicClient kafkaTopicClient) {
        return this.source.getPartitions(kafkaTopicClient);
    }
}

