/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.planner.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.streams.PartitionByParamsFactory;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.planner.Projection;
import io.confluent.ksql.planner.plan.PlanBuildContext;
import io.confluent.ksql.planner.plan.PlanNode;
import io.confluent.ksql.planner.plan.PlanNodeId;
import io.confluent.ksql.planner.plan.SingleSourcePlanNode;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.structured.SchemaKStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class UserRepartitionNode
extends SingleSourcePlanNode {
    private final ImmutableList<Expression> partitionBys;
    private final LogicalSchema schema;
    private final ImmutableList<Expression> originalPartitionBys;
    private final ValueFormat valueFormat;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public UserRepartitionNode(PlanNodeId id, PlanNode source, LogicalSchema schema, List<Expression> originalPartitionBys, List<Expression> partitionBys) {
        super(id, source.getNodeOutputType(), source.getSourceName(), source);
        this.schema = Objects.requireNonNull(schema, "schema");
        this.partitionBys = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionBys, "partitionBys"));
        this.originalPartitionBys = ImmutableList.copyOf((Collection)Objects.requireNonNull(originalPartitionBys, "originalPartitionBys"));
        this.valueFormat = this.getLeftmostSourceNode().getDataSource().getKsqlTopic().getValueFormat();
    }

    @Override
    public LogicalSchema getSchema() {
        return this.schema;
    }

    @Override
    public SchemaKStream<?> buildStream(PlanBuildContext buildContext) {
        return this.getSource().buildStream(buildContext).selectKey(this.valueFormat.getFormatInfo(), (List<Expression>)this.partitionBys, Optional.empty(), buildContext.buildNodeContext(this.getId().toString()), false);
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="partitionBys is ImmutableList")
    public List<Expression> getPartitionBys() {
        return this.partitionBys;
    }

    @Override
    public Expression resolveSelect(int idx, Expression expression) {
        for (int i = 0; i < this.partitionBys.size(); ++i) {
            if (!((Expression)this.partitionBys.get(i)).equals((Object)expression)) continue;
            return new UnqualifiedColumnReferenceExp(((Column)this.getSchema().key().get(i)).name());
        }
        return expression;
    }

    @Override
    public Stream<ColumnName> resolveSelectStar(Optional<SourceName> sourceName) {
        if (sourceName.isPresent() && !sourceName.equals(this.getSourceName())) {
            throw new IllegalArgumentException("Expected sourceName of " + this.getSourceName() + ", but was " + sourceName.get());
        }
        return UserRepartitionNode.orderColumns(this.getSchema().value(), this.getSchema());
    }

    @Override
    void validateKeyPresent(SourceName sinkName, Projection projection) {
        if (!PartitionByParamsFactory.isPartitionByNull(this.partitionBys) && !UserRepartitionNode.containsExpressions(projection, this.partitionBys)) {
            UserRepartitionNode.throwKeysNotIncludedError(sinkName, "partitioning expression", this.originalPartitionBys);
        }
    }

    private static boolean containsExpressions(Projection projection, List<Expression> expressions) {
        return expressions.stream().allMatch(projection::containsExpression);
    }
}

