/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryErrorClassifier;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.streams.errors.StreamsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlFunctionClassifier
implements QueryErrorClassifier {
    private static final Logger LOG = LoggerFactory.getLogger(KsqlFunctionClassifier.class);
    private final String queryId;

    public KsqlFunctionClassifier(String queryId) {
        this.queryId = Objects.requireNonNull(queryId, "queryId");
    }

    public QueryError.Type classify(Throwable e) {
        QueryError.Type type = QueryError.Type.UNKNOWN;
        if (e instanceof KsqlFunctionException || e instanceof StreamsException && ExceptionUtils.getRootCause((Throwable)e) instanceof KsqlFunctionException) {
            type = QueryError.Type.USER;
        }
        if (type == QueryError.Type.USER) {
            LOG.info("Classified error as USER error based on invalid user input. Query ID: {} Exception: {}", (Object)this.queryId, (Object)e);
        }
        return type;
    }
}

