/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.streams.materialization.KsqlMaterializationFactory;
import io.confluent.ksql.execution.streams.materialization.MaterializationProvider;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterialization;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializationFactory;
import io.confluent.ksql.logging.processing.NoopProcessingLogContext;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.GenericKeySerDe;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.Topology;

public final class MaterializationProviderBuilderFactory {
    private final KsqlConfig ksqlConfig;
    private final ServiceContext serviceContext;
    private final KsMaterializationFactory ksMaterializationFactory;
    private final KsqlMaterializationFactory ksqlMaterializationFactory;

    public MaterializationProviderBuilderFactory(KsqlConfig ksqlConfig, ServiceContext serviceContext, KsMaterializationFactory ksMaterializationFactory, KsqlMaterializationFactory ksqlMaterializationFactory) {
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.ksMaterializationFactory = Objects.requireNonNull(ksMaterializationFactory, "ksMaterializationFactory");
        this.ksqlMaterializationFactory = Objects.requireNonNull(ksqlMaterializationFactory, "ksqlMaterializationFactory");
    }

    public MaterializationProviderBuilder materializationProviderBuilder(MaterializationInfo materializationInfo, PhysicalSchema querySchema, KeyFormat keyFormat, Map<String, Object> streamsProperties, String applicationId, String queryId) {
        return (kafkaStreams, topology) -> this.buildMaterializationProvider((KafkaStreams)kafkaStreams, (Topology)topology, materializationInfo, querySchema, keyFormat, streamsProperties, applicationId, queryId);
    }

    private Optional<MaterializationProvider> buildMaterializationProvider(KafkaStreams kafkaStreams, Topology topology, MaterializationInfo materializationInfo, PhysicalSchema schema, KeyFormat keyFormat, Map<String, Object> streamsProperties, String applicationId, String queryId) {
        Serializer keySerializer = new GenericKeySerDe().create(keyFormat.getFormatInfo(), schema.keySchema(), this.ksqlConfig, this.serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty()).serializer();
        Optional ksMaterialization = this.ksMaterializationFactory.create(materializationInfo.stateStoreName(), kafkaStreams, topology, materializationInfo.getStateStoreSchema(), keySerializer, keyFormat.getWindowInfo(), streamsProperties, this.ksqlConfig, applicationId, queryId);
        return ksMaterialization.map(ksMat -> (queryId1, contextStacker) -> this.ksqlMaterializationFactory.create((StreamsMaterialization)ksMat, materializationInfo, queryId1, contextStacker));
    }

    public static interface MaterializationProviderBuilder
    extends BiFunction<KafkaStreams, Topology, Optional<MaterializationProvider>> {
    }
}

