/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.confluent.ksql.config.KsqlConfigResolver;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.QueryEventListener;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.QueryBuilder;
import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.query.QueryRegistry;
import io.confluent.ksql.rest.entity.PropertiesList;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.BinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.PersistentQueryMetadataImpl;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.SandboxedBinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.SandboxedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.SandboxedSharedKafkaStreamsRuntimeImpl;
import io.confluent.ksql.util.SandboxedTransientQueryMetadata;
import io.confluent.ksql.util.SharedKafkaStreamsRuntime;
import io.confluent.ksql.util.TransientQueryMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRegistryImpl
implements QueryRegistry {
    private final Logger log = LoggerFactory.getLogger(QueryRegistryImpl.class);
    private static final BiPredicate<SourceName, PersistentQueryMetadata> FILTER_QUERIES_WITH_SINK = (sourceName, query) -> query.getSinkName().equals(Optional.of(sourceName));
    private final Map<QueryId, PersistentQueryMetadata> persistentQueries = new ConcurrentHashMap<QueryId, PersistentQueryMetadata>();
    private final Map<QueryId, QueryMetadata> allLiveQueries = new ConcurrentHashMap<QueryId, QueryMetadata>();
    private final Map<SourceName, QueryId> createAsQueries = new ConcurrentHashMap<SourceName, QueryId>();
    private final Map<SourceName, Set<QueryId>> insertQueries = new ConcurrentHashMap<SourceName, Set<QueryId>>();
    private final Collection<QueryEventListener> eventListeners;
    private final QueryBuilderFactory queryBuilderFactory;
    private final MetricCollectors metricCollectors;
    private final List<SharedKafkaStreamsRuntime> streams = new ArrayList<SharedKafkaStreamsRuntime>();
    private final List<SharedKafkaStreamsRuntime> sourceStreams = new ArrayList<SharedKafkaStreamsRuntime>();
    private final boolean sandbox;

    public QueryRegistryImpl(Collection<QueryEventListener> eventListeners, MetricCollectors metricCollectors) {
        this(eventListeners, QueryBuilder::new, metricCollectors);
    }

    QueryRegistryImpl(Collection<QueryEventListener> eventListeners, QueryBuilderFactory queryBuilderFactory, MetricCollectors metricCollectors) {
        this.eventListeners = Objects.requireNonNull(eventListeners);
        this.queryBuilderFactory = Objects.requireNonNull(queryBuilderFactory);
        this.metricCollectors = metricCollectors;
        this.sandbox = false;
    }

    private QueryRegistryImpl(QueryRegistryImpl original) {
        this.queryBuilderFactory = original.queryBuilderFactory;
        original.allLiveQueries.forEach((queryId, queryMetadata) -> {
            if (queryMetadata instanceof PersistentQueryMetadataImpl) {
                SandboxedPersistentQueryMetadataImpl sandboxed = SandboxedPersistentQueryMetadataImpl.of((PersistentQueryMetadataImpl)queryMetadata, new ListenerImpl());
                this.persistentQueries.put(sandboxed.getQueryId(), sandboxed);
                this.allLiveQueries.put(sandboxed.getQueryId(), sandboxed);
            } else if (queryMetadata instanceof BinPackedPersistentQueryMetadataImpl) {
                SandboxedBinPackedPersistentQueryMetadataImpl sandboxed = SandboxedBinPackedPersistentQueryMetadataImpl.of((BinPackedPersistentQueryMetadataImpl)queryMetadata, new ListenerImpl());
                this.persistentQueries.put(sandboxed.getQueryId(), sandboxed);
                this.allLiveQueries.put(sandboxed.getQueryId(), sandboxed);
            } else {
                SandboxedTransientQueryMetadata sandboxed = SandboxedTransientQueryMetadata.of((TransientQueryMetadata)queryMetadata, new ListenerImpl());
                this.allLiveQueries.put(sandboxed.getQueryId(), sandboxed);
            }
        });
        this.createAsQueries.putAll(original.createAsQueries);
        for (Map.Entry<SourceName, Set<QueryId>> inserts : original.insertQueries.entrySet()) {
            Set sandboxInserts = Collections.synchronizedSet(new HashSet());
            sandboxInserts.addAll(inserts.getValue());
            this.insertQueries.put(inserts.getKey(), sandboxInserts);
        }
        this.eventListeners = original.eventListeners.stream().map(QueryEventListener::createSandbox).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        this.sourceStreams.addAll(original.streams);
        this.metricCollectors = original.metricCollectors;
        this.sandbox = true;
    }

    @Override
    public TransientQueryMetadata createTransientQuery(SessionConfig config, ServiceContext serviceContext, ProcessingLogContext processingLogContext, MetaStore metaStore, String statementText, QueryId queryId, Set<SourceName> sources, ExecutionStep<?> physicalPlan, String planSummary, LogicalSchema schema, OptionalInt limit, Optional<WindowInfo> windowInfo, boolean excludeTombstones) {
        QueryBuilder queryBuilder = this.queryBuilderFactory.create(config, processingLogContext, serviceContext, (FunctionRegistry)metaStore, this.streams, !this.sandbox);
        TransientQueryMetadata query = queryBuilder.buildTransientQuery(statementText, queryId, sources, physicalPlan, planSummary, schema, limit, windowInfo, excludeTombstones, new ListenerImpl(), new StreamsBuilder(), Optional.empty(), this.metricCollectors);
        query.initialize();
        this.registerTransientQuery(serviceContext, metaStore, query);
        return query;
    }

    @Override
    public TransientQueryMetadata createStreamPullQuery(SessionConfig config, ServiceContext serviceContext, ProcessingLogContext processingLogContext, MetaStore metaStore, String statementText, QueryId queryId, Set<SourceName> sources, ExecutionStep<?> physicalPlan, String planSummary, LogicalSchema schema, OptionalInt limit, Optional<WindowInfo> windowInfo, boolean excludeTombstones, ImmutableMap<TopicPartition, Long> endOffsets) {
        QueryBuilder queryBuilder = this.queryBuilderFactory.create(config, processingLogContext, serviceContext, (FunctionRegistry)metaStore, this.streams, !this.sandbox);
        TransientQueryMetadata query = queryBuilder.buildTransientQuery(statementText, queryId, sources, physicalPlan, planSummary, schema, limit, windowInfo, excludeTombstones, new ListenerImpl(), new StreamsBuilder(), Optional.of(endOffsets), this.metricCollectors);
        query.initialize();
        this.notifyCreate(serviceContext, metaStore, query);
        return query;
    }

    @Override
    public void updateStreamsPropertiesAndRestartRuntime(KsqlConfig config, ProcessingLogContext logContext) {
        for (SharedKafkaStreamsRuntime stream : this.streams) {
            this.updateStreamsProperties(stream, config, logContext);
            stream.restartStreamsRuntime();
        }
    }

    @Override
    public PersistentQueryMetadata createOrReplacePersistentQuery(SessionConfig config, ServiceContext serviceContext, ProcessingLogContext processingLogContext, MetaStore metaStore, String statementText, QueryId queryId, Optional<DataSource> sinkDataSource, Set<DataSource> sources, ExecutionStep<?> physicalPlan, String planSummary, KsqlConstants.PersistentQueryType persistentQueryType, Optional<String> sharedRuntimeId) {
        PersistentQueryMetadata query;
        QueryBuilder queryBuilder = this.queryBuilderFactory.create(config, processingLogContext, serviceContext, (FunctionRegistry)metaStore, this.streams, !this.sandbox);
        KsqlConfig ksqlConfig = config.getConfig(true);
        PersistentQueryMetadata oldQuery = this.persistentQueries.get(queryId);
        if (sharedRuntimeId.isPresent() && ksqlConfig.getBoolean("ksql.runtime.feature.shared.enabled").booleanValue() && (oldQuery == null || oldQuery instanceof BinPackedPersistentQueryMetadataImpl)) {
            if (this.sandbox) {
                QueryRegistryImpl.throwOnNonQueryLevelConfigs(config.getOverrides());
                this.streams.addAll(this.sourceStreams.stream().filter(t -> t.getApplicationId().equals(sharedRuntimeId.get())).map(SandboxedSharedKafkaStreamsRuntimeImpl::new).collect(Collectors.toList()));
            }
            query = queryBuilder.buildPersistentQueryInSharedRuntime(ksqlConfig, persistentQueryType, statementText, queryId, sinkDataSource, sources, physicalPlan, planSummary, new ListenerImpl(), () -> ImmutableList.copyOf(this.getPersistentQueries().values()), sharedRuntimeId.get(), this.metricCollectors);
            query.register();
        } else {
            query = queryBuilder.buildPersistentQueryInDedicatedRuntime(ksqlConfig, persistentQueryType, statementText, queryId, sinkDataSource, sources, physicalPlan, planSummary, new ListenerImpl(), () -> ImmutableList.copyOf(this.getPersistentQueries().values()), new StreamsBuilder(), this.metricCollectors);
        }
        this.registerPersistentQuery(serviceContext, metaStore, query);
        return query;
    }

    private static void throwOnNonQueryLevelConfigs(Map<String, Object> overriddenProperties) {
        String nonQueryLevelConfigs = overriddenProperties.keySet().stream().filter(s -> {
            KsqlConfigResolver resolver = new KsqlConfigResolver();
            Optional resolvedItem = resolver.resolve(s, false);
            return resolvedItem.map(configItem -> !PropertiesList.QueryLevelProperties.contains(configItem.getPropertyName())).orElse(true);
        }).distinct().collect(Collectors.joining(","));
        if (!nonQueryLevelConfigs.isEmpty()) {
            throw new IllegalArgumentException(String.format("When shared runtimes are enabled, the configs %s can only be set for the entire cluster and all queries currently running in it, and not configurable for individual queries. Please use ALTER SYSTEM to change these config for all queries.", nonQueryLevelConfigs));
        }
    }

    @Override
    public Optional<PersistentQueryMetadata> getPersistentQuery(QueryId queryId) {
        return Optional.ofNullable(this.persistentQueries.get(queryId));
    }

    @Override
    public Optional<QueryMetadata> getQuery(QueryId queryId) {
        return Optional.ofNullable(this.allLiveQueries.get(queryId));
    }

    @Override
    public Map<QueryId, PersistentQueryMetadata> getPersistentQueries() {
        return Collections.unmodifiableMap(this.persistentQueries);
    }

    @Override
    public Set<QueryId> getQueriesWithSink(SourceName sourceName) {
        ImmutableSet.Builder queries = ImmutableSet.builder();
        if (this.createAsQueries.containsKey(sourceName)) {
            queries.add((Object)this.createAsQueries.get(sourceName));
        }
        queries.addAll(this.getInsertQueries(sourceName, FILTER_QUERIES_WITH_SINK));
        return queries.build();
    }

    @Override
    public List<QueryMetadata> getAllLiveQueries() {
        return ImmutableList.copyOf(this.allLiveQueries.values());
    }

    @Override
    public Optional<QueryMetadata> getCreateAsQuery(SourceName sourceName) {
        if (this.createAsQueries.containsKey(sourceName)) {
            return Optional.of(this.persistentQueries.get(this.createAsQueries.get(sourceName)));
        }
        return Optional.empty();
    }

    @Override
    public Set<QueryId> getInsertQueries(SourceName sourceName, BiPredicate<SourceName, PersistentQueryMetadata> filterQueries) {
        return this.insertQueries.getOrDefault(sourceName, Collections.emptySet()).stream().map(this.persistentQueries::get).filter(query -> filterQueries.test(sourceName, (PersistentQueryMetadata)query)).map(QueryMetadata::getQueryId).collect(Collectors.toSet());
    }

    @Override
    public QueryRegistry createSandbox() {
        return new QueryRegistryImpl(this);
    }

    @Override
    public void close(boolean closePersistent) {
        for (QueryMetadata queryMetadata : this.getAllLiveQueries()) {
            if (closePersistent || queryMetadata instanceof TransientQueryMetadata) {
                queryMetadata.close();
                continue;
            }
            ((PersistentQueryMetadata)queryMetadata).stop(false);
            this.unregisterQuery(queryMetadata);
        }
        this.closeRuntimes();
    }

    @Override
    public void closeRuntimes() {
        for (SharedKafkaStreamsRuntime sharedKafkaStreamsRuntime : this.streams) {
            sharedKafkaStreamsRuntime.close();
        }
        this.streams.clear();
    }

    private void updateStreamsProperties(SharedKafkaStreamsRuntime stream, KsqlConfig config, ProcessingLogContext logContext) {
        Map<String, Object> newStreamsProperties = QueryBuilder.buildStreamsProperties(stream.getApplicationId(), Optional.empty(), this.metricCollectors, config, logContext);
        stream.overrideStreamsProperties(newStreamsProperties);
    }

    private void registerPersistentQuery(ServiceContext serviceContext, MetaStore metaStore, PersistentQueryMetadata persistentQuery) {
        QueryId queryId = persistentQuery.getQueryId();
        PersistentQueryMetadata oldQuery = this.persistentQueries.get(queryId);
        if (oldQuery != null) {
            oldQuery.getPhysicalPlan().validateUpgrade(persistentQuery.getPhysicalPlan());
            this.log.info("Detected that query {} already exists so will replace it.First will stop without resetting offsets", (Object)oldQuery.getQueryId());
            oldQuery.stop(false);
            this.unregisterQuery(oldQuery);
        }
        if (oldQuery == null || !this.sandbox) {
            persistentQuery.initialize();
        }
        this.persistentQueries.put(queryId, persistentQuery);
        switch (persistentQuery.getPersistentQueryType()) {
            case CREATE_SOURCE: {
                this.createAsQueries.put((SourceName)Iterables.getOnlyElement(persistentQuery.getSourceNames()), queryId);
                break;
            }
            case CREATE_AS: {
                this.createAsQueries.put(persistentQuery.getSinkName().get(), queryId);
                break;
            }
            case INSERT: {
                this.sinkAndSources(persistentQuery).forEach(sourceName -> this.insertQueries.computeIfAbsent((SourceName)sourceName, x -> Collections.synchronizedSet(new HashSet())).add(queryId));
                break;
            }
        }
        this.allLiveQueries.put(persistentQuery.getQueryId(), persistentQuery);
        this.notifyCreate(serviceContext, metaStore, persistentQuery);
    }

    private void registerTransientQuery(ServiceContext serviceContext, MetaStore metaStore, TransientQueryMetadata query) {
        if (!query.isInitialized()) {
            throw new IllegalStateException("Transient query must be initialized before it might be exposed to other threads via allLiveQueries");
        }
        this.allLiveQueries.put(query.getQueryId(), query);
        this.notifyCreate(serviceContext, metaStore, query);
    }

    private void unregisterQuery(QueryMetadata query) {
        if (query instanceof PersistentQueryMetadata) {
            PersistentQueryMetadata persistentQuery = (PersistentQueryMetadata)query;
            QueryId queryId = persistentQuery.getQueryId();
            this.persistentQueries.remove(queryId);
            Set<SharedKafkaStreamsRuntime> toClose = this.streams.stream().filter(s -> s.getCollocatedQueries().isEmpty()).collect(Collectors.toSet());
            this.streams.removeAll(toClose);
            toClose.forEach(SharedKafkaStreamsRuntime::close);
            switch (persistentQuery.getPersistentQueryType()) {
                case CREATE_SOURCE: {
                    this.createAsQueries.remove(Iterables.getOnlyElement(persistentQuery.getSourceNames()));
                    break;
                }
                case CREATE_AS: {
                    this.createAsQueries.remove(persistentQuery.getSinkName().get());
                    break;
                }
                case INSERT: {
                    this.sinkAndSources(persistentQuery).forEach(sourceName -> this.insertQueries.computeIfPresent((SourceName)sourceName, (s, queries) -> {
                        queries.remove(queryId);
                        return queries.isEmpty() ? null : queries;
                    }));
                    break;
                }
            }
        }
        this.allLiveQueries.remove(query.getQueryId());
        this.notifyDeregister(query);
    }

    private void notifyCreate(ServiceContext serviceContext, MetaStore metaStore, QueryMetadata queryMetadata) {
        this.eventListeners.forEach(l -> l.onCreate(serviceContext, metaStore, queryMetadata));
    }

    private void notifyDeregister(QueryMetadata queryMetadata) {
        this.eventListeners.forEach(l -> l.onDeregister(queryMetadata));
    }

    private Iterable<SourceName> sinkAndSources(PersistentQueryMetadata query) {
        return Iterables.concat(query.getSinkName().isPresent() ? Collections.singleton(query.getSinkName().get()) : Collections.emptySet(), query.getSourceNames());
    }

    private class ListenerImpl
    implements QueryMetadata.Listener {
        private ListenerImpl() {
        }

        @Override
        public void onError(QueryMetadata queryMetadata, QueryError error) {
            QueryRegistryImpl.this.eventListeners.forEach(l -> l.onError(queryMetadata, error));
        }

        @Override
        public void onStateChange(QueryMetadata queryMetadata, KafkaStreams.State before, KafkaStreams.State after) {
            QueryRegistryImpl.this.eventListeners.forEach(l -> l.onStateChange(queryMetadata, before, after));
        }

        @Override
        public void onPause(QueryMetadata queryMetadata) {
            QueryRegistryImpl.this.eventListeners.forEach(l -> l.onKsqlStateChange(queryMetadata));
        }

        @Override
        public void onResume(QueryMetadata queryMetadata) {
            QueryRegistryImpl.this.eventListeners.forEach(l -> l.onKsqlStateChange(queryMetadata));
        }

        @Override
        public void onClose(QueryMetadata queryMetadata) {
            QueryRegistryImpl.this.unregisterQuery(queryMetadata);
            QueryRegistryImpl.this.eventListeners.forEach(l -> l.onClose(queryMetadata));
        }
    }

    @FunctionalInterface
    static interface QueryBuilderFactory {
        public QueryBuilder create(SessionConfig var1, ProcessingLogContext var2, ServiceContext var3, FunctionRegistry var4, List<SharedKafkaStreamsRuntime> var5, boolean var6);
    }
}

