/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.ksql.exception.KsqlSchemaAuthorizationException;
import io.confluent.ksql.exception.KsqlTopicAuthorizationException;
import io.confluent.ksql.security.AuthObjectType;
import io.confluent.ksql.security.KsqlAccessValidator;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.acl.AclOperation;

@ThreadSafe
public class KsqlCacheAccessValidator
implements KsqlAccessValidator {
    private static final boolean ALLOW_ACCESS = true;
    private final LoadingCache<CacheKey, CacheValue> cache;
    private final KsqlAccessValidator backendValidator;

    public KsqlCacheAccessValidator(KsqlConfig ksqlConfig, KsqlAccessValidator backendValidator) {
        this(ksqlConfig, backendValidator, Ticker.systemTicker());
    }

    @VisibleForTesting
    KsqlCacheAccessValidator(KsqlConfig ksqlConfig, KsqlAccessValidator backendValidator, Ticker cacheTicker) {
        this.backendValidator = backendValidator;
        long expiryTime = ksqlConfig.getLong("ksql.authorization.cache.expiry.time.secs");
        long maxEntries = ksqlConfig.getLong("ksql.authorization.cache.max.entries");
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(expiryTime, TimeUnit.SECONDS).maximumSize(maxEntries).ticker(cacheTicker).build(this.buildCacheLoader());
    }

    private CacheLoader<CacheKey, CacheValue> buildCacheLoader() {
        return new CacheLoader<CacheKey, CacheValue>(){

            public CacheValue load(CacheKey cacheKey) {
                switch (cacheKey.authObjectType) {
                    case TOPIC: {
                        return KsqlCacheAccessValidator.this.internalTopicAccessValidator(cacheKey);
                    }
                    case SUBJECT: {
                        return KsqlCacheAccessValidator.this.internalSubjectAccessValidator(cacheKey);
                    }
                }
                throw new IllegalStateException("Unknown access validator type: " + (Object)((Object)cacheKey.authObjectType));
            }
        };
    }

    private CacheValue internalTopicAccessValidator(CacheKey cacheKey) {
        try {
            this.backendValidator.checkTopicAccess(cacheKey.securityContext, cacheKey.objectName, cacheKey.operation);
        }
        catch (KsqlTopicAuthorizationException e) {
            return new CacheValue(false, Optional.of(e));
        }
        return new CacheValue(true, Optional.empty());
    }

    private CacheValue internalSubjectAccessValidator(CacheKey cacheKey) {
        try {
            this.backendValidator.checkSubjectAccess(cacheKey.securityContext, cacheKey.objectName, cacheKey.operation);
        }
        catch (KsqlSchemaAuthorizationException e) {
            return new CacheValue(false, Optional.of(e));
        }
        return new CacheValue(true, Optional.empty());
    }

    private void checkAccess(CacheKey cacheKey) {
        CacheValue cacheValue = (CacheValue)this.cache.getUnchecked((Object)cacheKey);
        if (!cacheValue.allowAccess) {
            throw (RuntimeException)cacheValue.denialReason.get();
        }
    }

    @Override
    public void checkTopicAccess(KsqlSecurityContext securityContext, String topicName, AclOperation operation) {
        this.checkAccess(new CacheKey(securityContext, AuthObjectType.TOPIC, topicName, operation));
    }

    @Override
    public void checkSubjectAccess(KsqlSecurityContext securityContext, String subjectName, AclOperation operation) {
        this.checkAccess(new CacheKey(securityContext, AuthObjectType.SUBJECT, subjectName, operation));
    }

    static class CacheValue {
        private final boolean allowAccess;
        private final Optional<RuntimeException> denialReason;

        CacheValue(boolean allowAccess, Optional<RuntimeException> denialReason) {
            this.allowAccess = allowAccess;
            this.denialReason = denialReason;
        }
    }

    static class CacheKey {
        private static final String UNKNOWN_USER = "";
        private final KsqlSecurityContext securityContext;
        private final AuthObjectType authObjectType;
        private final String objectName;
        private final AclOperation operation;

        CacheKey(KsqlSecurityContext securityContext, AuthObjectType authObjectType, String objectName, AclOperation operation) {
            this.securityContext = securityContext;
            this.authObjectType = authObjectType;
            this.objectName = objectName;
            this.operation = operation;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.getUserName(this.securityContext).equals(this.getUserName(other.securityContext)) && this.authObjectType.equals((Object)other.authObjectType) && this.objectName.equals(other.objectName) && this.operation.code() == other.operation.code();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getUserName(this.securityContext), this.authObjectType, this.objectName, this.operation.code()});
        }

        private String getUserName(KsqlSecurityContext securityContext) {
            return securityContext.getUserPrincipal().isPresent() ? securityContext.getUserPrincipal().get().getName() : UNKNOWN_USER;
        }
    }
}

