/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.security.AuthObjectType;
import io.confluent.ksql.security.KsqlAccessValidator;
import io.confluent.ksql.security.KsqlAuthorizationProvider;
import io.confluent.ksql.security.KsqlSecurityContext;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.acl.AclOperation;

public class KsqlProvidedAccessValidator
implements KsqlAccessValidator {
    private final KsqlAuthorizationProvider authorizationProvider;

    public KsqlProvidedAccessValidator(KsqlAuthorizationProvider authorizationProvider) {
        this.authorizationProvider = Objects.requireNonNull(authorizationProvider, "authorizationProvider");
    }

    @Override
    public void checkTopicAccess(KsqlSecurityContext securityContext, String topicName, AclOperation operation) {
        this.authorizationProvider.checkPrivileges(securityContext, AuthObjectType.TOPIC, topicName, (List<AclOperation>)ImmutableList.of((Object)operation));
    }

    @Override
    public void checkSubjectAccess(KsqlSecurityContext securityContext, String subjectName, AclOperation operation) {
        this.authorizationProvider.checkPrivileges(securityContext, AuthObjectType.SUBJECT, subjectName, (List<AclOperation>)ImmutableList.of((Object)operation));
    }
}

