/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.services.KafkaClusterUtil;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.TopicValidationUtil;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.LimitedProxyBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AclOperation;

@SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
final class SandboxedKafkaTopicClient {
    private static final String DEFAULT_REPLICATION_PROP = "default.replication.factor";
    private final KafkaTopicClient delegate;
    private final Supplier<Admin> adminClient;
    private final Map<String, TopicDescription> createdTopics = new HashMap<String, TopicDescription>();
    private final Map<String, Map<String, String>> createdTopicsConfig = new HashMap<String, Map<String, String>>();

    static KafkaTopicClient createProxy(KafkaTopicClient delegate, Supplier<Admin> sharedAdmin) {
        SandboxedKafkaTopicClient sandbox = new SandboxedKafkaTopicClient(delegate, sharedAdmin);
        return (KafkaTopicClient)LimitedProxyBuilder.forClass(KafkaTopicClient.class).forward("createTopic", LimitedProxyBuilder.methodParams(String.class, Integer.TYPE, Short.TYPE), sandbox).forward("createTopic", LimitedProxyBuilder.methodParams(String.class, Integer.TYPE, Short.TYPE, Map.class), sandbox).forward("isTopicExists", LimitedProxyBuilder.methodParams(String.class), sandbox).forward("describeTopic", LimitedProxyBuilder.methodParams(String.class), sandbox).forward("getTopicConfig", LimitedProxyBuilder.methodParams(String.class), sandbox).forward("describeTopic", LimitedProxyBuilder.methodParams(String.class, Boolean.class), sandbox).forward("describeTopics", LimitedProxyBuilder.methodParams(Collection.class), sandbox).forward("describeTopics", LimitedProxyBuilder.methodParams(Collection.class, Boolean.class), sandbox).forward("deleteTopics", LimitedProxyBuilder.methodParams(Collection.class), sandbox).forward("listTopicsStartOffsets", LimitedProxyBuilder.methodParams(Collection.class), sandbox).forward("listTopicsEndOffsets", LimitedProxyBuilder.methodParams(Collection.class), sandbox).build();
    }

    private SandboxedKafkaTopicClient(KafkaTopicClient delegate, Supplier<Admin> sharedAdminClient) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.adminClient = Objects.requireNonNull(sharedAdminClient, "sharedAdminClient");
    }

    private void createTopic(String topic, int numPartitions, short replicationFactor) {
        this.createTopic(topic, numPartitions, replicationFactor, Collections.emptyMap());
    }

    private void createTopic(String topic, int numPartitions, short replicationFactor, Map<String, Object> configs) {
        if (this.isTopicExists(topic)) {
            Optional retentionMs = KafkaTopicClient.getRetentionMs(configs);
            this.validateTopicProperties(topic, numPartitions, replicationFactor, retentionMs);
            return;
        }
        short resolvedReplicationFactor = replicationFactor == -1 ? this.getDefaultClusterReplication() : replicationFactor;
        List replicas = IntStream.range(0, resolvedReplicationFactor).mapToObj(idx -> null).collect(Collectors.toList());
        List partitions = IntStream.range(1, numPartitions + 1).mapToObj(partition -> new TopicPartitionInfo(partition, null, replicas, Collections.emptyList())).collect(Collectors.toList());
        this.delegate.validateCreateTopic(topic, numPartitions, resolvedReplicationFactor, configs);
        this.createdTopics.put(topic, new TopicDescription(topic, false, partitions, (Set)Sets.newHashSet((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE})));
        this.createdTopicsConfig.put(topic, SandboxedKafkaTopicClient.toStringConfigs(configs));
    }

    private short getDefaultClusterReplication() {
        try {
            String defaultReplication = KafkaClusterUtil.getConfig(this.adminClient.get()).get(DEFAULT_REPLICATION_PROP).value();
            return Short.parseShort(defaultReplication);
        }
        catch (KsqlServerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KsqlServerException("Could not get default replication from Kafka cluster!", (Throwable)e);
        }
    }

    private boolean isTopicExists(String topic) {
        if (this.createdTopics.containsKey(topic)) {
            return true;
        }
        return this.delegate.isTopicExists(topic);
    }

    public TopicDescription describeTopic(String topicName) {
        return this.describeTopics((Collection<String>)ImmutableList.of((Object)topicName)).get(topicName);
    }

    public TopicDescription describeTopic(String topicName, Boolean skipRetriesOnFailure) {
        return this.describeTopics((Collection<String>)ImmutableList.of((Object)topicName), skipRetriesOnFailure).get(topicName);
    }

    private Map<String, TopicDescription> describeTopics(Collection<String> topicNames) {
        return this.describeTopics(topicNames, false);
    }

    private Map<String, TopicDescription> describeTopics(Collection<String> topicNames, Boolean skipRetriesOnFailure) {
        Map<String, TopicDescription> descriptions = topicNames.stream().map(this.createdTopics::get).filter(Objects::nonNull).collect(Collectors.toMap(TopicDescription::name, Function.identity()));
        HashSet<String> topicsToFetch = new HashSet<String>(topicNames);
        topicsToFetch.removeAll(descriptions.keySet());
        if (topicsToFetch.isEmpty()) {
            return descriptions;
        }
        Map remainingTopicDescriptionMap = this.delegate.describeTopics(topicsToFetch, skipRetriesOnFailure);
        descriptions.putAll(remainingTopicDescriptionMap);
        return descriptions;
    }

    public Map<String, String> getTopicConfig(String topicName) {
        if (this.createdTopicsConfig.containsKey(topicName)) {
            return this.createdTopicsConfig.get(topicName);
        }
        return this.delegate.getTopicConfig(topicName);
    }

    private void deleteTopics(Collection<String> topicsToDelete) {
        topicsToDelete.forEach(this.createdTopics::remove);
    }

    private void validateTopicProperties(String topic, int requiredNumPartition, int requiredNumReplicas, Optional<Long> requiredRetentionMs) {
        TopicDescription existingTopic = this.describeTopic(topic);
        Map<String, String> existingConfig = this.getTopicConfig(topic);
        TopicValidationUtil.validateTopicProperties(requiredNumPartition, requiredNumReplicas, requiredRetentionMs, existingTopic, existingConfig);
    }

    private Map<TopicPartition, Long> listTopicsStartOffsets(Collection<String> topics) {
        return this.delegate.listTopicsStartOffsets(topics);
    }

    private Map<TopicPartition, Long> listTopicsEndOffsets(Collection<String> topics) {
        return this.delegate.listTopicsEndOffsets(topics);
    }

    private static Map<String, String> toStringConfigs(Map<String, ?> configs) {
        return configs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
    }
}

