/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.services.ConnectClient;
import io.confluent.ksql.services.KafkaConsumerGroupClient;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.SandboxConnectClient;
import io.confluent.ksql.services.SandboxedKafkaClientSupplier;
import io.confluent.ksql.services.SandboxedKafkaConsumerGroupClient;
import io.confluent.ksql.services.SandboxedKafkaTopicClient;
import io.confluent.ksql.services.SandboxedSchemaRegistryClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.services.SimpleKsqlClient;
import io.confluent.ksql.util.Sandbox;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.streams.KafkaClientSupplier;

@Sandbox
public final class SandboxedServiceContext
implements ServiceContext {
    private final KafkaTopicClient topicClient;
    private final SchemaRegistryClient srClient;
    private final KafkaClientSupplier kafkaClientSupplier;
    private final Supplier<ConnectClient> connectClientSupplier;
    private final KafkaConsumerGroupClient consumerGroupClient;

    public static SandboxedServiceContext create(ServiceContext serviceContext) {
        if (serviceContext instanceof SandboxedServiceContext) {
            return (SandboxedServiceContext)serviceContext;
        }
        SandboxedKafkaClientSupplier kafkaClientSupplier = new SandboxedKafkaClientSupplier();
        KafkaTopicClient kafkaTopicClient = SandboxedKafkaTopicClient.createProxy(serviceContext.getTopicClient(), () -> ((ServiceContext)serviceContext).getAdminClient());
        SchemaRegistryClient schemaRegistryClient = SandboxedSchemaRegistryClient.createProxy(serviceContext.getSchemaRegistryClient());
        Supplier<ConnectClient> connectClientSupplier = () -> SandboxConnectClient.createProxy(serviceContext.getConnectClient());
        KafkaConsumerGroupClient kafkaConsumerGroupClient = SandboxedKafkaConsumerGroupClient.createProxy(serviceContext.getConsumerGroupClient());
        return new SandboxedServiceContext(kafkaClientSupplier, kafkaTopicClient, schemaRegistryClient, connectClientSupplier, kafkaConsumerGroupClient);
    }

    private SandboxedServiceContext(KafkaClientSupplier kafkaClientSupplier, KafkaTopicClient topicClient, SchemaRegistryClient srClient, Supplier<ConnectClient> connectClientSupplier, KafkaConsumerGroupClient consumerGroupClient) {
        this.kafkaClientSupplier = Objects.requireNonNull(kafkaClientSupplier, "kafkaClientSupplier");
        this.topicClient = Objects.requireNonNull(topicClient, "topicClient");
        this.srClient = Objects.requireNonNull(srClient, "srClient");
        this.connectClientSupplier = Objects.requireNonNull(connectClientSupplier, "connectClientSupplier");
        this.consumerGroupClient = Objects.requireNonNull(consumerGroupClient, "consumerGroupClient");
    }

    public Admin getAdminClient() {
        throw new UnsupportedOperationException();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public KafkaTopicClient getTopicClient() {
        return this.topicClient;
    }

    public KafkaClientSupplier getKafkaClientSupplier() {
        return this.kafkaClientSupplier;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public SchemaRegistryClient getSchemaRegistryClient() {
        return this.srClient;
    }

    public Supplier<SchemaRegistryClient> getSchemaRegistryClientFactory() {
        return () -> this.srClient;
    }

    public ConnectClient getConnectClient() {
        return this.connectClientSupplier.get();
    }

    public SimpleKsqlClient getKsqlClient() {
        throw new UnsupportedOperationException();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public KafkaConsumerGroupClient getConsumerGroupClient() {
        return this.consumerGroupClient;
    }

    public void close() {
    }
}

