/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import io.confluent.ksql.exception.KafkaTopicExistsException;
import io.confluent.ksql.services.KafkaTopicClient;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartitionInfo;

final class TopicValidationUtil {
    private TopicValidationUtil() {
    }

    public static void validateTopicProperties(int requiredNumPartition, int requiredNumReplicas, Optional<Long> requiredRetentionMs, TopicDescription existingTopic, Map<String, String> existingConfig) {
        int actualNumPartitions = existingTopic.partitions().size();
        int actualNumReplicas = ((TopicPartitionInfo)existingTopic.partitions().get(0)).replicas().size();
        Optional actualRetentionMs = KafkaTopicClient.getRetentionMs(existingConfig);
        String topicName = existingTopic.name();
        TopicValidationUtil.validateTopicProperties(topicName, requiredNumPartition, requiredNumReplicas, requiredRetentionMs, actualNumPartitions, actualNumReplicas, actualRetentionMs);
    }

    public static void validateTopicProperties(String topicName, int requiredNumPartition, int requiredNumReplicas, Optional<Long> requiredRetentionMs, int actualNumPartitions, int actualNumReplicas, Optional<Long> actualRetentionMs) {
        if (TopicValidationUtil.isInvalidPartitions(actualNumPartitions, requiredNumPartition) || TopicValidationUtil.isInvalidReplicas(actualNumReplicas, requiredNumReplicas) || TopicValidationUtil.isInvalidRetention(actualRetentionMs, requiredRetentionMs)) {
            String errMsg = String.format("A Kafka topic with the name '%s' already exists, with different partition/replica configuration than required. KSQL expects %d partitions (topic has %d), %d replication factor (topic has %d)", topicName, requiredNumPartition, actualNumPartitions, requiredNumReplicas, actualNumReplicas);
            if (requiredRetentionMs.isPresent() && actualRetentionMs.isPresent()) {
                errMsg = errMsg.replace("partition/replica", "partition/replica/retention");
                errMsg = String.format(errMsg + ", and %d retention (topic has %d).", requiredRetentionMs.get(), actualRetentionMs.get());
            } else {
                errMsg = errMsg + ".";
            }
            throw new KafkaTopicExistsException(errMsg, true);
        }
    }

    private static boolean isInvalidPartitions(int actualNumPartitions, int requiredNumPartition) {
        return actualNumPartitions != requiredNumPartition;
    }

    private static boolean isInvalidReplicas(int actualNumReplicas, int requiredNumReplicas) {
        return requiredNumReplicas != -1 && actualNumReplicas < requiredNumReplicas;
    }

    private static boolean isInvalidRetention(Optional<Long> actualRetentionMs, Optional<Long> requiredRetentionMs) {
        return requiredRetentionMs.isPresent() && actualRetentionMs.isPresent() && actualRetentionMs.get().longValue() != requiredRetentionMs.get().longValue();
    }
}

