/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.statement;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import java.util.List;

public final class InjectorChain
implements Injector {
    private final List<Injector> injectors;

    public static InjectorChain of(Injector ... injectors) {
        return new InjectorChain(injectors);
    }

    private InjectorChain(Injector ... injectors) {
        this.injectors = ImmutableList.copyOf((Object[])injectors);
    }

    @Override
    public <T extends Statement> ConfiguredStatement<T> inject(ConfiguredStatement<T> statement) {
        ConfiguredStatement<T> injected = statement;
        for (Injector injector : this.injectors) {
            injected = injector.inject(injected);
        }
        return injected;
    }
}

