/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.topic;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.SqlFormatter;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.WindowExpression;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.topic.SourceTopicsExtractor;
import io.confluent.ksql.topic.TopicProperties;
import io.confluent.ksql.util.KsqlException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TopicCreateInjector
implements Injector {
    private static final String CLEANUP_POLICY_PRESENT_EXCEPTION = String.format("Invalid config variable in the WITH clause: %s.%nThe %s config is automatically inferred based on the type of source (STREAM or TABLE).%nUsers can't set the %s config manually.", "CLEANUP_POLICY", "CLEANUP_POLICY", "CLEANUP_POLICY");
    private final KafkaTopicClient topicClient;
    private final MetaStore metaStore;

    public TopicCreateInjector(KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        this(serviceContext.getTopicClient(), executionContext.getMetaStore());
    }

    TopicCreateInjector(KafkaTopicClient topicClient, MetaStore metaStore) {
        this.topicClient = Objects.requireNonNull(topicClient, "topicClient");
        this.metaStore = Objects.requireNonNull(metaStore, "metaStore");
    }

    @Override
    public <T extends Statement> ConfiguredStatement<T> inject(ConfiguredStatement<T> statement) {
        return this.inject(statement, new TopicProperties.Builder());
    }

    @VisibleForTesting
    <T extends Statement> ConfiguredStatement<T> inject(ConfiguredStatement<T> statement, TopicProperties.Builder topicPropertiesBuilder) {
        if (statement.getStatement() instanceof CreateAsSelect) {
            return this.injectForCreateAsSelect(statement, topicPropertiesBuilder);
        }
        if (statement.getStatement() instanceof CreateSource) {
            return this.injectForCreateSource(statement, topicPropertiesBuilder);
        }
        return statement;
    }

    private ConfiguredStatement<? extends CreateSource> injectForCreateSource(ConfiguredStatement<? extends CreateSource> statement, TopicProperties.Builder topicPropertiesBuilder) {
        CreateSource createSource = statement.getStatement();
        CreateSourceProperties properties = createSource.getProperties();
        if (properties.getCleanupPolicy().isPresent()) {
            throw new KsqlException(CLEANUP_POLICY_PRESENT_EXCEPTION);
        }
        String topicCleanUpPolicy = createSource instanceof CreateTable ? "compact" : "delete";
        String topicName = properties.getKafkaTopic();
        if (this.topicClient.isTopicExists(topicName)) {
            topicPropertiesBuilder.withSource(() -> this.topicClient.describeTopic(topicName), () -> this.topicClient.getTopicConfig(topicName));
        } else if (!properties.getPartitions().isPresent()) {
            CreateSource example = createSource.copyWith(createSource.getElements(), properties.withPartitions(2));
            throw new KsqlException("Topic '" + topicName + "' does not exist. If you want to create a new topic for the stream/table please re-run the statement providing the required '" + "PARTITIONS" + "' configuration in the WITH clause (and optionally '" + "REPLICAS" + "'). For example: " + SqlFormatter.formatSql((AstNode)example));
        }
        this.throwIfRetentionPresentForTable(topicCleanUpPolicy, properties.getRetentionInMillis());
        topicPropertiesBuilder.withName(topicName).withWithClause(Optional.of(properties.getKafkaTopic()), properties.getPartitions(), properties.getReplicas(), properties.getRetentionInMillis());
        this.createTopic(topicPropertiesBuilder, topicCleanUpPolicy);
        return TopicCreateInjector.buildConfiguredStatement(statement, properties.withCleanupPolicy(topicCleanUpPolicy));
    }

    private <T extends CreateAsSelect> ConfiguredStatement<?> injectForCreateAsSelect(ConfiguredStatement<T> statement, TopicProperties.Builder topicPropertiesBuilder) {
        String topicCleanUpPolicy;
        String prefix = statement.getSessionConfig().getConfig(true).getString("ksql.output.topic.name.prefix");
        CreateAsSelect createAsSelect = (CreateAsSelect)statement.getStatement();
        CreateSourceAsProperties properties = createAsSelect.getProperties();
        if (properties.getCleanupPolicy().isPresent()) {
            throw new KsqlException(CLEANUP_POLICY_PRESENT_EXCEPTION);
        }
        SourceTopicsExtractor extractor = new SourceTopicsExtractor(this.metaStore);
        extractor.process((AstNode)((CreateAsSelect)statement.getStatement()).getQuery(), null);
        String sourceTopicName = extractor.getPrimarySourceTopic().getKafkaTopicName();
        topicPropertiesBuilder.withName(prefix + createAsSelect.getName().text()).withSource(() -> this.topicClient.describeTopic(sourceTopicName), () -> this.topicClient.getTopicConfig(sourceTopicName)).withWithClause(properties.getKafkaTopic(), properties.getPartitions(), properties.getReplicas(), properties.getRetentionInMillis());
        HashMap<String, Object> additionalTopicConfigs = new HashMap<String, Object>();
        if (createAsSelect instanceof CreateStreamAsSelect) {
            topicCleanUpPolicy = "delete";
        } else if (createAsSelect.getQuery().getWindow().isPresent()) {
            topicCleanUpPolicy = "compact,delete";
            ((WindowExpression)createAsSelect.getQuery().getWindow().get()).getKsqlWindowExpression().getRetention().ifPresent(retention -> additionalTopicConfigs.put("retention.ms", retention.toDuration().toMillis()));
        } else {
            topicCleanUpPolicy = "compact";
        }
        this.throwIfRetentionPresentForTable(topicCleanUpPolicy, properties.getRetentionInMillis());
        TopicProperties info = this.createTopic(topicPropertiesBuilder, topicCleanUpPolicy, additionalTopicConfigs);
        CreateSourceAsProperties injectedProperties = properties.withTopic(info.getTopicName(), info.getPartitions(), info.getReplicas(), ((Long)additionalTopicConfigs.getOrDefault("retention.ms", info.getRetentionInMillis())).longValue()).withCleanupPolicy(topicCleanUpPolicy);
        return TopicCreateInjector.buildConfiguredStatement(statement, injectedProperties);
    }

    private void throwIfRetentionPresentForTable(String topicCleanUpPolicy, Optional<Long> retentionInMillis) {
        if (topicCleanUpPolicy.equals("compact") && retentionInMillis.isPresent()) {
            throw new KsqlException("Invalid config variable in the WITH clause: RETENTION_MS. Non-windowed tables do not support retention.");
        }
    }

    private TopicProperties createTopic(TopicProperties.Builder topicPropertiesBuilder, String topicCleanUpPolicy) {
        return this.createTopic(topicPropertiesBuilder, topicCleanUpPolicy, Collections.emptyMap());
    }

    private TopicProperties createTopic(TopicProperties.Builder topicPropertiesBuilder, String topicCleanUpPolicy, Map<String, Object> additionalTopicConfigs) {
        TopicProperties info = topicPropertiesBuilder.build();
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("cleanup.policy", topicCleanUpPolicy);
        if (additionalTopicConfigs.containsKey("retention.ms")) {
            config.put("retention.ms", Math.max(info.getRetentionInMillis(), (Long)additionalTopicConfigs.get("retention.ms")));
            additionalTopicConfigs.remove("retention.ms");
        } else {
            config.put("retention.ms", info.getRetentionInMillis());
        }
        config.putAll(additionalTopicConfigs);
        if (topicCleanUpPolicy.equals("compact")) {
            config.remove("retention.ms");
        }
        this.topicClient.createTopic(info.getTopicName(), info.getPartitions(), info.getReplicas(), config);
        return info;
    }

    private static ConfiguredStatement<CreateSource> buildConfiguredStatement(ConfiguredStatement<? extends CreateSource> original, CreateSourceProperties injectedProps) {
        CreateSource statement = original.getStatement();
        CreateSource withProps = statement.copyWith(original.getStatement().getElements(), injectedProps);
        KsqlParser.PreparedStatement<CreateSource> prepared = TopicCreateInjector.buildPreparedStatement(withProps);
        return ConfiguredStatement.of(prepared, original.getSessionConfig());
    }

    private static ConfiguredStatement<CreateAsSelect> buildConfiguredStatement(ConfiguredStatement<? extends CreateAsSelect> original, CreateSourceAsProperties injectedProps) {
        CreateAsSelect statement = original.getStatement();
        CreateAsSelect withProps = statement.copyWith(injectedProps);
        KsqlParser.PreparedStatement<CreateAsSelect> prepared = TopicCreateInjector.buildPreparedStatement(withProps);
        return ConfiguredStatement.of(prepared, original.getSessionConfig());
    }

    private static <T extends Statement> KsqlParser.PreparedStatement<T> buildPreparedStatement(T stmt) {
        String formattedSql = SqlFormatter.formatSql(stmt);
        if (!formattedSql.endsWith(";")) {
            formattedSql = formattedSql + ";";
        }
        return KsqlParser.PreparedStatement.of((String)formattedSql, stmt);
    }
}

