/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogMessageSchema;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.util.ErrorMessageUtil;
import java.util.Objects;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;

public final class KafkaStreamsThreadError
implements ProcessingLogger.ErrorMessage {
    private final String errorMsg;
    private final Thread thread;
    private final Throwable exception;

    public static KafkaStreamsThreadError of(String errorMsg, Thread thread, Throwable exception) {
        return new KafkaStreamsThreadError(errorMsg, thread, exception);
    }

    private KafkaStreamsThreadError(String errorMsg, Thread thread, Throwable exception) {
        this.errorMsg = Objects.requireNonNull(errorMsg, "errorMsg");
        this.thread = Objects.requireNonNull(thread, "thread");
        this.exception = Objects.requireNonNull(exception, "exception");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaStreamsThreadError that = (KafkaStreamsThreadError)o;
        return Objects.equals(this.errorMsg, that.errorMsg) && Objects.equals(this.thread.getName(), this.thread.getName()) && Objects.equals(this.exception.getClass(), that.exception.getClass()) && Objects.equals(this.exception.toString(), that.exception.toString());
    }

    public int hashCode() {
        return Objects.hash(this.thread, this.exception);
    }

    public SchemaAndValue get(ProcessingLogConfig config) {
        Struct struct = new Struct(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA).put("type", (Object)ProcessingLogMessageSchema.MessageType.KAFKA_STREAMS_THREAD_ERROR.getTypeId()).put("kafkaStreamsThreadError", (Object)this.streamsThreadError());
        return new SchemaAndValue(ProcessingLogMessageSchema.PROCESSING_LOG_SCHEMA, (Object)struct);
    }

    private Struct streamsThreadError() {
        Struct threadError = new Struct(ProcessingLogMessageSchema.MessageType.KAFKA_STREAMS_THREAD_ERROR.getSchema()).put("threadName", (Object)this.thread.getName()).put("errorMessage", (Object)this.errorMsg).put("cause", (Object)ErrorMessageUtil.getErrorMessages((Throwable)this.exception));
        return threadError;
    }
}

